#ifndef GRAPE7E_H
#define GRAPE7E_H

#include <asm/page.h>
#include <linux/ioctl.h>
#include "typedef.h"

#define GRAPE7E_DEVNAME "grape7e"
#define NGRAPE7E (0) /* max # of device */

// size of DMA buffers
#ifndef PAGE_SIZE
#define PAGE_SIZE sysconf (_SC_PAGE_SIZE)
#endif
#define GRAPE7E_DMABUF_ORDER (5) /* 2^5 pages */
#define GRAPE7E_DMABUF_BYTES (PAGE_SIZE * (1<<GRAPE7E_DMABUF_ORDER)) /* 128kbyte, 32pages */
#define GRAPE7E_DMABUF_WORDS (GRAPE7E_DMABUF_BYTES>>2) /* dma buffer size in quad-word */

#define GRAPE7E_PIOWBUF_BYTES (4096)     // size of double buffer for PIO write
#define GRAPE7E_LOCAL_MEM_BYTES (8192)   // size of local register
#define GRAPE7E_BACKEND_MEM_BYTES (8192) // size of backend space

/* structure for read/write ioctl */

enum {
    GRAPE7E_MAP_HIBMEM = 0,
    GRAPE7E_MAP_DMARBUF,
    GRAPE7E_MAP_DMAWBUF,
    GRAPE7E_MAP_BACKEND,
    GRAPE7E_MAP_DBLBUF,
};

#define GRAPE7E_MAGIC (5)
#define GRAPE7E_WRITE_CFG            _IOW(GRAPE7E_MAGIC, 5, struct long_access)
#define GRAPE7E_READ_CFG             _IOWR(GRAPE7E_MAGIC, 4, struct long_access)
#define GRAPE7E_GET_DMAR_PA          _IOWR(GRAPE7E_MAGIC, 18, unsigned long)
#define GRAPE7E_GET_DMAW_PA          _IOWR(GRAPE7E_MAGIC, 19, unsigned long)
#define GRAPE7E_SET_MAP_MODE         _IOW(GRAPE7E_MAGIC, 20, unsigned int)


#define GRAPE7E_DMA0LSB  (0x00)
#define GRAPE7E_DMA0MSB  (0x04)
#define GRAPE7E_DMA0SIZE (0x08)
#define GRAPE7E_DMA0CMD  (0x0c)
#define GRAPE7E_DMA0MISC (0x28)

#define GRAPE7E_DMA1LSB  (0x10)
#define GRAPE7E_DMA1MSB  (0x14)
#define GRAPE7E_DMA1SIZE (0x18)
#define GRAPE7E_DMA1CMD  (0x1c)
#define GRAPE7E_DMA1MISC (0x2c)

#define GRAPE7E_DMASTAT    (0x20)
#define GRAPE7E_MAILBOX    (0x24)
#define GRAPE7E_BOARDINFO  (0x30)
#define GRAPE7E_ASMI       (0x38)
#define GRAPE7E_PLLCONF    (0x40)

#define GRAPE7E_DMA0CMD_KICKOFF           (0x00000000)
    /* address map of EHIB DMA control register (0x28)
     *
     * 63..47: not used
     * 46:     sram1_wlock
     * 45:     dma1_done
     * 44..32: dma1_fifocnt(12..0)
     * 31..25: not used
     * 24..16: sram_wcnt(8..0)
     * 15:     swap_sram_reg
     * 14:     sram0_wlock
     * 13:     dma0_done
     * 12..0:  dma0_fifo_cnt(12..0)
     */
#define GRAPE7E_DMA0MISC_DONE_BIT         (13)
#define GRAPE7E_DMA0MISC_SWAP_SRAM_BIT    (15)
#define GRAPE7E_DMA0MISC_SRAM_WCNT_BIT    (16)

#define GRAPE7E_DMA1CMD_KICKOFF           (0x00000000)
#define GRAPE7E_DMA1MISC_DONE_BIT         (13)
#define GRAPE7E_DMASTAT_RESET_BACKEND_BIT (30)
#define GRAPE7E_DMASTAT_DMA_RESET_BIT     (31)

#define GRAPE7E_ASMI_ERROR_BIT (1)
#define GRAPE7E_ASMI_BUSY_BIT  (0)
#define GRAPE7E_ASMI_CMD_RSID  (0xfffffd00)
#define GRAPE7E_ASMI_CMD_WP    (0xfffffe00)
#define GRAPE7E_ASMI_CMD_EB    (0xffffff00)

#define GRAPE7E_PLLCONF_WRITE_BIT    (0)
#define GRAPE7E_PLLCONF_RECONFIG_BIT (2)
#define GRAPE7E_PLLCONF_BUSY_BIT     (0)

#endif /* GRAPE7E_H */
