#! /bin/csh

if (${#argv} < 2) then
  echo ''
  echo Link device driver of GRAPE-7 Host Interface Bridge \(HIB\) to kernel image.
  echo usage: $0 module_name vendorID:deviceID
  echo ''
  exit (1)
endif 

set module = $1
set device = $1
set vid_did = $2

set group = "wheel"
set mode = "666"

echo ''
echo -- install module ${module} --
# set ndriver = `grep '1556:0070' /proc/pci | wc | awk '{print $1}'`
# set ndriver = `lspci -d '1556:' | wc | awk '{print $1}'`

if (-x /sbin/lspci) then
    set lspci = /sbin/lspci
else
    if (-x `which lspci`) then
        set lspci = `which lspci`
    else
      echo command \'lspci\' not found.
      echo you may need to set PATH so that it includes
      echo the directory where lspci is located.
      goto LABEL_EXIT
    endif
endif

(${lspci} -d ${vid_did} | wc | awk '{print $1}' > /tmp/tmp$$) >& /dev/null
set ndriver = `cat /tmp/tmp$$`
\rm -f /tmp/tmp$$

if (${ndriver} == 0) then
  echo "${module}: No GRAPE-7 found."
  goto LABEL_EXIT
endif

echo "${module}: ${ndriver} GRAPE-7(s) found."
echo ''
echo rm -f /dev/${device}\[0-9\]
rm -f /dev/${device}[0-9] >& /dev/null
echo ''
echo /sbin/insmod -f ${module}.ko
/sbin/insmod -f ${module}.ko

set major = `cat /proc/devices | awk '$2=="'${module}'"{print $1}' | tail -1`

set i = 0
while (${i} < ${ndriver})
  echo mknod /dev/${device}${i} c ${major} ${i}
  mknod /dev/${device}${i} c ${major} ${i}
  @ i++
end

echo ''
echo chgrp ${group} /dev/${device}?
chgrp ${group} /dev/${device}?
echo ''
echo chmod ${mode} /dev/${device}?
chmod ${mode} /dev/${device}?

LABEL_EXIT:
ls -l /dev/${device}?
echo -- done --
echo ''
