#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "hibutil.h"

/* send_fpga_data
   address: 0x20 for g6a
   data:
   LSB:  dclk
   1:  data0
   2: nconfig
   file format: ttf (comma-separatted decimal byte data)
   bit order: should send lsb first
*/

Hib *hib;
static UINT64 *rbuf;
static UINT64 *wbuf;
static UINT64 *backend;

void configuration(nconf,model,devid,ttfnamebase)
     UINT64 nconf;
     char model[];
     int devid;
     char ttfnamebase[];
{

    UINT64 data64;
    int i,j,k,nn,sum;
    double drand48(),srend48();
    double lt,st;

    FILE *fopen(),*fin[6];
    int adr,data0[6],dclk,datacount;
    int iii,cnt,ii;
    int datacnt;
    int use_p126_ttfs;
    char ttfname[256];

    static int data[6][2000000],n,initflag=1;

    datacount = 0;
    if(initflag==1){
	// !!!
        sprintf(ttfname, "./cid1_%s.ttf", ttfnamebase);
	fin[0] = fopen(ttfname,"r");
	if (fin[0]) {
	    use_p126_ttfs = 0; // use different .ttf for different chip.
	    fprintf(stderr, "found '%s'.\n", ttfname);
	    fprintf(stderr, "configure with 'cid[1-6]_%s.ttf'.\n", ttfnamebase);

            sprintf(ttfname, "./cid2_%s.ttf", ttfnamebase);
	    fin[1] = fopen(ttfname,"r");

            sprintf(ttfname, "./cid3_%s.ttf", ttfnamebase);
	    fin[2] = fopen(ttfname,"r");

            sprintf(ttfname, "./cid4_%s.ttf", ttfnamebase);
	    fin[3] = fopen(ttfname,"r");

            sprintf(ttfname, "./cid5_%s.ttf", ttfnamebase);
	    fin[4] = fopen(ttfname,"r");

            sprintf(ttfname, "./cid6_%s.ttf", ttfnamebase);
	    fin[5] = fopen(ttfname,"r");

	    if (!fin[1] || !fin[2] || !fin[3] || !fin[4] || !fin[5]) {
		fprintf(stderr, "one or more of 'cid[2-6]_%s.ttf' not found. abort.\n", ttfnamebase);
		exit(1);
	    }
	}
	else {
            sprintf(ttfname, "./p1_%s.ttf", ttfnamebase);
            fin[0] = fopen(ttfname,"r");
	    if (fin[0]) {
		use_p126_ttfs = 1; // share .ttf among chip[03] and chip[124].
		fprintf(stderr, "found 'p1_%s.ttf'.\n", ttfnamebase);
		fprintf(stderr, "configure with 'p[126]_%s.ttf'.\n", ttfnamebase);

                sprintf(ttfname, "./p2_%s.ttf", ttfnamebase);
		fin[1] = fopen(ttfname,"r");

                sprintf(ttfname, "./p6_%s.ttf", ttfnamebase);
		fin[2] = fopen(ttfname, "r");

		if (!fin[1] || !fin[2]) {
                    fprintf(stderr, "one or more of 'p[26]_%s.ttf' not found. abort.\n", ttfnamebase);
		    exit(1);
		}
	    }
	    else {
		fprintf(stderr, "neither 'cid[1-6]_%s.ttf' nor 'p[126]_%s.ttf' found. abort.\n",
                        ttfnamebase, ttfnamebase);
		exit(1);
	    }
	}

	if (use_p126_ttfs) {
	    for(i=0;fscanf(fin[0], "%d,",&data[0][i])!=EOF;i++);
	    n=i;
	    printf("fin0: %d\n",i);
	    for(i=0;fscanf(fin[1], "%d,",&data[1][i])!=EOF;i++);
	    printf("fin1: %d\n",i);
	    for(i=0;fscanf(fin[2], "%d,",&data[2][i])!=EOF;i++);
	    printf("fin2: %d\n",i);
	}
	else {
	    for (k=0;k<6;k++) {
		for(i=0;fscanf(fin[k], "%d,",&data[k][i])!=EOF;i++);
		printf("fin%d: %d\n",k,i);
	    }
	    n=i;
	}

	fclose(fin[0]);
	fclose(fin[1]);
	fclose(fin[2]);

	initflag=0;
    }

    data64 = 0x0000001000000010ll;   /* config */
    backend[0]  = data64;
    usleep(1000);

    if(strcmp(model,"300d")==0){
	data64 = 0x0000010000000100ll;   /* rx */
    }else{
	data64 = 0x0000020000000200ll;   /* rx */
    }

    backend[0]  = data64;
    usleep(1000);

    fprintf(stderr,"nconf = 0x%x\n", nconf);

    nn=40;
    for(i=0;i<nn;i++) rbuf[i]  = 0x0000000000000000ll | (nconf<<12);
    hib_dmarMC(devid, nn, rbuf);

    usleep(1000);

    for(i=0;i<nn;i++) rbuf[i]  = 0x0000000000000000ll;
    hib_dmarMC(devid, nn, rbuf);
    usleep(1000);


    ii = 0;
    for(j=0;j<n;j++){

	for(i=0;i<8;i++){

	    if (use_p126_ttfs) {
		data0[0] = 0x1 & (data[0][j]>>i);
		data0[1] = 0x1 & (data[1][j]>>i);
		data0[2] = 0x1 & (data[1][j]>>i);
		data0[3] = 0x1 & (data[0][j]>>i);
		data0[4] = 0x1 & (data[1][j]>>i);
		data0[5] = 0x1 & (data[2][j]>>i);
	    }
	    else { // do not share .ttf files
		data0[0] = 0x1 & (data[0][j]>>i);
		data0[1] = 0x1 & (data[1][j]>>i);
		data0[2] = 0x1 & (data[2][j]>>i);
		data0[3] = 0x1 & (data[3][j]>>i);
		data0[4] = 0x1 & (data[4][j]>>i);
		data0[5] = 0x1 & (data[5][j]>>i);
	    }

	    data64 = (data0[5]<<11) | (data0[4]<<10) | (data0[3]<<9)
		| (data0[2]<<8) | (data0[1]<<7) | (data0[0]<<6);

	    rbuf[ii]  = data64;
	    ii++;
	    //       rbuf[ii]  = data64;
	    //       ii++;

	    data64 = (data0[5]<<11) | (data0[4]<<10) | (data0[3]<<9)
		| (data0[2]<<8) | (data0[1]<<7) | (data0[0]<<6) | nconf;

	    rbuf[ii]  = data64;
	    ii++;
	    //       rbuf[ii]  = data64;
	    //       ii++;

	}
	datacount++;

	if((j==(n-1))||(ii>1000)){
	    hib_dmarMC(devid, ii, rbuf);
	    ii=0;
	}

	//     if ((datacount & 0x1ff) == 0) usleep(1);

	if ((datacount & 0x7ffff) == 0){
	    fprintf(stderr,"datacount = %x %d\n", datacount,datacount);
	}
    }

    data64 = 0x0000000000000000ll;
    backend[0]  = data64;
    usleep(1000);

}

void sample(sdata,chipdata,result)
     UINT64 sdata;
     UINT64 chipdata[];
UINT64 *result;
{
    int n,i;
    UINT64 data;

    *result = 0;

    backend[0] = 0x0000000700000007ll;
    usleep(1000);
    n = 10;
    for(i=0;i<n;i++){

	rbuf[i] = ((sdata*i)<<56) | ((sdata*i)<<52) | ((sdata*i)<<48)
	    | ((sdata*i)<<44) | ((sdata*i)<<40) | ((sdata*i)<<36)
	    | ((sdata*i)<<32) | ((sdata*i)<<28) | ((sdata*i)<<24)
	    | ((sdata*i)<<20) | ((sdata*i)<<16) | ((sdata*i)<<12)
	    | ((sdata*i)<<8) | ((sdata*i)<<4) | sdata*i;
	//      rbuf[i] = sdata;

	wbuf[i] = 0;
    }
    hib_dmarMC(0, n, rbuf);
    hib_dmawMC(0, n, wbuf);
    for(i=0;i<n;i++){
	printf("i %x rbuf 0x%016llx wbuf 0x%016llx %llx\n", i,rbuf[i], wbuf[i],rbuf[i]-wbuf[i]);
	*result += (rbuf[i]-wbuf[i]);
    }
    data = backend[0];
    printf("data 0x%016llx\n", data);
    for(i=0;i<8;i++) chipdata[i] = 0xf&(data>>(4*i));
    printf("chip data %x %x %x %x %x %x\n",
	   chipdata[5],chipdata[4],chipdata[3],chipdata[2],chipdata[1],chipdata[0]);
    backend[0] = 0x0000000000000000ll;
    usleep(1000);
}

static int
getdma1datacnt(int devid, Hib *h)
{
    int datacnt;

    switch (h->type) {
      case HIB_GRAPE7X:
	datacnt =  8 * (hib_mem_readMC(devid, h->dma1misc) & 0x7ff);
	// in PCI-X core, datacnt is counted in 64-bit word unit.
	break;
      case HIB_GRAPE7E:
	datacnt =  (hib_mem_readMC(devid, h->dma1misc) & 0x1fff);
	// in PCIe core, datacnt is counted in byte unit.
	break;
      default:
	datacnt = 0;
	fprintf(stderr, "getdma1datacnt: unknown Hib type: %d\n", h->type);
	exit(2);
    }
    return datacnt;
}

void reset_after_config(int devid)
{
    int datacnt;

    hib_mem_writeMC(devid, hib->dmastat, (1<<hib->dmastat_reset_backend_bit));
    usleep(1000);
    hib_mem_writeMC(devid, hib->dmastat, (1<<hib->dmastat_dma_reset_bit));
    usleep(1000);

    while (datacnt = getdma1datacnt(devid, hib)) {
	usleep(3000000/datacnt);
	hib_recvMC(devid, 1, wbuf);
    }
}

int
main(int argc, char **argv)
{
    Hib *h;
    UINT64 nconf,result;
    UINT64 sdata,chipdata[8];
    int i,n,cnt,devid,tmpmod,npipe;
    FILE *bifp;
    char buf[128];
    int pot, nbsearch, cutoff, epsfmt, jmem, npipe0=0;
    UINT32 binfo;
    char model[32];
    char ttfnamebase[128];

    if (argc < 2 || 4 < argc) {
        fprintf(stderr, "reconfigure pFPGAs\n");
        fprintf(stderr, "  usage: %s <ttf-file-base-name> [devid]\n", argv[0]);
        fprintf(stderr, "     ex) %s pfpga 0\n", argv[0]);
        fprintf(stderr, "         will configure the pFPGAs of device 0 with p[126]_pfpga.ttf\n");
        exit(1);
    }

    if (!strncmp(argv[0], "config300d", sizeof(model))) {
        strcpy(model, "300d");
    }
    else if (!strncmp(argv[0], "config300", sizeof(model))) {
        strcpy(model, "300");
    }
    else if (!strncmp(argv[0], "config600", sizeof(model))) {
        strcpy(model, "600");
    }
    else {
        fprintf(stderr, "model '%s' not supported. abort.\n", argv[0]);
        exit(1);
    }

    strncpy(ttfnamebase, argv[1], sizeof(ttfnamebase));
    if (argc < 3){
        devid = 0;
    }else{
        devid = atoi(argv[2]);
    }
    printf("devid: %d  model: %s  ttfnamebase: %s\n",
           devid, model, ttfnamebase);

    hib = hib_openMC(devid);
    rbuf = hib->dmar_buf;
    wbuf = hib->dmaw_buf;
    backend = (UINT64*)hib->backend;

    sdata = 0x5;
    binfo = hib_mem_readMC(devid, hib->boardinfo);
    binfo &= 0xf00fff00;
    binfo |= 0x00100000;

    if(strcmp(model,"600")==0){
        fprintf(stderr, "**** Configuration for model600 [1-6] ****\n");
        nconf = 0x3f;
        configuration(nconf,model,devid,ttfnamebase);
        nconf = 0x9;
        configuration(nconf,model,devid,ttfnamebase);
        nconf = 0x12;
        configuration(nconf,model,devid,ttfnamebase);
        nconf = 0x24;
        configuration(nconf,model,devid,ttfnamebase);

        //       sample(sdata,chipdata,&result);

        fprintf(stderr,"configuration finished\n");

        backend[0]  = 0x0000030000000300ll;   /* adder */
        usleep(1000);

        binfo |= 0x06000000;
        hib_mem_writeMC(devid, hib->boardinfo, binfo);
        fprintf(stderr, "binfo: 0x%08x\n", binfo);

        reset_after_config(devid);
    }

    if(strcmp(model,"300")==0){
        fprintf(stderr, "**** Configuration for model300 [4-6] ****\n");
        nconf = 0x38;
        configuration(nconf,model,devid,ttfnamebase);
        nconf = 0x8;
        configuration(nconf,model,devid,ttfnamebase);
        nconf = 0x10;
        configuration(nconf,model,devid,ttfnamebase);
        nconf = 0x20;
        configuration(nconf,model,devid,ttfnamebase);
        //       sample(sdata,chipdata,&result);

        fprintf(stderr,"configuration finished\n");

        backend[0]  = 0x0000020000000200ll;   /* rx */
        usleep(1000);

        binfo |= 0x03000000;
        hib_mem_writeMC(devid, hib->boardinfo, binfo);

        reset_after_config(devid);
    }

    if(strcmp(model,"300d")==0){
        fprintf(stderr, "**** Configuration for model300D [1-3] ****\n");
        nconf = 0x7;
        configuration(nconf,model,devid,ttfnamebase);
        nconf = 0x1;
        configuration(nconf,model,devid,ttfnamebase);
        nconf = 0x2;
        configuration(nconf,model,devid,ttfnamebase);
        nconf = 0x4;
        configuration(nconf,model,devid,ttfnamebase);
        //    sample(sdata,chipdata,&result);

        fprintf(stderr,"configuration finished\n");
        backend[0]  = 0x0000010000000100ll;   /* rx */
        usleep(1000);

        binfo |= 0x02000000;
        hib_mem_writeMC(devid, hib->boardinfo, binfo);

        reset_after_config(devid);
    }
    hib_closeMC(devid);
}
