#define DEBUG (1)

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include <pcixmem.h>
#include "xhibutil.h"
#include "memmap.h"

/* local var(s) */

static char *devname[] =
{
    "/dev/"DEVNAME"0",
    "/dev/"DEVNAME"1",
    "/dev/"DEVNAME"2",
    "/dev/"DEVNAME"3",
    "/dev/"DEVNAME"4",
    "/dev/"DEVNAME"5",
    "/dev/"DEVNAME"6",
    "/dev/"DEVNAME"7",
};

static int mapped[][2] =
{
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
};

static int fd[] =
{
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static UINT32 *mptr[NPCIXMEM];
static UINT64 *bptr[NPCIXMEM];
static UINT64 *dptr[NPCIXMEM];

/* local func(s) */
static void TBmemMap(int devid, UINT64 **backend, UINT64 **dblbuf);

void
TBgetDmaInfo(int devid,
	     unsigned long *dmarpa, UINT64 **dmarva,
	     unsigned long *dmawpa, UINT64 **dmawva)
     /*
      * pa: physical addr of DMA read/write buf alloced in the kernel space
      * va: virtual addr (in the user process context) pa is mapped to
      */
{
    size_t psz = getpagesize();

    /* map DMA read buffer */
    if (-1 == ioctl(fd[devid], GET_DMAR_PA, dmarpa)) {
	perror("TBgetDmaInfo() failed");
	exit (1);
    };
    if (-1 == ioctl(fd[devid], SET_MAP_MODE, MAP_DMARBUF)) {
	perror("TBgetDmaInfo() failed");
	exit (1);
    };
    *dmarva = mmap(NULL,
		   ((DMABUF_BYTES-1)/psz+1)*psz,
		   PROT_READ | PROT_WRITE,
		   MAP_SHARED,
		   fd[devid],
		   0);
    if ((long int)(*dmarva) == -1) {
	perror("TBgetDmaInfo");
	exit (1);
    }

    /* map DMA write buffer */
    if (-1 == ioctl(fd[devid], GET_DMAW_PA, dmawpa)) {
	perror("TBgetDmaInfo() failed");
	exit (1);
    };
    if (-1 == ioctl(fd[devid], SET_MAP_MODE, MAP_DMAWBUF)) {
	perror("TBgetDmaInfo() failed");
	exit (1);
    };
    *dmawva = mmap(NULL,
		   ((DMABUF_BYTES-1)/psz+1)*psz,
		   PROT_READ | PROT_WRITE,
		   MAP_SHARED,
		   fd[devid],
		   0);
    if ((long int)(*dmawva) == -1) {
	perror("TBgetDmaInfo");
	exit (1);
    }
    if (-1 == ioctl(fd[devid], SET_MAP_MODE, MAP_XHIBMEM)) {
	perror("TBgetDmaInfo() failed");
	exit (1);
    };
}

UINT32
TBconfigRead(int devid, UINT32 addr)
{
    struct long_access ca;
    ca.addr = addr;
    ca.data = 0;

    if (fd[devid] < 0)
    {
	fprintf(stderr, "open %s first\n", devname[devid]);
	exit (1);
    }
    ioctl(fd[devid], READ_CFG, &ca);
    return (ca.data);
}

void
TBconfigWrite(int devid, UINT32 addr, UINT32 value)
{
    struct long_access ca;
    ca.addr = addr;
    ca.data = value;

    if (fd[devid] < 0)
    {
	fprintf(stderr, "open %s first\n", devname[devid]);
	exit (1);
    }
    ioctl(fd[devid], WRITE_CFG, &ca);
}

void
TBmemWrite(int devid, UINT32 addr, UINT32 value)
{
    mptr[devid][addr>>2] = value;
    MB;
}

UINT32
TBmemRead(int devid, UINT32 addr)
{
    UINT32 ret;

    ret =  mptr[devid][addr>>2];
    MB;
    return (ret);
}

UINT64
TBmemRead64(int devid, UINT32 addr)
{
    UINT64 ret;

    ret =  mptr[devid][addr>>2];
    MB;
    return (ret);
}

static void
TBmemMap(int devid, UINT64 **backend, UINT64 **dblbuf)
{
    unsigned int bar0;
    size_t psz = getpagesize();

    if (mapped[devid][1]) return;
    if (fd[devid] < 0)
    {
	fprintf(stderr, "open %dth device first\n",
		devid);
	exit (1);
    }
    /*
    bar0 = TBconfigRead(devid, 0x10);
    bar0 &= 0xfffffff0;
    printf("bar0: 0x%08x\n", bar0);
    */
    mptr[devid] = mmap(NULL,
		       (LOCAL_MEM_BYTES/psz+1)*psz,
		       PROT_READ | PROT_WRITE,
		       MAP_SHARED,
		       fd[devid],
		       0); /* device driver (pcixmem) take care of bar0 offset */

    if ((long int)mptr[devid] == -1)
    {
	fprintf(stderr, "%s\n", devname[devid]);
	exit (1);
    }
    // printf("mptr[%d]: 0x%08lx\n", devid, mptr[devid]);

    TBconfigWrite(devid, 0x4, 0x107);
    //    TBconfigWrite(devid, 0x4, 0x1ff);

    if (-1 == ioctl(fd[devid], SET_MAP_MODE, MAP_BACKEND)) {
	perror("TBmemMap() failed");
	exit (1);
    };
    bptr[devid] = mmap(NULL,
		       (BACKEND_MEM_BYTES/psz+1)*psz,
		       PROT_READ | PROT_WRITE,
		       MAP_SHARED,
		       fd[devid],
		       0); /* device driver (pcixmem) take care of bar1 offset */

    if ((long int)bptr[devid] == -1)
    {
	fprintf(stderr, "%s\n", devname[devid]);
	exit (1);
    }
    *backend = bptr[devid];
    // printf("bptr[%d]: 0x%08lx\n", devid, bptr[devid]);
    if (-1 == ioctl(fd[devid], SET_MAP_MODE, MAP_XHIBMEM)) {
	perror("TBmemMap() failed");
	exit (1);
    };

    if (-1 == ioctl(fd[devid], SET_MAP_MODE, MAP_DBLBUF)) {
	perror("TBmemMap() failed");
	exit (1);
    };
    dptr[devid] = mmap(NULL,
                       ((PIOWBUF_BYTES)/psz+1)*psz,
		       PROT_READ | PROT_WRITE,
		       MAP_SHARED,
		       fd[devid],
		       0); /* device driver (pcixmem) take care of bar1 offset */

    if ((long int)dptr[devid] == -1)
    {
	fprintf(stderr, "%s\n", devname[devid]);
	exit (1);
    }
    *dblbuf = dptr[devid];
    // printf("dptr[%d]: 0x%08lx\n", devid, dptr[devid]);
    if (-1 == ioctl(fd[devid], SET_MAP_MODE, MAP_XHIBMEM)) {
	perror("TBmemMap() failed");
	exit (1);
    };

    mapped[devid][1] = 1;
}

/*
  arguments:
    devid: device id.
    backend: memory space mapped to the back end of XHIB.

  return values:
    non 0: mapped address of XHIB local memory
    0: failure
  */
UINT32 *
TBopen(int devid, UINT64 **backend, UINT64 **dblbuf)
{
    int ic;
    static int firstcall = 1;
    char buff[256];

    if (firstcall)
    {
	for (ic = 0; ic < NPCIXMEM; ic++)
	{
	    mptr[ic] = NULL;
	}
	firstcall = 0;
    }
    fd[devid] = open(devname[devid], O_RDWR);
    if (fd[devid] < 0)
    {
	sprintf(buff, "%s open failed", devname[devid]);
	perror(buff);
	return (0);
    }
    TBmemMap(devid, backend, dblbuf);
    return (mptr[devid]);
}

void
TBterm(int devid)
{
    close(fd[devid]);
    fd[devid] = -1;
}
