#!/bin/csh -f

#
# reconfigure the configuration ROMs.
#
# erase and then write a .rpd file for each iFPGA's ROM.
#

if ( $#argv < 2 ) then
    echo "reconfigure the configuration ROM(s) of iFPGA(s).";
    echo "  usage: $0 <.rpd file> [device IDs]";
    echo "     ex) $0 g5pipe.rpd 1 2 3 4";
    exit;
endif

set rpdfile = $argv[1];

while ($#argv > 1)
    shift argv
    set devid = $argv[1];
    @ devid--  # count from 0, not from 1.

#    echo "writing ${rpdfile} to ROM of iFPGA[${devid}]"
    ./hibtest 19 ${devid};
    ./hibtest 20 ${rpdfile} ${devid};
end
