#ifndef GRAPE7X_H
#define GRAPE7X_H

#include <asm/page.h>
#include <linux/ioctl.h>
#include "typedef.h"

#define GRAPE7X_DEVNAME "grape7x"
#define NGRAPE7X (1) /* max # of device */

// size of DMA buffers
#ifndef PAGE_SIZE
#define PAGE_SIZE sysconf (_SC_PAGE_SIZE)
#endif
#define GRAPE7X_DMABUF_ORDER (5) /* 2^5 pages */
#define GRAPE7X_DMABUF_BYTES (PAGE_SIZE * (1<<GRAPE7X_DMABUF_ORDER)) /* 128kbyte, 32pages */
#define GRAPE7X_DMABUF_WORDS (GRAPE7X_DMABUF_BYTES>>2) /* dma buffer size in quad-word */

#define GRAPE7X_PIOWBUF_BYTES (4096)     // size of double buffer for PIO write
#define GRAPE7X_LOCAL_MEM_BYTES (8192)   // size of local register
#define GRAPE7X_BACKEND_MEM_BYTES (8192) // size of backend space

/* structure for read/write ioctl */

enum {
    GRAPE7X_MAP_HIBMEM = 0,
    GRAPE7X_MAP_DMARBUF,
    GRAPE7X_MAP_DMAWBUF,
    GRAPE7X_MAP_BACKEND,
    GRAPE7X_MAP_DBLBUF,
};

#define GRAPE7X_MAGIC (5)
#define GRAPE7X_WRITE_CFG            _IOW(GRAPE7X_MAGIC, 5, struct long_access)
#define GRAPE7X_READ_CFG             _IOWR(GRAPE7X_MAGIC, 4, struct long_access)
#define GRAPE7X_GET_DMAR_PA          _IOWR(GRAPE7X_MAGIC, 18, unsigned long)
#define GRAPE7X_GET_DMAW_PA          _IOWR(GRAPE7X_MAGIC, 19, unsigned long)
#define GRAPE7X_SET_MAP_MODE         _IOW(GRAPE7X_MAGIC, 20, unsigned int)


#define GRAPE7X_DMA0LSB  (0x00)
#define GRAPE7X_DMA0MSB  (0x04)
#define GRAPE7X_DMA0SIZE (0x08)
#define GRAPE7X_DMA0CMD  (0x0c)
#define GRAPE7X_DMA1LSB  (0x10)
#define GRAPE7X_DMA1MSB  (0x14)
#define GRAPE7X_DMA1SIZE (0x18)
#define GRAPE7X_DMA1CMD  (0x1c)
#define GRAPE7X_DMASTAT  (0x20)
#define GRAPE7X_MAILBOX  (0x24)
#define GRAPE7X_DMAMISC  (0x28)
    /* address map of HIB DMA control register (0x28)
     *
     * 31..30: reserved for dmadone(3..2)
     * 29..28: dmadone(1..0)
     * 27:     swap_sram
     * 26:     sram1_wlock
     * 25:     sram0_wlock
     * 24..21: not used
     * 20..12: sram_wcnt(8..0)
     *     11: not used
     * 10..0:  m_dma1_datacnt(10..0)
     */
#define GRAPE7X_BOARDINFO  (0x30)
#define GRAPE7X_ASMI       (0x38)
#define GRAPE7X_PLLCONF    (0x40)

#define GRAPE7X_DMA0CMD_KICKOFF     (0x00e6)
    /* command (mem read block, no scatter-gather, 64-bit, high priority)
     * 
     * 7-4: PCI transfer command
     *   3: scatter-gather
     *   2: 64-bit mode
     *   1: priority
     *   0: reserved
     */  
#define GRAPE7X_DMA0MISC_DONE_BIT         (28)
#define GRAPE7X_DMA0MISC_SWAP_SRAM_BIT    (27)
#define GRAPE7X_DMA0MISC_SRAM_WCNT_BIT    (12)

#define GRAPE7X_DMA1MISC_DONE_BIT         (29)
#define GRAPE7X_DMA1CMD_KICKOFF           (0x00f6)
#define GRAPE7X_DMASTAT_RESET_BACKEND_BIT (30)
#define GRAPE7X_DMASTAT_DMA_RESET_BIT     (31)


#define GRAPE7X_ASMI_ERROR_BIT (1)
#define GRAPE7X_ASMI_BUSY_BIT  (0)
#define GRAPE7X_ASMI_CMD_RSID  (0xfffffd00)
#define GRAPE7X_ASMI_CMD_WP    (0xfffffe00)
#define GRAPE7X_ASMI_CMD_EB    (0xffffff00)

#define GRAPE7X_PLLCONF_WRITE_BIT    (0)
#define GRAPE7X_PLLCONF_RECONFIG_BIT (2)
#define GRAPE7X_PLLCONF_BUSY_BIT     (0)

#endif /* GRAPE7X_H */
