#ifndef PG_EMULATOR_H
#define PG_EMULATOR_H

/*
 * constant definitions
 */

#ifndef PGUTIL_HEADER

/* data type definitions whose width should explicitly be given. */
typedef char                   INT8;
typedef short                  INT16;
typedef int                    INT32;
typedef long long int          INT64;
typedef unsigned char          UINT8;
typedef unsigned short         UINT16;
typedef unsigned int           UINT32;
typedef unsigned long long int UINT64;

#define DOUBLEFMT  "%lf"
#define INT32XFMT  "0x%x"
#define INT64XFMT  "0x%llx"
#define UINT32XFMT "0x%x"
#define UINT64XFMT "0x%llx"
#define INT32DFMT  "  %d"
#define INT64DFMT  "  %lld"
#define UINT32DFMT "  %d"
#define UINT64DFMT "  %lld"

#endif /* PGUTIL_HEADER */


#if !defined(__LANGUAGE_FORTRAN__) && !defined(_LANGUAGE_FORTRAN)

#if defined(__cplusplus)
extern "C"
{
#endif

    /* C interface */

#ifndef PGUTIL_HEADER // these functions are for emulator library only. not valid when included from a user library.
    // arithmetic
    void pg_comp_int(UINT64 srca, int w1, int m1, UINT64 srcb, int w2, int m2, UINT64 *dstp, int w3, int m3, char *mode);
    void pg_comp_float(UINT64 srca, int w1, int m1, UINT64 srcb, int w2, int m2, UINT64 *dstp, int w3, int m3, char *mode);
    void pg_comp_log(UINT64 srca, int w1, int m1, UINT64 srcb, int w2, int m2, UINT64 *dstp, int w3, int m3, char *mode);

    void pg_mul_float(UINT64  srca, int w1, int m1, UINT64 srcb, int w2, int m2, UINT64 *dstp, int w3, int m3);
    void pg_mul_log(UINT64  srca, int w1, int m1, UINT64 srcb, int w2, int m2, UINT64 *dstp, int w3, int m3);

    void pg_div_log(UINT64  srca, int w1, int m1, UINT64 srcb, int w2, int m2, UINT64 *dstp, int w3, int m3);

    void pg_add_int(UINT64 srca, int w1, int d1, UINT64 srcb, int w2, int d2, UINT64 *dstp, int w3, int d3);
    void pg_add_float(UINT64  srca, int w1, int m1, UINT64 srcb, int w2, int m2, UINT64 *dstp, int w3, int m3);

    void pg_sub_int(UINT64 srca, int w1, int d1, UINT64 srcb, int w2, int d2, UINT64 *dstp, int w3, int d3);
    void pg_sub_float(UINT64  srca, int w1, int m1, UINT64 srcb, int w2, int m2, UINT64 *dstp, int w3, int m3);

    void pg_inc_int(UINT64  src , int w1, int d1, UINT64 *dstp, int w2, int d2, int clear);
    void pg_inc_float(UINT64  src , int w1, int m1, UINT64 *dstp, int w2, int m2, int clear);

    void pg_pow_float(UINT64 src, UINT64 *dstp, int width, int mantissa, int n, int m, int resolution);

    void pg_sqrt_log_log(UINT64 src, int w1, int m1, UINT64 *dstp, int w2, int m2);

    void pg_shift_float(UINT64 src, int w1, int m1, UINT64 distance, int d2a, int d2b, UINT64 *dstp, int w3, int m3, int direction);

    // type conversion
    void pg_conv_float_to_int(UINT64   src, int w1, int m1, UINT64 *dstp, int w2, int d2);
    void pg_conv_float_to_float(UINT64   src, int w1, int m1, UINT64 *dstp, int w2, int m2);
    void pg_conv_int_to_float(UINT64 src, int w1, int d1, UINT64 *dstp, int w2, int m2);
    void pg_conv_int_to_int(UINT64 src, int w1, int m1, UINT64 *dstp, int w2, int m2);
    void pg_conv_float_to_log(UINT64 src, int w1, int m1, UINT64 *dstp, int w2, int m2);
    void pg_conv_log_to_float(UINT64 src, int w1, int m1, UINT64 *dstp, int w2, int m2);
    void pg_conv_log_to_log(UINT64   src, int w1, int m1, UINT64 *dstp, int w2, int m2);

    // miscellaneous
    void pg_delay(UINT64 src, UINT64 *dstp);
    void pg_selector(UINT64 cond, int w1, int m1, UINT64 srca, int w2, int m2, UINT64 srcb, int w3, int m3, UINT64 *dstp, int w4, int m4);

#endif /* PGUTIL_HEADER */

    // functions shared with a user library.
    void pg_conv_cdouble_to_float(double src, UINT64 *dstp, int w1, int m1);
    void pg_conv_cdouble_to_log(double src, UINT64 *dstp, int w1, int m1);
    void pg_conv_float_to_cdouble(UINT64 src, int w1, int m1, double *dstp);

#if defined(__cplusplus)
}
#endif

#endif /* LANGUAGE_FORTRAN */

#endif /* PG_EMULATOR_H */
