set log
set grid
set term post eps enhanced "Times-Roman" 24
set out "pairwise.eps"
set ticscale 4
set xtics ("10^{-16}" 1e-16, "10^{-12}" 1e-12, "10^{-8}" 1e-8, "10^{-4}" 1e-4, "1" 1)
set mxtics 10
set ytics ("10^{-8}" 1e-8, "10^{-6}" 1e-6, "10^{-4}" 1e-4, "10^{-2}" 1e-2, "1" 1)
set mytics 10
# set format x "10^{%T}"
# set format y "10^{%T}"
set xrange [1e-16:1.1]
set yrange [1e-8:1.9]
set key 1.0e-4, 0.2 Left reverse samplen 0
set xlabel "{/Times-Italic=30 r / r_{/Times-Roman=20 max}}" -2, 0.5
set ylabel "{/Times-Italic=30 S(f)^{/Times-Roman=20 1/2}}" 1
plot \
  "h" u 1:2 t "hardware" w p pt  2 ps 1,\
  "e" u 1:2 t "emulator" w p pt 14 ps 1
