#include <stdio.h>
#include "vsumutil.h"

void
run_pipeline(int nj, int ni, double (*x)[3], double (*y)[3], double (*z)[3])
{
    int off, npipe;
    vsum_set_jp(0, nj, y);
    vsum_set_n(nj);
    npipe = vsum_get_number_of_pipelines();
    for (off = 0; off < ni; off += npipe) {
        if (off + npipe > ni) {
            npipe = ni - off;
        }
        vsum_set_ip(npipe, x + off);
        vsum_run();
        vsum_get_fout(npipe, z + off);
    }
}

int
main(int argc, char **argv)
{
    static double x[256][3];
    static double y[256][3];
    static double z[256][3];
    int i, j, nj = 3, ni = 2;

    // 'x's are set to pipeline register.
    x[0][0] = 0.0; x[0][1] = 0.0; x[0][2] = 0.0;
    x[1][0] = 1.0; x[1][1] = 2.0; x[1][2] = -3.0;

    // 'y's are set to j-memory.
    y[0][0] = 1.0; y[0][1] = 1.0; y[0][2] = -1.0;
    y[1][0] = 1.0; y[1][1] = 2.0; y[1][2] = -2.0;
    y[2][0] = 1.0; y[2][1] = 3.0; y[2][2] = -3.0;

    vsum_open();
    vsum_set_scale_x(1.0);
    vsum_set_scale_y(1.0);
    vsum_set_scale_z(1.0);
    run_pipeline(nj, ni, x, y, z);
    vsum_close();

    for (j = 0; j < nj; j++) {
        printf("y[%d]: %e %e %e\n", j, y[j][0], y[j][1], y[j][2]);
    }
    printf("\n");
    for (i = 0; i < ni; i++) {
        printf("x[%d]: %e %e %e\n", i, x[i][0], x[i][1], x[i][2]);
        printf("z[%d]: %e %e %e\n", i, z[i][0], z[i][1], z[i][2]);
        printf("\n");
    }
}
