---------------------------------------------------------------
--
-- hibdcram_c2
--      
-- General purpose DPRAM for Altera Startix/Cyclone device families
-- 
-- v 1.5
--
-- (c) PLD Applications 2003-2004
--
-- 30-jun-2003 - PLE
-- 14-may-2004 - PLE : Removed reset pin
--
---------------------------------------------------------------

library ieee,altera_mf;
use ieee.std_logic_1164.all;
use altera_mf.altera_mf_components.all;

entity hibdcram_c2 is
  generic
    (     
      ADDR_WIDTH : integer:=8;
      DATA_WIDTH : integer:=32
      );
  port
    (
      wrclk    : in std_logic;
      wren    : in std_logic;
      wraddr    : in std_logic_vector ((ADDR_WIDTH-1) downto 0);
      wrdata    : in std_logic_vector ((DATA_WIDTH-1) downto 0);
      
      rdclk    : in std_logic;    
      rdaddr    : in std_logic_vector ((ADDR_WIDTH-1) downto 0);
      rddata    : out std_logic_vector ((DATA_WIDTH-1) downto 0)
      );
end hibdcram_c2;


architecture stratix of hibdcram_c2 is
begin      

  dpram : altsyncram
    generic map (
      operation_mode => "DUAL_PORT",
      width_a => DATA_WIDTH,
      widthad_a => ADDR_WIDTH,
      numwords_a => 2**ADDR_WIDTH,
      width_b => DATA_WIDTH,
      widthad_b => ADDR_WIDTH,
      numwords_b => 2**ADDR_WIDTH,
      lpm_type => "altsyncram",
      width_byteena_a => 1,
      outdata_reg_b => "UNREGISTERED", -- use "CLOCK1" to get regd output
      indata_aclr_a => "NONE",
      wrcontrol_aclr_a => "NONE",
      address_aclr_a => "NONE",
      address_reg_b => "CLOCK1",
      address_aclr_b => "NONE",
      outdata_aclr_b => "NONE",
      rdcontrol_aclr_b => "NONE",
      ram_block_type => "AUTO",
--        init_file => "dummy_ram.mif", -- AK 2005/05/18
      intended_device_family => "Cyclone II"
      )
    PORT MAP (
      wren_a => wren,
      clock0 => wrclk,
      clock1 => rdclk,
      address_a => wraddr,
      address_b => rdaddr,
      data_a => wrdata,
      q_b => rddata
      );
  
end stratix;
