---------------------------------------------------------------
--
-- hibdcram_sgx
--		
-- General purpose DPRAM for Altera implementation
-- 
-- v 1.1
--
-- (c) PLD Applications 2003-2004
--
-- 27-jul-2005 - PLE 
--
---------------------------------------------------------------

library ieee,altera_mf;
use ieee.std_logic_1164.all;
use altera_mf.altera_mf_components.all;

entity hibdcram_sgx is
	generic
		(	
		ADDR_WIDTH	: integer:=4;
		DATA_WIDTH	: integer:=32
		);
	port
		(
		data		: in std_logic_vector((DATA_WIDTH-1) downto 0);
		wren		: in std_logic ;
		wraddress	: in std_logic_vector((ADDR_WIDTH-1) downto 0);
		rdaddress	: in std_logic_vector((ADDR_WIDTH-1) downto 0);
		wrclock		: in std_logic ;
		rdclock		: in std_logic ;
		q			: out std_logic_vector((DATA_WIDTH-1) downto 0)
		);
end hibdcram_sgx;
      
------------------------------------------------------------------------------

architecture altera of hibdcram_sgx is
	component altsyncram
	generic(
		intended_device_family	 : string;
		operation_mode		     : string;
		width_a		             : natural;
		widthad_a		         : natural;
		numwords_a		         : natural;
		width_b		             : natural;
		widthad_b		         : natural;
		numwords_b		         : natural;
		lpm_type		         : string;
		width_byteena_a		     : natural;
		outdata_reg_b		     : string;
		indata_aclr_a		     : string;
		wrcontrol_aclr_a		 : string;
		address_aclr_a		     : string;
		address_reg_b		     : string;
		address_aclr_b		     : string;
		outdata_aclr_b		     : string;
		ram_block_type		     : string
	);
	port(
		wren_a	                 : in std_logic;
		wren_b                   : in std_logic := '0';
        rden_b                   : in std_logic := '1';
		data_a	                 : in std_logic_vector ((DATA_WIDTH-1) downto 0);
        data_b                   : in std_logic_vector ((DATA_WIDTH-1) downto 0) := (others => '1');
    	address_a	             : in std_logic_vector ((ADDR_WIDTH-1) downto 0);
		address_b	             : in std_logic_vector ((ADDR_WIDTH-1) downto 0);
        clock0	                 : in std_logic;
		clock1	                 : in std_logic;
	    clocken0                 : in std_logic := '1';
        clocken1                 : in std_logic := '1';
        aclr0                    : in std_logic := '0';
        aclr1                    : in std_logic := '0';
        addressstall_a           : in std_logic := '0';
        addressstall_b           : in std_logic := '0';
        byteena_a                : in std_logic_vector (0 downto 0) := (others => '1');
        byteena_b                : in std_logic_vector (0 downto 0) := (others => '1');
        q_a                      : out std_logic_vector ((DATA_WIDTH-1) downto 0);
        q_b	                     : out std_logic_vector ((DATA_WIDTH-1) downto 0)
	);
	end component;

begin
	dpram : altsyncram
	generic map(
		intended_device_family => "Stratix",
		operation_mode => "DUAL_PORT",
		width_a => DATA_WIDTH,
		widthad_a => ADDR_WIDTH,
		numwords_a => 2**ADDR_WIDTH,
		width_b => DATA_WIDTH,
		widthad_b => ADDR_WIDTH,
		numwords_b => 2**ADDR_WIDTH,
		lpm_type => "altsyncram",
		width_byteena_a => 1,
		outdata_reg_b => "UNREGISTERED",
		indata_aclr_a => "NONE",
		wrcontrol_aclr_a => "NONE",
		address_aclr_a => "NONE",
		address_reg_b => "CLOCK1",
		address_aclr_b => "NONE",
		outdata_aclr_b => "NONE",
		ram_block_type => "M4K"
	)
	port map(
		wren_a => wren,
		clock0 => wrclock,
   		clock1 => rdclock,
		address_a => wraddress,
		address_b => rdaddress,
		data_a => data,
		q_b => q
	);

end altera;

