---------------------------------------------------------------
--
-- hibdcrambe_sgx
--		
-- General purpose DPRAM/BE for Altera implementation
-- 
-- v 1.1
--
-- (c) PLD Applications 2003-2004
--
-- 27-jul-2005 - PLE 
--
---------------------------------------------------------------

library ieee,altera_mf;
use ieee.std_logic_1164.all; 

entity hibdcrambe_sgx is
	generic
		(	 
		ADDR_WIDTH : integer:=4;
		DATA_WIDTH : integer:=32;
		BYTE_SIZE  : integer range 8 to 9:=8
		);
	port
		(  
		wrclk	: in std_logic;
		wraddr	: in std_logic_vector (ADDR_WIDTH-1 downto 0);
		wrdata	: in std_logic_vector (DATA_WIDTH-1 downto 0);
		wrbe	: in std_logic_vector (DATA_WIDTH/BYTE_SIZE-1 downto 0);
		rdclk	: in std_logic;	
		rdaddr	: in std_logic_vector (ADDR_WIDTH-1 downto 0);
		rddata	: out std_logic_vector (DATA_WIDTH-1 downto 0)
		);
end hibdcrambe_sgx;

architecture altera of hibdcrambe_sgx is

	COMPONENT altsyncram
	GENERIC (
		intended_device_family		: STRING;
		operation_mode		: STRING;
		width_a		: NATURAL;
		widthad_a		: NATURAL;
		numwords_a		: NATURAL;
		width_b		: NATURAL;
		widthad_b		: NATURAL;
		numwords_b		: NATURAL;
		lpm_type		: STRING;
		width_byteena_a		: NATURAL;
		byte_size		: NATURAL;
		outdata_reg_b		: STRING;
		indata_aclr_a		: STRING;
		wrcontrol_aclr_a		: STRING;
		address_aclr_a		: STRING;
		byteena_aclr_a		: STRING;
		address_reg_b		: STRING;
		address_aclr_b		: STRING;
		outdata_aclr_b		: STRING;
		ram_block_type		: STRING
	);
	PORT (
			wren_a	: IN STD_LOGIC ;
			clock0	: IN STD_LOGIC ;
			clock1	: IN STD_LOGIC ;
			byteena_a	: IN STD_LOGIC_VECTOR ((width_byteena_a-1) DOWNTO 0);
			address_a	: IN STD_LOGIC_VECTOR ((widthad_a-1) DOWNTO 0);
			address_b	: IN STD_LOGIC_VECTOR ((widthad_b-1) DOWNTO 0);
			q_b	: OUT STD_LOGIC_VECTOR ((width_a-1) DOWNTO 0);
			data_a	: IN STD_LOGIC_VECTOR ((width_b-1) DOWNTO 0)
	);
	END COMPONENT;

   signal wren	: std_logic;

begin
	wren <='1';
	
	dpram : altsyncram
	GENERIC MAP (
		operation_mode => "DUAL_PORT",
		width_a => DATA_WIDTH,
		widthad_a => ADDR_WIDTH,
		numwords_a => 2**ADDR_WIDTH,
		width_b => DATA_WIDTH,
		widthad_b => ADDR_WIDTH,
		numwords_b => 2**ADDR_WIDTH,
		lpm_type => "altsyncram",
		width_byteena_a => DATA_WIDTH/BYTE_SIZE, 
		byte_size => BYTE_SIZE,
		outdata_reg_b => "CLOCK1",
		indata_aclr_a => "NONE",
		wrcontrol_aclr_a => "NONE",
		address_aclr_a => "NONE",
		byteena_aclr_a => "NONE",
		address_reg_b => "CLOCK1",
		address_aclr_b => "NONE",
		outdata_aclr_b => "NONE",
		ram_block_type => "M4K",
		intended_device_family => "Stratix GX"
		)
	PORT MAP (
		wren_a => wren,
		clock0 => wrclk,
		clock1 => rdclk,  
		byteena_a => wrbe,
		address_a => wraddr,
		address_b => rdaddr,
		data_a => wrdata,
		q_b => rddata
		);

end altera;
