library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity ifpga is 
  port (
    pci_clk                : in    std_logic;
    pci_rst                : in    std_logic;
    pci_ad                 : inout std_logic_vector(63 downto 0);
    pci_cbe                : inout std_logic_vector(7 downto 0);
    pci_frame              : inout std_logic;
    pci_irdy               : inout std_logic;
    pci_trdy               : inout std_logic;
    pci_stop               : inout std_logic;
    pci_devsel             : inout std_logic;
    pci_idsel              : in    std_logic;
    pci_req64              : inout std_logic;
    pci_ack64              : inout std_logic;
    pci_par                : inout std_logic;
    pci_par64              : inout std_logic;
    pci_perr               : inout std_logic;
    pci_serr               : inout std_logic;
    pci_inta               : inout std_logic;
    pci_req                : inout std_logic;
    pci_gnt                : in    std_logic;
    pci_m66en              : in    std_logic;
    pci_intb               : inout std_logic;
    pci_intc               : inout std_logic;
    pci_intd               : inout std_logic;
    pci_pme                : inout std_logic;
    pci_lock               : inout std_logic;

    o_sw                   : in std_logic_vector(1 downto 0);
    o_led                  : out std_logic_vector(2 downto 0);  

    l_eclk                 : out std_logic;
    l_iclk                 : in std_logic
    );
end ifpga;

architecture hierarchy of ifpga is

  component hib
    port (
      -- PCI-X signals
      clk_pci             : in    std_logic;
      rst_pci             : in    std_logic;
      idsel_pci           : in    std_logic;
      lock_pci            : in    std_logic;
      m66en_pci           : in    std_logic;
      ad_pci              : inout std_logic_vector(63 downto 0);
      frame_pci           : inout std_logic;
      req64_pci           : inout std_logic;
      cbe_pci             : inout std_logic_vector(7 downto 0);
      irdy_pci            : inout std_logic;
      req_pci             : inout std_logic;
      gnt_pci             : in    std_logic;
      trdy_pci            : inout std_logic;
      stop_pci            : inout std_logic;
      devsel_pci          : inout std_logic;
      ack64_pci           : inout std_logic;
      par_pci             : inout std_logic;
      par64_pci           : inout std_logic;
      perr_pci            : inout std_logic;
      serr_pci            : inout std_logic;
      inta_pci            : inout std_logic;

      -- User Leds
      usr_led             : out std_logic_vector (7 downto 0);
      
      -- PLDA PCI-X board specific signals
      prot0_out           : out    std_logic;
      prot1_out           : out    std_logic;
      prot1_in            : in    std_logic_vector(1 downto 0);

      -- interface to the backend 
      hib_we              : out std_logic;
      hib_data            : out std_logic_vector(63 downto 0);
      backend_we          : in std_logic;
      backend_data        : in std_logic_vector(63 downto 0);
      reset_backend       : out std_logic;

      -- board information register initial value
      board_info          : in std_logic_vector(31 downto 0)
      );
  end component;

  component backend
    port (
      hib_clk              : in std_logic;
      rst                  : in std_logic; -- negative logic
      board_info           : out std_logic_vector(31 downto 0);

      -- DMA signals
      hib_we               : in std_logic;
      hib_data             : in std_logic_vector(63 downto 0);
      backend_we           : out std_logic;
      backend_data         : out std_logic_vector(63 downto 0)
      );
  end component;

  component ifpgapll
    port
      (
        inclk0        : in std_logic;
        c0            : out std_logic
    );
  end component;

  component ifpgapll1
    port
      (
        inclk0    : in std_logic;
        c0        : out std_logic;
        c1        : out std_logic;
        c2        : out std_logic 
    );
  end component;

  signal hib_clk             : std_logic;
  signal backend_clk0        : std_logic;
  signal backend_clk1        : std_logic;
  signal backend_clk2        : std_logic;
  signal reset_backend       : std_logic;
  signal hib_we              : std_logic;
  signal hib_data            : std_logic_vector(63 downto 0);
  signal backend_we          : std_logic;
  signal backend_data        : std_logic_vector(63 downto 0);
  signal board_info          : std_logic_vector(31 downto 0);
  
begin
  pll_instance : ifpgapll
    port map (
      inclk0  => pci_clk,
      c0 => hib_clk
    );

  -- frequency defined in 'ifpgapll1.vhd' can be modified by QuartusII MegaWizard.
  l_eclk <= hib_clk;
  pll1_instance : ifpgapll1
    port map (
      inclk0  => l_iclk,
      c0 => backend_clk0,           -- backend clock @ 133MHz
      c1 => backend_clk1,           -- backend clock @ 133MHz
      c2 => backend_clk2            -- backend clock @ 133MHz
    );

  hib_instance : hib
    port map (
      -- PCI-X signals
      idsel_pci => pci_idsel,
      lock_pci => pci_lock,
      ad_pci => pci_ad,
      frame_pci => pci_frame,
      req64_pci => pci_req64,
      cbe_pci => pci_cbe,  
      irdy_pci => pci_irdy, 
      trdy_pci => pci_trdy, 
      stop_pci => pci_stop, 
      devsel_pci => pci_devsel,
      ack64_pci => pci_ack64,
      par_pci => pci_par, 
      par64_pci => pci_par64,
      perr_pci => pci_perr,
      serr_pci => pci_serr,
      inta_pci => pci_inta,
      req_pci => pci_req, 
      gnt_pci => pci_gnt,
      m66en_pci => pci_m66en,

      prot1_in => "00",
      
      -- global output lines
      clk_pci => hib_clk,
      rst_pci => pci_rst,

      -- interface to the backend 
      hib_we        => hib_we,
      hib_data      => hib_data,
      backend_we    => backend_we,
      backend_data  => backend_data,
      reset_backend => reset_backend,

      board_info => board_info
      );

  backend_instance: backend
    port map (
      hib_clk      => hib_clk,
      rst          => reset_backend,
      board_info   => board_info,
      hib_we       => hib_we,
      hib_data     => hib_data,
      backend_we   => backend_we,
      backend_data => backend_data
      );
end hierarchy;
