library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
entity ifpga is
  port (
    -- PCIe signals
    osc_local_32           : in std_logic;  -- GXII
    clk100_ext             : in std_logic;
    mperst                 : in std_logic;
    rx_in0                 : in std_logic;
    tx_out0                : out std_logic;
    rx_in1                 : in std_logic;
    tx_out1                : out std_logic;
    rx_in2                 : in std_logic;
    tx_out2                : out std_logic;
    rx_in3                 : in std_logic;
    tx_out3                : out std_logic;
    rx_in4                 : in std_logic;
    tx_out4                : out std_logic;
    rx_in5                 : in std_logic;
    tx_out5                : out std_logic;
    rx_in6                 : in std_logic;
    tx_out6                : out std_logic;
    rx_in7                 : in std_logic;
    tx_out7                : out std_logic;
    wake                   : out std_logic;

    -- PLDA board specific signals
    prot0_out              : out std_logic;    
    prot2_in               : in std_logic_vector(1 downto 0);
    prot2_out              : out std_logic;    
    usr_sw                 : in  std_logic_vector (3 downto 0);
    usr_led                : out std_logic_vector (3 downto 0)
    );
end ifpga;

architecture structural of ifpga is
  component hib
    port (
      -- PCIe signals
      osc_local_32         : in std_logic;  -- GXII
      clk100_ext           : in std_logic;
      mperst               : in std_logic;
      rx_in0               : in std_logic;
      tx_out0              : out std_logic;
      rx_in1               : in std_logic;
      tx_out1              : out std_logic;
      rx_in2               : in std_logic;
      tx_out2              : out std_logic;
      rx_in3               : in std_logic;
      tx_out3              : out std_logic;
      rx_in4               : in std_logic;
      tx_out4              : out std_logic;
      rx_in5               : in std_logic;
      tx_out5              : out std_logic;
      rx_in6               : in std_logic;
      tx_out6              : out std_logic;
      rx_in7               : in std_logic;
      tx_out7              : out std_logic;
      wake                 : out std_logic;

      -- PLDA board specific signals
      prot0_out            : out std_logic;    
      prot2_in             : in std_logic_vector(1 downto 0);
      prot2_out            : out std_logic;    
      usr_sw               : in  std_logic_vector (3 downto 0);
      usr_led              : out std_logic_vector (3 downto 0);

      -- global output lines
      clk_out              : out std_logic;

      -- interface to the backend 
      hib_we               : out std_logic;
      hib_data             : out std_logic_vector(63 downto 0);
      backend_we           : in std_logic;
      backend_data         : in std_logic_vector(63 downto 0);
      reset_backend        : out std_logic;

      -- board information register initial value
      board_info           : in std_logic_vector(31 downto 0)
      );
  end component;

  component backend
    port (
      hib_clk              : in std_logic;
      rst                  : in std_logic; -- negative logic
      board_info           : out std_logic_vector(31 downto 0);

      -- DMA signals
      hib_we               : in std_logic;
      hib_data             : in std_logic_vector(63 downto 0);
      backend_we           : out std_logic;
      backend_data         : out std_logic_vector(63 downto 0)
      );
  end component;
  
  component ifpgapll
    port (
      inclk0               : in std_logic;
      c0                   : out std_logic;
      c1                   : out std_logic;
      c2                   : out std_logic
    );
  end component;

  signal hib_clk             : std_logic;
  signal backend_clk0        : std_logic;
  signal backend_clk1        : std_logic;
  signal backend_clk2        : std_logic;
  signal reset_backend       : std_logic;
  signal hib_we              : std_logic;
  signal hib_data            : std_logic_vector(63 downto 0);
  signal backend_we          : std_logic;
  signal backend_data        : std_logic_vector(63 downto 0);
  signal board_info          : std_logic_vector(31 downto 0);

begin

  pll_inst : ifpgapll
    PORT MAP (
      inclk0 => hib_clk,                -- interface clock @ 250MHz
      c0     => backend_clk0,           -- backend clocks (@ 125MHz by default)
      c1     => backend_clk1,           -- frequency defined in 'ifpgapll.vhd'
      c2     => backend_clk2            -- can be modified by QuartusII MegaWizard.
    );

  hib_instance: hib
    port map (
      -- PCIe signals
      osc_local_32   => osc_local_32,
      clk100_ext     => clk100_ext,
      mperst         => mperst,
      rx_in0         => rx_in0,
      tx_out0        => tx_out0,
      rx_in1         => rx_in1,
      tx_out1        => tx_out1,
      rx_in2         => rx_in2,
      tx_out2        => tx_out2,
      rx_in3         => rx_in3,
      tx_out3        => tx_out3,
      rx_in4         => rx_in4,
      tx_out4        => tx_out4,
      rx_in5         => rx_in5,
      tx_out5        => tx_out5,
      rx_in6         => rx_in6,
      tx_out6        => tx_out6,
      rx_in7         => rx_in7,
      tx_out7        => tx_out7,
      wake           => wake,

      -- PLDA board specific signals
      prot0_out      => prot0_out,
      prot2_in       => prot2_in,
      prot2_out      => prot2_out,
      usr_sw         => usr_sw,
      usr_led        => usr_led,

      -- global output lines
      clk_out        => hib_clk,

      -- interface to the backend 
      hib_we        => hib_we,
      hib_data      => hib_data,
      backend_we    => backend_we,
      backend_data  => backend_data,
      reset_backend => reset_backend,
      board_info => board_info
      );
  
  backend_instance: backend
    port map (
      hib_clk      => hib_clk,
      rst          => reset_backend,
      board_info   => board_info,
      hib_we       => hib_we,
      hib_data     => hib_data,
      backend_we   => backend_we,
      backend_data => backend_data
      );

end structural;
