--  megafunction wizard: %PLDA PCI Express EZ Core%
--  PLDA HDL Writer v10.1
--  This instance is for PLDA PCI Express EZ module v1.6.1 build 145 x8@250Mhz
-- 
library ieee;
use ieee.std_logic_1164.all;



-- PARAM: PRV_DEV_TYPE 1
-- PARAM: PRV_TARGET_TECHNO 1
-- PARAM: PRV_INTERFACE_TYPE 3
-- PARAM: PRV_LANGUAGE 0
-- PARAM: PRV_STR_LANGUAGE 'VHDL'
-- PARAM: PRV_NB_DMA 4
-- PARAM: PRV_DMA_CPL_TO 20
-- PARAM: PRV_SIMUL_RQS 4
-- PARAM: PRV_DEV_ISSUE_INT 0
-- PARAM: PRV_MAX_DMA_TRANS_SIZE 14
-- PARAM: PRV_DMA_LCL_ADDR_SIZE 13
-- PARAM: PRV_ENABLE_AER 0
-- PARAM: PRV_NB_MSI 0
-- PARAM: PRV_MAX_PAYLOAD 11
-- PARAM: PRV_LOCK_SUPPORT 0
-- PARAM: PRV_DMA_SUP_LAT 3
-- PARAM: BARPATH_F 0x00000000
-- PARAM: BARA_D0_F 0x00000008
-- PARAM: BARA_D1_F 0x00000008
-- PARAM: BARA_D2_F 0x00000008
-- PARAM: BARA_D3_F 0x00000008
-- PARAM: BARA_D4_F 0x00000000
-- PARAM: BARA_D5_F 0x00000000
-- PARAM: BARA_D6_F 0x00000000
-- PARAM: BARS_D0_F 15
-- PARAM: BARS_D1_F 12
-- PARAM: BARS_D2_F 15
-- PARAM: BARS_D3_F 12
-- PARAM: BARS_D4_F 0
-- PARAM: BARS_D5_F 0
-- PARAM: BARS_D6_F 0
-- PARAM: PCIID_D0_F 0x0E701556
-- PARAM: PCIID_D1_F 0x04000011
-- PARAM: PCIID_D2_F 0x0E701556
-- PARAM: PRV_PM_MODE 0
-- PARAM: PM_F 0x0002
-- PARAM: PRV_L0S_FEATURE 1
-- PARAM: PRV_L0S_ACCP_CLK 0
-- PARAM: PRV_ENTRY_LAT 2
-- PARAM: PRV_NFTS_CMN_CLK 32
-- PARAM: PRV_NFTS_SEPRATE_CLK 128
-- PARAM: PRV_L1_FEATURE 0
-- PARAM: PRV_L1_EXIT_CMN_CLK 0
-- PARAM: PRV_L1_EXIT_SEPRATE_CLK 0
-- PARAM: PRV_ENDP_L1_ACCP_LATCY 0
-- PARAM: PRV_CLK_PW_MGT 0
-- PARAM: DMASIZE 14
-- PARAM: LOCSIZE 13
-- PARAM: TIMEOUT 20
-- PARAM: RX_BUF 11
-- PARAM: RTRY_BUF 10
-- PARAM: TX_DEPTH 6


entity pciecorex4f is
  port (
    clk : in std_logic;
    rstn : in std_logic;
    srst : in std_logic;
    npor : in std_logic;
    test_mode : in std_logic_vector(15 downto 0);
    rstn_out : out std_logic;
    npor_out : out std_logic;
    slotclk_cfg : in std_logic;
    phystatus : in std_logic;
    powerdown : out std_logic_vector(1 downto 0);
    txdetectrx : out std_logic;
    txdata0 : out std_logic_vector(15 downto 0);
    txdatak0 : out std_logic_vector(1 downto 0);
    txelecidle0 : out std_logic;
    txcompl0 : out std_logic;
    rxpolarity0 : out std_logic;
    rxdata0 : in std_logic_vector(15 downto 0);
    rxdatak0 : in std_logic_vector(1 downto 0);
    rxvalid0 : in std_logic;
    rxelecidle0 : in std_logic;
    rxstatus0 : in std_logic_vector(2 downto 0);
    txdata1 : out std_logic_vector(15 downto 0);
    txdatak1 : out std_logic_vector(1 downto 0);
    txelecidle1 : out std_logic;
    txcompl1 : out std_logic;
    rxpolarity1 : out std_logic;
    rxdata1 : in std_logic_vector(15 downto 0);
    rxdatak1 : in std_logic_vector(1 downto 0);
    rxvalid1 : in std_logic;
    rxelecidle1 : in std_logic;
    rxstatus1 : in std_logic_vector(2 downto 0);
    txdata2 : out std_logic_vector(15 downto 0);
    txdatak2 : out std_logic_vector(1 downto 0);
    txelecidle2 : out std_logic;
    txcompl2 : out std_logic;
    rxpolarity2 : out std_logic;
    rxdata2 : in std_logic_vector(15 downto 0);
    rxdatak2 : in std_logic_vector(1 downto 0);
    rxvalid2 : in std_logic;
    rxelecidle2 : in std_logic;
    rxstatus2 : in std_logic_vector(2 downto 0);
    txdata3 : out std_logic_vector(15 downto 0);
    txdatak3 : out std_logic_vector(1 downto 0);
    txelecidle3 : out std_logic;
    txcompl3 : out std_logic;
    rxpolarity3 : out std_logic;
    rxdata3 : in std_logic_vector(15 downto 0);
    rxdatak3 : in std_logic_vector(1 downto 0);
    rxvalid3 : in std_logic;
    rxelecidle3 : in std_logic;
    rxstatus3 : in std_logic_vector(2 downto 0);
    cfg_prmcsr : out std_logic_vector(31 downto 0);
    cfg_devcsr : out std_logic_vector(31 downto 0);
    cfg_linkcsr : out std_logic_vector(31 downto 0);
    cfg_msicsr : out std_logic_vector(15 downto 0);
    cfg_ltssm : out std_logic_vector(4 downto 0);
    slv_dataout : out std_logic_vector(63 downto 0);
    slv_bytevalid : out std_logic_vector(7 downto 0);
    slv_bytecount : out std_logic_vector(12 downto 0);
    slv_dwcount : out std_logic_vector(10 downto 0);
    slv_addr : out std_logic_vector(63 downto 0);
    slv_bar : out std_logic_vector(6 downto 0);
    slv_readreq : out std_logic;
    slv_cpladdr : out std_logic_vector(31 downto 0);
    slv_cplparam : out std_logic_vector(4 downto 0);
    slv_writereq : out std_logic;
    slv_write : out std_logic;
    slv_lastwrite : out std_logic;
    slv_io : out std_logic;
    slv_accept : in std_logic;
    slv_abort : in std_logic;
    slv_ur : in std_logic;
    dma_rd : out std_logic;
    dma_rdaddr : out std_logic_vector(12 downto 0);
    dma_rdchannel : out std_logic_vector(7 downto 0);
    dma_rddata : in std_logic_vector(63 downto 0);
    dma_wr : out std_logic;
    dma_wraddr : out std_logic_vector(12 downto 0);
    dma_wrchannel : out std_logic_vector(7 downto 0);
    dma_wrdata : out std_logic_vector(63 downto 0);
    dma_wrbytevalid : out std_logic_vector(7 downto 0);
    dma0_regin : in std_logic_vector(127 downto 0);
    dma0_regout : out std_logic_vector(127 downto 0);
    dma0_param : in std_logic_vector(15 downto 0);
    dma0_control : in std_logic_vector(5 downto 0);
    dma0_status : out std_logic_vector(3 downto 0);
    dma0_fifocnt : in std_logic_vector(12 downto 0);
    dma1_regin : in std_logic_vector(127 downto 0);
    dma1_regout : out std_logic_vector(127 downto 0);
    dma1_param : in std_logic_vector(15 downto 0);
    dma1_control : in std_logic_vector(5 downto 0);
    dma1_status : out std_logic_vector(3 downto 0);
    dma1_fifocnt : in std_logic_vector(12 downto 0);
    dma2_regin : in std_logic_vector(127 downto 0);
    dma2_regout : out std_logic_vector(127 downto 0);
    dma2_param : in std_logic_vector(15 downto 0);
    dma2_control : in std_logic_vector(5 downto 0);
    dma2_status : out std_logic_vector(3 downto 0);
    dma2_fifocnt : in std_logic_vector(12 downto 0);
    dma3_regin : in std_logic_vector(127 downto 0);
    dma3_regout : out std_logic_vector(127 downto 0);
    dma3_param : in std_logic_vector(15 downto 0);
    dma3_control : in std_logic_vector(5 downto 0);
    dma3_status : out std_logic_vector(3 downto 0);
    dma3_fifocnt : in std_logic_vector(12 downto 0));

end pciecorex4f;

architecture structural of pciecorex4f is
  component pciez_lite_4x125
    generic (
      DMASIZE : integer;
      LOCSIZE : integer;
      TIMEOUT : integer;
      RX_BUF : integer;
      RTRY_BUF : integer;
      TX_DEPTH : integer);
    port (
      clk : in std_logic;
      rstn : in std_logic;
      srst : in std_logic;
      npor : in std_logic;
      test_mode : in std_logic_vector (15 downto 0);
      rstn_out : out std_logic;
      npor_out : out std_logic;
      slotclk_cfg : in std_logic;
      phystatus : in std_logic;
      powerdown : out std_logic_vector (1 downto 0);
      txdetectrx : out std_logic;
      txdata0 : out std_logic_vector (15 downto 0);
      txdatak0 : out std_logic_vector (1 downto 0);
      txelecidle0 : out std_logic;
      txcompl0 : out std_logic;
      rxpolarity0 : out std_logic;
      rxdata0 : in std_logic_vector (15 downto 0);
      rxdatak0 : in std_logic_vector (1 downto 0);
      rxvalid0 : in std_logic;
      rxelecidle0 : in std_logic;
      rxstatus0 : in std_logic_vector (2 downto 0);
      txdata1 : out std_logic_vector (15 downto 0);
      txdatak1 : out std_logic_vector (1 downto 0);
      txelecidle1 : out std_logic;
      txcompl1 : out std_logic;
      rxpolarity1 : out std_logic;
      rxdata1 : in std_logic_vector (15 downto 0);
      rxdatak1 : in std_logic_vector (1 downto 0);
      rxvalid1 : in std_logic;
      rxelecidle1 : in std_logic;
      rxstatus1 : in std_logic_vector (2 downto 0);
      txdata2 : out std_logic_vector (15 downto 0);
      txdatak2 : out std_logic_vector (1 downto 0);
      txelecidle2 : out std_logic;
      txcompl2 : out std_logic;
      rxpolarity2 : out std_logic;
      rxdata2 : in std_logic_vector (15 downto 0);
      rxdatak2 : in std_logic_vector (1 downto 0);
      rxvalid2 : in std_logic;
      rxelecidle2 : in std_logic;
      rxstatus2 : in std_logic_vector (2 downto 0);
      txdata3 : out std_logic_vector (15 downto 0);
      txdatak3 : out std_logic_vector (1 downto 0);
      txelecidle3 : out std_logic;
      txcompl3 : out std_logic;
      rxpolarity3 : out std_logic;
      rxdata3 : in std_logic_vector (15 downto 0);
      rxdatak3 : in std_logic_vector (1 downto 0);
      rxvalid3 : in std_logic;
      rxelecidle3 : in std_logic;
      rxstatus3 : in std_logic_vector (2 downto 0);
      k_ez : in std_logic_vector (39 downto 0);
      k_pciid : in std_logic_vector (95 downto 0);
      k_bar : in std_logic_vector (223 downto 0);
      k_pm : in std_logic_vector (15 downto 0);
      k_aspm : in std_logic_vector (31 downto 0);
      k_slot : in std_logic_vector (31 downto 0);
      pm_event : in std_logic;
      pm_auxpwr : in std_logic;
      pm_data : in std_logic_vector (9 downto 0);
      cfg_pmcsr : out std_logic_vector (31 downto 0);
      int_request : in std_logic;
      int_ack : out std_logic;
      int_rootport : out std_logic_vector (4 downto 0);
      cfg_slotcsr : out std_logic_vector (31 downto 0);
      cfg_rootcsr : out std_logic_vector (31 downto 0);
      int_msgnum : in std_logic_vector (4 downto 0);
      cfg_prmcsr : out std_logic_vector (31 downto 0);
      cfg_devcsr : out std_logic_vector (31 downto 0);
      cfg_linkcsr : out std_logic_vector (31 downto 0);
      cfg_msicsr : out std_logic_vector (15 downto 0);
      cfg_ltssm : out std_logic_vector (4 downto 0);
      slv_dataout : out std_logic_vector (63 downto 0);
      slv_bytevalid : out std_logic_vector (7 downto 0);
      slv_bytecount : out std_logic_vector (12 downto 0);
      slv_dwcount : out std_logic_vector (10 downto 0);
      slv_addr : out std_logic_vector (63 downto 0);
      slv_bar : out std_logic_vector (6 downto 0);
      slv_readreq : out std_logic;
      slv_cpladdr : out std_logic_vector (31 downto 0);
      slv_cplparam : out std_logic_vector (4 downto 0);
      slv_cpllocked : out std_logic;
      slv_writereq : out std_logic;
      slv_write : out std_logic;
      slv_lastwrite : out std_logic;
      slv_io : out std_logic;
      slv_accept : in std_logic;
      slv_abort : in std_logic;
      slv_ur : in std_logic;
      dma_rd : out std_logic;
      dma_rdaddr : out std_logic_vector (12 downto 0);
      dma_rdchannel : out std_logic_vector (7 downto 0);
      dma_rddata : in std_logic_vector (63 downto 0);
      dma_wr : out std_logic;
      dma_wraddr : out std_logic_vector (12 downto 0);
      dma_wrchannel : out std_logic_vector (7 downto 0);
      dma_wrdata : out std_logic_vector (63 downto 0);
      dma_wrbytevalid : out std_logic_vector (7 downto 0);
      dma0_regin : in std_logic_vector (127 downto 0);
      dma0_regout : out std_logic_vector (127 downto 0);
      dma0_param : in std_logic_vector (15 downto 0);
      dma0_control : in std_logic_vector (5 downto 0);
      dma0_status : out std_logic_vector (3 downto 0);
      dma0_fifocnt : in std_logic_vector (12 downto 0);
      dma1_regin : in std_logic_vector (127 downto 0);
      dma1_regout : out std_logic_vector (127 downto 0);
      dma1_param : in std_logic_vector (15 downto 0);
      dma1_control : in std_logic_vector (5 downto 0);
      dma1_status : out std_logic_vector (3 downto 0);
      dma1_fifocnt : in std_logic_vector (12 downto 0);
      dma2_regin : in std_logic_vector (127 downto 0);
      dma2_regout : out std_logic_vector (127 downto 0);
      dma2_param : in std_logic_vector (15 downto 0);
      dma2_control : in std_logic_vector (5 downto 0);
      dma2_status : out std_logic_vector (3 downto 0);
      dma2_fifocnt : in std_logic_vector (12 downto 0);
      dma3_regin : in std_logic_vector (127 downto 0);
      dma3_regout : out std_logic_vector (127 downto 0);
      dma3_param : in std_logic_vector (15 downto 0);
      dma3_control : in std_logic_vector (5 downto 0);
      dma3_status : out std_logic_vector (3 downto 0);
      dma3_fifocnt : in std_logic_vector (12 downto 0);
      dma4_regin : in std_logic_vector (127 downto 0);
      dma4_regout : out std_logic_vector (127 downto 0);
      dma4_param : in std_logic_vector (15 downto 0);
      dma4_control : in std_logic_vector (5 downto 0);
      dma4_status : out std_logic_vector (3 downto 0);
      dma4_fifocnt : in std_logic_vector (12 downto 0);
      dma5_regin : in std_logic_vector (127 downto 0);
      dma5_regout : out std_logic_vector (127 downto 0);
      dma5_param : in std_logic_vector (15 downto 0);
      dma5_control : in std_logic_vector (5 downto 0);
      dma5_status : out std_logic_vector (3 downto 0);
      dma5_fifocnt : in std_logic_vector (12 downto 0);
      dma6_regin : in std_logic_vector (127 downto 0);
      dma6_regout : out std_logic_vector (127 downto 0);
      dma6_param : in std_logic_vector (15 downto 0);
      dma6_control : in std_logic_vector (5 downto 0);
      dma6_status : out std_logic_vector (3 downto 0);
      dma6_fifocnt : in std_logic_vector (12 downto 0);
      dma7_regin : in std_logic_vector (127 downto 0);
      dma7_regout : out std_logic_vector (127 downto 0);
      dma7_param : in std_logic_vector (15 downto 0);
      dma7_control : in std_logic_vector (5 downto 0);
      dma7_status : out std_logic_vector (3 downto 0);
      dma7_fifocnt : in std_logic_vector (12 downto 0));
  end component;

  signal ZERO : std_logic_vector (383 downto 0);
  signal k_ez : std_logic_vector (39 downto 0);
  signal k_pciid : std_logic_vector (95 downto 0);
  signal k_bar : std_logic_vector (223 downto 0);
  signal k_pm : std_logic_vector (15 downto 0);
  signal k_aspm : std_logic_vector (31 downto 0);
  signal int_rootport : std_logic_vector (4 downto 0);
  signal cfg_slotcsr : std_logic_vector (31 downto 0);
  signal cfg_rootcsr : std_logic_vector (31 downto 0);

begin
  ZERO <=(others=>'0');
  k_ez <=x"00" & x"80210F0F";
  k_pciid <=x"0E701556" & x"04000011" & x"0E701556";
  k_bar <=x"00000000" & x"00000000" & x"00000000" & x"FFFFF008" & x"FFFF8008" & x"FFFFF008" & x"FFFF8008";
  k_pm <=x"0002";
  k_aspm <=x"40008020";

  core_inst : pciez_lite_4x125
    generic map (
      DMASIZE => 14,
      LOCSIZE => 13,
      TIMEOUT => 20,
      RX_BUF => 11,
      RTRY_BUF => 10,
      TX_DEPTH => 6)
    port map (
      clk => clk,
      rstn => rstn,
      srst => srst,
      npor => npor,
      test_mode => test_mode,
      rstn_out => rstn_out,
      npor_out => npor_out,
      slotclk_cfg => slotclk_cfg,
      phystatus => phystatus,
      powerdown => powerdown,
      txdetectrx => txdetectrx,
      txdata0 => txdata0,
      txdatak0 => txdatak0,
      txelecidle0 => txelecidle0,
      txcompl0 => txcompl0,
      rxpolarity0 => rxpolarity0,
      rxdata0 => rxdata0,
      rxdatak0 => rxdatak0,
      rxvalid0 => rxvalid0,
      rxelecidle0 => rxelecidle0,
      rxstatus0 => rxstatus0,
      txdata1 => txdata1,
      txdatak1 => txdatak1,
      txelecidle1 => txelecidle1,
      txcompl1 => txcompl1,
      rxpolarity1 => rxpolarity1,
      rxdata1 => rxdata1,
      rxdatak1 => rxdatak1,
      rxvalid1 => rxvalid1,
      rxelecidle1 => rxelecidle1,
      rxstatus1 => rxstatus1,
      txdata2 => txdata2,
      txdatak2 => txdatak2,
      txelecidle2 => txelecidle2,
      txcompl2 => txcompl2,
      rxpolarity2 => rxpolarity2,
      rxdata2 => rxdata2,
      rxdatak2 => rxdatak2,
      rxvalid2 => rxvalid2,
      rxelecidle2 => rxelecidle2,
      rxstatus2 => rxstatus2,
      txdata3 => txdata3,
      txdatak3 => txdatak3,
      txelecidle3 => txelecidle3,
      txcompl3 => txcompl3,
      rxpolarity3 => rxpolarity3,
      rxdata3 => rxdata3,
      rxdatak3 => rxdatak3,
      rxvalid3 => rxvalid3,
      rxelecidle3 => rxelecidle3,
      rxstatus3 => rxstatus3,
      k_ez => k_ez,
      k_pciid => k_pciid,
      k_bar => k_bar,
      k_pm => k_pm,
      k_aspm => k_aspm,
      k_slot => ZERO(31 downto 0),
      pm_event => ZERO(0),
      pm_auxpwr => ZERO(0),
      pm_data => ZERO(9 downto 0),
      cfg_pmcsr => open,
      int_request => ZERO(0),
      int_ack => open,
      int_rootport => int_rootport,
      cfg_slotcsr => cfg_slotcsr,
      cfg_rootcsr => cfg_rootcsr,
      int_msgnum => ZERO(4 downto 0),
      cfg_prmcsr => cfg_prmcsr,
      cfg_devcsr => cfg_devcsr,
      cfg_linkcsr => cfg_linkcsr,
      cfg_msicsr => cfg_msicsr,
      cfg_ltssm => cfg_ltssm,
      slv_dataout => slv_dataout,
      slv_bytevalid => slv_bytevalid,
      slv_bytecount => slv_bytecount,
      slv_dwcount => slv_dwcount,
      slv_addr => slv_addr,
      slv_bar => slv_bar,
      slv_readreq => slv_readreq,
      slv_cpladdr => slv_cpladdr,
      slv_cplparam => slv_cplparam,
      slv_cpllocked => open,
      slv_writereq => slv_writereq,
      slv_write => slv_write,
      slv_lastwrite => slv_lastwrite,
      slv_io => slv_io,
      slv_accept => slv_accept,
      slv_abort => slv_abort,
      slv_ur => slv_ur,
      dma_rd => dma_rd,
      dma_rdaddr => dma_rdaddr,
      dma_rdchannel => dma_rdchannel,
      dma_rddata => dma_rddata,
      dma_wr => dma_wr,
      dma_wraddr => dma_wraddr,
      dma_wrchannel => dma_wrchannel,
      dma_wrdata => dma_wrdata,
      dma_wrbytevalid => dma_wrbytevalid,
      dma0_regin => dma0_regin,
      dma0_regout => dma0_regout,
      dma0_param => dma0_param,
      dma0_control => dma0_control,
      dma0_status => dma0_status,
      dma0_fifocnt => dma0_fifocnt,
      dma1_regin => dma1_regin,
      dma1_regout => dma1_regout,
      dma1_param => dma1_param,
      dma1_control => dma1_control,
      dma1_status => dma1_status,
      dma1_fifocnt => dma1_fifocnt,
      dma2_regin => dma2_regin,
      dma2_regout => dma2_regout,
      dma2_param => dma2_param,
      dma2_control => dma2_control,
      dma2_status => dma2_status,
      dma2_fifocnt => dma2_fifocnt,
      dma3_regin => dma3_regin,
      dma3_regout => dma3_regout,
      dma3_param => dma3_param,
      dma3_control => dma3_control,
      dma3_status => dma3_status,
      dma3_fifocnt => dma3_fifocnt,
      dma4_regin => ZERO(127 downto 0),
      dma4_regout => open,
      dma4_param => ZERO(15 downto 0),
      dma4_control => ZERO(5 downto 0),
      dma4_status => open,
      dma4_fifocnt => ZERO(12 downto 0),
      dma5_regin => ZERO(127 downto 0),
      dma5_regout => open,
      dma5_param => ZERO(15 downto 0),
      dma5_control => ZERO(5 downto 0),
      dma5_status => open,
      dma5_fifocnt => ZERO(12 downto 0),
      dma6_regin => ZERO(127 downto 0),
      dma6_regout => open,
      dma6_param => ZERO(15 downto 0),
      dma6_control => ZERO(5 downto 0),
      dma6_status => open,
      dma6_fifocnt => ZERO(12 downto 0),
      dma7_regin => ZERO(127 downto 0),
      dma7_regout => open,
      dma7_param => ZERO(15 downto 0),
      dma7_control => ZERO(5 downto 0),
      dma7_status => open,
      dma7_fifocnt => ZERO(12 downto 0));

end structural;

