--  megafunction wizard: %PLDA PCI Core%
--  PLDA HDL Writer v10.0
--  This instance is for PLDA PCI-X & PCI core v7.0.7 build 171
-- 
library ieee;
use ieee.std_logic_1164.all;

-- synthesis translate_off
library pcixpcicore_lib;
-- synthesis translate_on

-- 
-- 
-- 

entity pcixcore is
  port (
    clk_pci : in std_logic;
    rst_pci : in std_logic;
    idsel_pci : in std_logic;
    lock_pci : in std_logic;
    m66en_pci : in std_logic;
    ad_pci : inout std_logic_vector(63 downto 0);
    frame_pci : inout std_logic;
    req64_pci : inout std_logic;
    cbe_pci : inout std_logic_vector(7 downto 0);
    irdy_pci : inout std_logic;
    req_pci : inout std_logic;
    gnt_pci : in std_logic;
    trdy_pci : inout std_logic;
    stop_pci : inout std_logic;
    devsel_pci : inout std_logic;
    ack64_pci : inout std_logic;
    par_pci : inout std_logic;
    par64_pci : inout std_logic;
    perr_pci : inout std_logic;
    serr_pci : inout std_logic;
    s_sm : out std_logic_vector(7 downto 0);
    s_busmode : out std_logic_vector(2 downto 0);
    s_response : in std_logic_vector(2 downto 0);
    s_addr : out std_logic_vector(63 downto 0);
    s_bar : out std_logic_vector(7 downto 0);
    s_read : out std_logic;
    s_write : out std_logic;
    s_64flag : out std_logic;
    s_data_in : in std_logic_vector(63 downto 0);
    s_data_out : out std_logic_vector(63 downto 0);
    s_bytevalid : out std_logic_vector(7 downto 0);
    s_bytecount : out std_logic_vector(12 downto 0);
    pm_resetn : out std_logic_vector(1 downto 0);
    prot0_out : out std_logic;
    prot1_out : out std_logic;
    prot1_in : in std_logic_vector(1 downto 0);
    m_data_in : in std_logic_vector(63 downto 0);
    m_be_in : in std_logic_vector(7 downto 0);
    m_dma0_regin : in std_logic_vector(127 downto 0);
    m_dma0_control : in std_logic_vector(4 downto 0);
    m_dma0_datacnt : in std_logic_vector(10 downto 0);
    m_dma0_status : out std_logic_vector(8 downto 0);
    m_dma0_regout : out std_logic_vector(127 downto 0);
    m_dma1_regin : in std_logic_vector(127 downto 0);
    m_dma1_control : in std_logic_vector(4 downto 0);
    m_dma1_datacnt : in std_logic_vector(10 downto 0);
    m_dma1_status : out std_logic_vector(8 downto 0);
    m_dma1_regout : out std_logic_vector(127 downto 0));

end pcixcore;

architecture structural of pcixcore is
  component pcix_mtcore
    generic (
      TECHNOLOGY : integer;
      DPS : integer;
      CPS : integer);
    port (
      clk_in : in std_logic;
      rst_in : in std_logic;
      rst_oe : out std_logic;
      npor_in : in std_logic;
      idsel_in : in std_logic;
      lock_in : in std_logic;
      m66en_in : in std_logic;
      ad_in : in std_logic_vector (63 downto 0);
      ad_outcomb : out std_logic_vector (63 downto 0);
      ad_outreg : out std_logic_vector (63 downto 0);
      ad32_oecomb : out std_logic;
      ad32_oereg : out std_logic;
      ad64_oecomb : out std_logic;
      ad64_oereg : out std_logic;
      frame_in : in std_logic;
      frame_outcomb : out std_logic;
      frame_outreg : out std_logic;
      frame_oecomb : out std_logic;
      frame_oereg : out std_logic;
      req64_in : in std_logic;
      req64_outcomb : out std_logic;
      req64_outreg : out std_logic;
      cbe_in : in std_logic_vector (7 downto 0);
      cbe_outcomb : out std_logic_vector (7 downto 0);
      cbe_outreg : out std_logic_vector (7 downto 0);
      cbe32_oecomb : out std_logic;
      cbe32_oereg : out std_logic;
      cbe64_oecomb : out std_logic;
      cbe64_oereg : out std_logic;
      irdy_in : in std_logic;
      irdy_outcomb : out std_logic;
      irdy_outreg : out std_logic;
      irdy_oecomb : out std_logic;
      irdy_oereg : out std_logic;
      req_outcomb : out std_logic;
      req_outreg : out std_logic;
      gnt_in : in std_logic;
      trdy_in : in std_logic;
      trdy_outcomb : out std_logic;
      trdy_outreg : out std_logic;
      trdy_oecomb : out std_logic;
      trdy_oereg : out std_logic;
      stop_in : in std_logic;
      stop_outcomb : out std_logic;
      stop_outreg : out std_logic;
      devsel_in : in std_logic;
      devsel_outcomb : out std_logic;
      devsel_outreg : out std_logic;
      ack64_in : in std_logic;
      ack64_outcomb : out std_logic;
      ack64_outreg : out std_logic;
      par_in : in std_logic;
      par_outcomb : out std_logic;
      par_outreg : out std_logic;
      par_oecomb : out std_logic;
      par_oereg : out std_logic;
      par64_in : in std_logic;
      par64_outcomb : out std_logic;
      par64_outreg : out std_logic;
      par64_oecomb : out std_logic;
      par64_oereg : out std_logic;
      perr_in : in std_logic;
      perr_outcomb : out std_logic;
      perr_outreg : out std_logic;
      perr_oecomb : out std_logic;
      perr_oereg : out std_logic;
      serr_oecomb : out std_logic;
      serr_oereg : out std_logic;
      inta_oecomb : out std_logic;
      intb_oecomb : out std_logic;
      cint_oecomb : out std_logic;
      pme_oecomb : out std_logic;
      k_core_param : in std_logic_vector (31 downto 0);
      k_busdev_num : in std_logic_vector (12 downto 0);
      k_conf0 : in std_logic_vector (223 downto 0);
      k_conf1 : in std_logic_vector (223 downto 0);
      k_bar_addr0 : in std_logic_vector (223 downto 0);
      k_bar_addr1 : in std_logic_vector (223 downto 0);
      k_bar_mask0 : in std_logic_vector (223 downto 0);
      k_bar_mask1 : in std_logic_vector (223 downto 0);
      k_bar_param0 : in std_logic_vector (6 downto 0);
      k_bar_param1 : in std_logic_vector (6 downto 0);
      k_pm0 : in std_logic_vector (15 downto 0);
      k_pm1 : in std_logic_vector (15 downto 0);
      k_pcix_param0 : in std_logic_vector (15 downto 0);
      k_pcix_param1 : in std_logic_vector (15 downto 0);
      s_sm : out std_logic_vector (7 downto 0);
      s_busmode : out std_logic_vector (2 downto 0);
      s_pllmode : out std_logic_vector (2 downto 0);
      s_conf_sc0 : out std_logic_vector (31 downto 0);
      s_conf_sc1 : out std_logic_vector (31 downto 0);
      s_response : in std_logic_vector (2 downto 0);
      s_function : out std_logic;
      s_addr : out std_logic_vector (63 downto 0);
      s_bar : out std_logic_vector (7 downto 0);
      s_read : out std_logic;
      s_write : out std_logic;
      s_64flag : out std_logic;
      s_int_ack : out std_logic;
      s_data_in : in std_logic_vector (63 downto 0);
      s_data_out : out std_logic_vector (63 downto 0);
      s_bytevalid : out std_logic_vector (7 downto 0);
      s_bytecount : out std_logic_vector (12 downto 0);
      s_command : out std_logic_vector (3 downto 0);
      s_intrequest : in std_logic_vector (1 downto 0);
      s_split_param : out std_logic_vector (31 downto 0);
      s_split_bytecount : out std_logic_vector (12 downto 0);
      s_split_start : out std_logic;
      pm_state : out std_logic_vector (3 downto 0);
      pm_event : in std_logic_vector (1 downto 0);
      pm_resetn : out std_logic_vector (1 downto 0);
      pm_select : out std_logic_vector (7 downto 0);
      pm_data : in std_logic_vector (19 downto 0);
      jtag_tdo : in std_logic;
      jtag_out : out std_logic_vector (2 downto 0);
      jtag_oe : out std_logic;
      fc_status : in std_logic_vector (2 downto 0);
      fc_control : out std_logic_vector (2 downto 0);
      cpci_handle : in std_logic;
      cpci_led : out std_logic;
      cpci_enum_oecomb : out std_logic;
      prot0_out : out std_logic;
      prot1_out : out std_logic;
      prot1_in : in std_logic_vector (1 downto 0);
      m_data_in : in std_logic_vector (63 downto 0);
      m_be_in : in std_logic_vector (7 downto 0);
      m_split0_param : in std_logic_vector (31 downto 0);
      m_split0_bytecount : in std_logic_vector (12 downto 0);
      m_split0_start : in std_logic;
      m_split0_error : in std_logic_vector (1 downto 0);
      m_split0_datacnt : in std_logic_vector (10 downto 0);
      m_split0_status : out std_logic_vector (7 downto 0);
      m_split1_param : in std_logic_vector (31 downto 0);
      m_split1_bytecount : in std_logic_vector (12 downto 0);
      m_split1_start : in std_logic;
      m_split1_error : in std_logic_vector (1 downto 0);
      m_split1_datacnt : in std_logic_vector (10 downto 0);
      m_split1_status : out std_logic_vector (7 downto 0);
      m_dma0_regin : in std_logic_vector (127 downto 0);
      m_dma0_control : in std_logic_vector (4 downto 0);
      m_dma0_datacnt : in std_logic_vector (10 downto 0);
      m_dma0_status : out std_logic_vector (8 downto 0);
      m_dma0_regout : out std_logic_vector (127 downto 0);
      m_dma1_regin : in std_logic_vector (127 downto 0);
      m_dma1_control : in std_logic_vector (4 downto 0);
      m_dma1_datacnt : in std_logic_vector (10 downto 0);
      m_dma1_status : out std_logic_vector (8 downto 0);
      m_dma1_regout : out std_logic_vector (127 downto 0);
      m_dma2_regin : in std_logic_vector (127 downto 0);
      m_dma2_control : in std_logic_vector (4 downto 0);
      m_dma2_datacnt : in std_logic_vector (10 downto 0);
      m_dma2_status : out std_logic_vector (8 downto 0);
      m_dma2_regout : out std_logic_vector (127 downto 0);
      m_dma3_regin : in std_logic_vector (127 downto 0);
      m_dma3_control : in std_logic_vector (4 downto 0);
      m_dma3_datacnt : in std_logic_vector (10 downto 0);
      m_dma3_status : out std_logic_vector (8 downto 0);
      m_dma3_regout : out std_logic_vector (127 downto 0);
      udma_request : in std_logic;
      udma_64 : in std_logic;
      udma_function : in std_logic;
      udma_be : in std_logic_vector (3 downto 0);
      udma_address : in std_logic_vector (63 downto 0);
      udma_command : in std_logic_vector (3 downto 0);
      udma_bytecount : in std_logic_vector (12 downto 0);
      udma_tag : in std_logic_vector (3 downto 0);
      udma_channel : out std_logic;
      udma_select : out std_logic;
      udma_masteren : out std_logic_vector (1 downto 0);
      udma_termination : out std_logic_vector (2 downto 0);
      udma_rd : out std_logic;
      udma_rdlsb : out std_logic;
      udma_wr : out std_logic;
      udma_bcount : out std_logic_vector (3 downto 0);
      udma_spresp_wait : in std_logic_vector (15 downto 0);
      udma_spresp_64 : in std_logic_vector (15 downto 0);
      udma_spresp_channel : out std_logic_vector (15 downto 0);
      udma_spresp_rd : out std_logic;
      udma_spresp_rdlsb : out std_logic;
      udma_spresp_bcount : out std_logic_vector (3 downto 0);
      udma_spresp_error : out std_logic);
  end component;

  signal ZERO : std_logic_vector (255 downto 0);
  signal rst_oe : std_logic;
  signal npor : std_logic;
  signal ad_outcomb : std_logic_vector (63 downto 0);
  signal ad_outreg : std_logic_vector (63 downto 0);
  signal ad32_oecomb : std_logic;
  signal ad32_oereg : std_logic;
  signal ad64_oecomb : std_logic;
  signal ad64_oereg : std_logic;
  signal frame_outcomb : std_logic;
  signal frame_outreg : std_logic;
  signal frame_oecomb : std_logic;
  signal frame_oereg : std_logic;
  signal req64_outcomb : std_logic;
  signal req64_outreg : std_logic;
  signal cbe_outcomb : std_logic_vector (7 downto 0);
  signal cbe_outreg : std_logic_vector (7 downto 0);
  signal cbe32_oecomb : std_logic;
  signal cbe32_oereg : std_logic;
  signal cbe64_oecomb : std_logic;
  signal cbe64_oereg : std_logic;
  signal irdy_outcomb : std_logic;
  signal irdy_outreg : std_logic;
  signal irdy_oecomb : std_logic;
  signal irdy_oereg : std_logic;
  signal req_outcomb : std_logic;
  signal req_outreg : std_logic;
  signal trdy_outcomb : std_logic;
  signal trdy_outreg : std_logic;
  signal trdy_oecomb : std_logic;
  signal trdy_oereg : std_logic;
  signal stop_outcomb : std_logic;
  signal stop_outreg : std_logic;
  signal devsel_outcomb : std_logic;
  signal devsel_outreg : std_logic;
  signal ack64_outcomb : std_logic;
  signal ack64_outreg : std_logic;
  signal par_outcomb : std_logic;
  signal par_outreg : std_logic;
  signal par_oecomb : std_logic;
  signal par_oereg : std_logic;
  signal par64_outcomb : std_logic;
  signal par64_outreg : std_logic;
  signal par64_oecomb : std_logic;
  signal par64_oereg : std_logic;
  signal perr_outcomb : std_logic;
  signal perr_outreg : std_logic;
  signal perr_oecomb : std_logic;
  signal perr_oereg : std_logic;
  signal serr_oecomb : std_logic;
  signal serr_oereg : std_logic;
  signal inta_oecomb : std_logic;
  signal intb_oecomb : std_logic;
  signal cint_oecomb : std_logic;
  signal pme_oecomb : std_logic;
  signal k_core_param : std_logic_vector (31 downto 0);
  signal k_busdev_num : std_logic_vector (12 downto 0);
  signal k_conf0 : std_logic_vector (223 downto 0);
  signal k_bar_mask0 : std_logic_vector (223 downto 0);
  signal k_bar_param0 : std_logic_vector (6 downto 0);
  signal k_pm0 : std_logic_vector (15 downto 0);
  signal k_pm1 : std_logic_vector (15 downto 0);
  signal k_pcix_param0 : std_logic_vector (15 downto 0);
  signal k_pcix_param1 : std_logic_vector (15 downto 0);
  signal s_pllmode : std_logic_vector (2 downto 0);
  signal s_conf_sc0 : std_logic_vector (31 downto 0);
  signal s_conf_sc1 : std_logic_vector (31 downto 0);
  signal s_function : std_logic;
  signal s_int_ack : std_logic;
  signal s_command : std_logic_vector (3 downto 0);
  signal s_split_param : std_logic_vector (31 downto 0);
  signal s_split_bytecount : std_logic_vector (12 downto 0);
  signal s_split_start : std_logic;
  signal pm_state : std_logic_vector (3 downto 0);
  signal pm_select : std_logic_vector (7 downto 0);
  signal jtag_out : std_logic_vector (2 downto 0);
  signal jtag_oe : std_logic;
  signal fc_control : std_logic_vector (2 downto 0);
  signal cpci_led : std_logic;
  signal cpci_enum_oecomb : std_logic;
  signal m_split0_status : std_logic_vector (7 downto 0);
  signal m_split1_status : std_logic_vector (7 downto 0);
  signal m_dma2_status : std_logic_vector (8 downto 0);
  signal m_dma2_regout : std_logic_vector (127 downto 0);
  signal m_dma3_status : std_logic_vector (8 downto 0);
  signal m_dma3_regout : std_logic_vector (127 downto 0);
  signal udma_channel : std_logic;
  signal udma_select : std_logic;
  signal udma_masteren : std_logic_vector (1 downto 0);
  signal udma_termination : std_logic_vector (2 downto 0);
  signal udma_rd : std_logic;
  signal udma_rdlsb : std_logic;
  signal udma_wr : std_logic;
  signal udma_bcount : std_logic_vector (3 downto 0);
  signal udma_spresp_channel : std_logic_vector (15 downto 0);
  signal udma_spresp_rd : std_logic;
  signal udma_spresp_rdlsb : std_logic;
  signal udma_spresp_bcount : std_logic_vector (3 downto 0);
  signal udma_spresp_error : std_logic;

begin
  ZERO <=(others=>'0');
  npor <='1';
  k_core_param <=x"00002531";
  k_busdev_num <="1111111111111";
  k_conf0 <=x"00000000" & x"00701556" & x"00000000" & x"00000000" & x"04000006" & x"00000000" & x"00701556";
  k_bar_mask0 <=x"00000000" & x"00000000" & x"00000000" & x"00000000" & x"FFFFC000" & x"FFFFE000" & x"FFFFE000";
  k_bar_param0 <="0000111";
  k_pm0 <=x"0003";
  k_pm1 <=x"0003";
  k_pcix_param0 <=x"0003";
  k_pcix_param1 <=x"0003";

  core_inst : pcix_mtcore
    generic map (
      TECHNOLOGY => 4,
      DPS => 64,
      CPS => 8)
    port map (
      clk_in => clk_pci,
      rst_in => rst_pci,
      rst_oe => rst_oe,
      npor_in => npor,
      idsel_in => idsel_pci,
      lock_in => lock_pci,
      m66en_in => m66en_pci,
      ad_in => ad_pci,
      ad_outcomb => ad_outcomb,
      ad_outreg => ad_outreg,
      ad32_oecomb => ad32_oecomb,
      ad32_oereg => ad32_oereg,
      ad64_oecomb => ad64_oecomb,
      ad64_oereg => ad64_oereg,
      frame_in => frame_pci,
      frame_outcomb => frame_outcomb,
      frame_outreg => frame_outreg,
      frame_oecomb => frame_oecomb,
      frame_oereg => frame_oereg,
      req64_in => req64_pci,
      req64_outcomb => req64_outcomb,
      req64_outreg => req64_outreg,
      cbe_in => cbe_pci,
      cbe_outcomb => cbe_outcomb,
      cbe_outreg => cbe_outreg,
      cbe32_oecomb => cbe32_oecomb,
      cbe32_oereg => cbe32_oereg,
      cbe64_oecomb => cbe64_oecomb,
      cbe64_oereg => cbe64_oereg,
      irdy_in => irdy_pci,
      irdy_outcomb => irdy_outcomb,
      irdy_outreg => irdy_outreg,
      irdy_oecomb => irdy_oecomb,
      irdy_oereg => irdy_oereg,
      req_outcomb => req_outcomb,
      req_outreg => req_outreg,
      gnt_in => gnt_pci,
      trdy_in => trdy_pci,
      trdy_outcomb => trdy_outcomb,
      trdy_outreg => trdy_outreg,
      trdy_oecomb => trdy_oecomb,
      trdy_oereg => trdy_oereg,
      stop_in => stop_pci,
      stop_outcomb => stop_outcomb,
      stop_outreg => stop_outreg,
      devsel_in => devsel_pci,
      devsel_outcomb => devsel_outcomb,
      devsel_outreg => devsel_outreg,
      ack64_in => ack64_pci,
      ack64_outcomb => ack64_outcomb,
      ack64_outreg => ack64_outreg,
      par_in => par_pci,
      par_outcomb => par_outcomb,
      par_outreg => par_outreg,
      par_oecomb => par_oecomb,
      par_oereg => par_oereg,
      par64_in => par64_pci,
      par64_outcomb => par64_outcomb,
      par64_outreg => par64_outreg,
      par64_oecomb => par64_oecomb,
      par64_oereg => par64_oereg,
      perr_in => perr_pci,
      perr_outcomb => perr_outcomb,
      perr_outreg => perr_outreg,
      perr_oecomb => perr_oecomb,
      perr_oereg => perr_oereg,
      serr_oecomb => serr_oecomb,
      serr_oereg => serr_oereg,
      inta_oecomb => inta_oecomb,
      intb_oecomb => intb_oecomb,
      cint_oecomb => cint_oecomb,
      pme_oecomb => pme_oecomb,
      k_core_param => k_core_param,
      k_busdev_num => k_busdev_num,
      k_conf0 => k_conf0,
      k_conf1 => ZERO(223 downto 0),
      k_bar_addr0 => ZERO(223 downto 0),
      k_bar_addr1 => ZERO(223 downto 0),
      k_bar_mask0 => k_bar_mask0,
      k_bar_mask1 => ZERO(223 downto 0),
      k_bar_param0 => k_bar_param0,
      k_bar_param1 => ZERO(6 downto 0),
      k_pm0 => k_pm0,
      k_pm1 => k_pm1,
      k_pcix_param0 => k_pcix_param0,
      k_pcix_param1 => k_pcix_param1,
      s_sm => s_sm,
      s_busmode => s_busmode,
      s_pllmode => s_pllmode,
      s_conf_sc0 => s_conf_sc0,
      s_conf_sc1 => s_conf_sc1,
      s_response => s_response,
      s_function => s_function,
      s_addr => s_addr,
      s_bar => s_bar,
      s_read => s_read,
      s_write => s_write,
      s_64flag => s_64flag,
      s_int_ack => s_int_ack,
      s_data_in => s_data_in,
      s_data_out => s_data_out,
      s_bytevalid => s_bytevalid,
      s_bytecount => s_bytecount,
      s_command => s_command,
      s_intrequest => ZERO(1 downto 0),
      s_split_param => s_split_param,
      s_split_bytecount => s_split_bytecount,
      s_split_start => s_split_start,
      pm_state => pm_state,
      pm_event => ZERO(1 downto 0),
      pm_resetn => pm_resetn,
      pm_select => pm_select,
      pm_data => ZERO(19 downto 0),
      jtag_tdo => ZERO(0),
      jtag_out => jtag_out,
      jtag_oe => jtag_oe,
      fc_status => ZERO(2 downto 0),
      fc_control => fc_control,
      cpci_handle => ZERO(0),
      cpci_led => cpci_led,
      cpci_enum_oecomb => cpci_enum_oecomb,
      prot0_out => prot0_out,
      prot1_out => prot1_out,
      prot1_in => prot1_in,
      m_data_in => m_data_in,
      m_be_in => m_be_in,
      m_split0_param => ZERO(31 downto 0),
      m_split0_bytecount => ZERO(12 downto 0),
      m_split0_start => ZERO(0),
      m_split0_error => ZERO(1 downto 0),
      m_split0_datacnt => ZERO(10 downto 0),
      m_split0_status => m_split0_status,
      m_split1_param => ZERO(31 downto 0),
      m_split1_bytecount => ZERO(12 downto 0),
      m_split1_start => ZERO(0),
      m_split1_error => ZERO(1 downto 0),
      m_split1_datacnt => ZERO(10 downto 0),
      m_split1_status => m_split1_status,
      m_dma0_regin => m_dma0_regin,
      m_dma0_control => m_dma0_control,
      m_dma0_datacnt => m_dma0_datacnt,
      m_dma0_status => m_dma0_status,
      m_dma0_regout => m_dma0_regout,
      m_dma1_regin => m_dma1_regin,
      m_dma1_control => m_dma1_control,
      m_dma1_datacnt => m_dma1_datacnt,
      m_dma1_status => m_dma1_status,
      m_dma1_regout => m_dma1_regout,
      m_dma2_regin => ZERO(127 downto 0),
      m_dma2_control => ZERO(4 downto 0),
      m_dma2_datacnt => ZERO(10 downto 0),
      m_dma2_status => m_dma2_status,
      m_dma2_regout => m_dma2_regout,
      m_dma3_regin => ZERO(127 downto 0),
      m_dma3_control => ZERO(4 downto 0),
      m_dma3_datacnt => ZERO(10 downto 0),
      m_dma3_status => m_dma3_status,
      m_dma3_regout => m_dma3_regout,
      udma_request => ZERO(0),
      udma_64 => ZERO(0),
      udma_function => ZERO(0),
      udma_be => ZERO(3 downto 0),
      udma_address => ZERO(63 downto 0),
      udma_command => ZERO(3 downto 0),
      udma_bytecount => ZERO(12 downto 0),
      udma_tag => ZERO(3 downto 0),
      udma_channel => udma_channel,
      udma_select => udma_select,
      udma_masteren => udma_masteren,
      udma_termination => udma_termination,
      udma_rd => udma_rd,
      udma_rdlsb => udma_rdlsb,
      udma_wr => udma_wr,
      udma_bcount => udma_bcount,
      udma_spresp_wait => ZERO(15 downto 0),
      udma_spresp_64 => ZERO(15 downto 0),
      udma_spresp_channel => udma_spresp_channel,
      udma_spresp_rd => udma_spresp_rd,
      udma_spresp_rdlsb => udma_spresp_rdlsb,
      udma_spresp_bcount => udma_spresp_bcount,
      udma_spresp_error => udma_spresp_error);

  serr_pci <='0' when serr_oereg='1' else 'Z';
  ad_pci(31 downto 0) <=ad_outreg(31 downto 0) when ad32_oereg='1' else "ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ";
  ad_pci(63 downto 32) <=ad_outreg(63 downto 32) when ad64_oereg='1' else "ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ";
  frame_pci <=frame_outreg when frame_oereg='1' else 'Z';
  req64_pci <=req64_outreg when frame_oereg='1' else 'Z';
  cbe_pci(3 downto 0) <=cbe_outreg(3 downto 0) when cbe32_oereg='1' else "ZZZZ";
  cbe_pci(7 downto 4) <=cbe_outreg(7 downto 4) when cbe64_oereg='1' else "ZZZZ";
  irdy_pci <=irdy_outreg when irdy_oereg='1' else 'Z';
  req_pci <=req_outreg when rst_oe='1' else 'Z';
  trdy_pci <=trdy_outreg when trdy_oereg='1' else 'Z';
  stop_pci <=stop_outreg when trdy_oereg='1' else 'Z';
  devsel_pci <=devsel_outreg when trdy_oereg='1' else 'Z';
  ack64_pci <=ack64_outreg when trdy_oereg='1' else 'Z';
  par_pci <=par_outreg when par_oereg='1' else 'Z';
  par64_pci <=par64_outreg when par64_oereg='1' else 'Z';
  perr_pci <=perr_outreg when perr_oereg='1' else 'Z';
end structural;


-- PARAM: PRV_VERSION 0x0707
-- PARAM: PRV_LANGUAGE 0
-- PARAM: TECHNOLOGY 4
-- PARAM: DPS 64
-- PARAM: CPS 8
-- PARAM: FUNCTION_COUNT 1
-- PARAM: SPLIT_COUNT 0
-- PARAM: PRV_BUSFREQ 0
-- PARAM: PRV_PCIMODE 2
-- PARAM: MSI_ENABLE 0
-- PARAM: DMA_COUNT 2
-- PARAM: DMA_SG 0
-- PARAM: PM_F0 0x0003
-- PARAM: BARPATH_F0 0x00000007
-- PARAM: CONF_D0_F0 0x00701556
-- PARAM: CONF_D1_F0 0x00000000
-- PARAM: CONF_D2_F0 0x04000006
-- PARAM: CONF_D3_F0 0x00000000
-- PARAM: CONF_D4_F0 0x00000000
-- PARAM: CONF_D5_F0 0x00701556
-- PARAM: CONF_D6_F0 0x00000000
-- PARAM: BARA_D0_F0 0x00000000
-- PARAM: BARA_D1_F0 0x00000000
-- PARAM: BARA_D2_F0 0x00000000
-- PARAM: BARA_D3_F0 0x00000000
-- PARAM: BARA_D4_F0 0x00000000
-- PARAM: BARA_D5_F0 0x00000000
-- PARAM: BARA_D6_F0 0x00000000
-- PARAM: BARS_D0_F0 13
-- PARAM: BARS_D1_F0 13
-- PARAM: BARS_D2_F0 14
-- PARAM: BARS_D3_F0 0
-- PARAM: BARS_D4_F0 0
-- PARAM: BARS_D5_F0 0
-- PARAM: BARS_D6_F0 0
-- PARAM: PM_F1 0x0003
-- PARAM: BARPATH_F1 0x00000000
-- PARAM: CONF_D0_F1 0x00000000
-- PARAM: CONF_D1_F1 0x00000000
-- PARAM: CONF_D2_F1 0x00000000
-- PARAM: CONF_D3_F1 0x00000000
-- PARAM: CONF_D4_F1 0x00000000
-- PARAM: CONF_D5_F1 0x00000000
-- PARAM: CONF_D6_F1 0x00000000
-- PARAM: BARA_D0_F1 0x00000000
-- PARAM: BARA_D1_F1 0x00000000
-- PARAM: BARA_D2_F1 0x00000000
-- PARAM: BARA_D3_F1 0x00000000
-- PARAM: BARA_D4_F1 0x00000000
-- PARAM: BARA_D5_F1 0x00000000
-- PARAM: BARA_D6_F1 0x00000000
-- PARAM: BARS_D0_F1 0
-- PARAM: BARS_D1_F1 0
-- PARAM: BARS_D2_F1 0
-- PARAM: BARS_D3_F1 0
-- PARAM: BARS_D4_F1 0
-- PARAM: BARS_D5_F1 0
-- PARAM: BARS_D6_F1 0
-- PARAM: PRV_FEINTR 0
-- PARAM: JTAG_ENABLE 0
-- PARAM: FLASH_ENABLE 0
-- PARAM: PRV_PCI66 0
-- PARAM: PRV_PCIXSPEED 2
-- PARAM: PRV_CARDBUS 0
-- PARAM: PRV_CPCIHS 0
-- PARAM: INT_ACK_SUPPORT 0
-- PARAM: PRV_PM_MODE 0
-- PARAM: PRV_S_COMMAND 0
-- PARAM: PRV_C_CONF_SR 0
-- PARAM: PRV_S_PLLMODE 0
-- PARAM: PRV_BACKCONF 0
-- PARAM: PRV_BACKPM 0
-- PARAM: PRV_BACKBAR 0
-- PARAM: PRV_BACKBUS 0
-- PARAM: PRV_UDMA 0
-- PARAM: PRV_BACKPCIX 0
-- PARAM: PRV_TESTBENCH 0
-- PARAM: PRV_PINOUT 0
-- PARAM: PRV_VOLTAGE 1
-- PARAM: PRV_DEVICE 'DEV=EP1SGX40GF1020C5,BRD=XpressBridge,PIN=stratix_boards/xpressbridge,64BIT,PCI66,PCIX,X133'
-- PARAM: PRV_PROJECT 'xhib'
-- PARAM: PRV_TOPLEVEL 'top'
-- PARAM: PRV_FAMILY 7
-- PARAM: PRV_AGENT 1
-- PARAM: PRV_PNP 0

