library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity pfpga3 is 
  port(
    o_led : out std_logic_vector(2 downto 0);
    o_cid: in std_logic_vector(2 downto 0);  

    l_tx : out std_logic_vector(17 downto 0);
    l_txclk : out std_logic;
    l_rx : in std_logic_vector(17 downto 0);
    l_rxclk: in std_logic;

    lo_iclk1: in std_logic;
    lo_eclk1: out std_logic;
    lo_iclk2: in std_logic;
    lo_eclk2: out std_logic;
    
    p1_in : in std_logic_vector(3 downto 0);
    p1_out : out std_logic_vector(2 downto 0)
    );
end pfpga3;

architecture hierarchy of pfpga3 is
  
  component pfpgapll
    PORT
      (
        inclk0    : IN STD_LOGIC  := '0';
        c0        : OUT STD_LOGIC ;
        c1        : OUT STD_LOGIC ;
        c2        : OUT STD_LOGIC 
    );
  end component;

  component pfpgapll1
    PORT
      (
        inclk0    : IN STD_LOGIC  := '0';
        c0        : OUT STD_LOGIC;
        c1        : OUT STD_LOGIC;
        c2        : OUT STD_LOGIC
    );
  end component;

  component pfpgaddioout
    PORT
      (
        datain_h        : IN STD_LOGIC_VECTOR (17 DOWNTO 0);
        datain_l        : IN STD_LOGIC_VECTOR (17 DOWNTO 0);
        outclock        : IN STD_LOGIC ;
        dataout        : OUT STD_LOGIC_VECTOR (17 DOWNTO 0)
    );
  end component;

  component pfpgaddioin
    PORT
      (
        datain        : IN STD_LOGIC_VECTOR (17 DOWNTO 0);
        inclock        : IN STD_LOGIC ;
        dataout_h        : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
        dataout_l        : OUT STD_LOGIC_VECTOR (17 DOWNTO 0)
    );
  end component;

  component backend
    port (
      hib_clk              : in std_logic;
      rst                  : in std_logic; -- negative logic
      board_info           : out std_logic_vector(31 downto 0);

      -- DMA signals
      hib_we               : in std_logic;
      hib_data             : in std_logic_vector(63 downto 0);
      backend_we           : out std_logic;
      backend_data         : out std_logic_vector(63 downto 0);
      backend_run          : out std_logic
      );
  end component;

  component pfpgafifo64
    PORT
      (
        data            : IN STD_LOGIC_VECTOR (63 DOWNTO 0);
        wrreq          : IN STD_LOGIC ;
        rdreq           : IN STD_LOGIC ;
        rdclk           : IN STD_LOGIC ;
        wrclk           : IN STD_LOGIC ;
        q               : OUT STD_LOGIC_VECTOR (63 DOWNTO 0);
        rdempty         : OUT STD_LOGIC
        );
  end component;

  component lpm_add_sub
    generic (LPM_WIDTH: integer;
             LPM_DIRECTION: string);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  signal hib_clk             : std_logic;
  signal backend_clk0        : std_logic;
  signal backend_clk1        : std_logic;
  signal backend_clk2        : std_logic;
  signal clk,clk2f,clkout,clkb : std_logic;
  signal rxout_h, rxout_h0, rxout_h1, rxout_l, rxout_l0 : std_logic_vector(17 downto 0);
  signal rxout3, rxout2, rxout1, rxout0 : std_logic_vector(17 downto 0);
  signal txin_h, txin_l : std_logic_vector(17 downto 0);
  signal rx_out_sig : std_logic_vector(71 downto 0);
  signal rx_out_sig1 : std_logic_vector(71 downto 0);  
  signal tx_in_sig : std_logic_vector(71 downto 0);  
  signal tx_in : std_logic_vector(71 downto 0);

  signal reg,cnt : std_logic_vector(2 downto 0);
  signal rst : std_logic;
  signal backend_we,backend_we0 : std_logic;
  signal backend_run,backend_run1,runt,hib_we1,wet : std_logic;
  signal backend_data : std_logic_vector(63 downto 0);
  signal hib_data : std_logic_vector(63 downto 0);  
  signal fifoout : std_logic_vector(63 downto 0);
  signal fifo_empty, fifo_noempty: std_logic;
  signal hib_we,rdreq,rdreq1,req_flag,ok_flag : std_logic;
  
  signal wrreq_out,rdreq_out,rdempty_out : std_logic;
  signal tx_in_sig_out : std_logic_vector(71 downto 0);

  signal adddata : std_logic_vector(63 downto 0);
  signal adddata2 : std_logic_vector(63 downto 0);
  signal adddatau : std_logic_vector(3 downto 0);
  signal adddata3 : std_logic_vector(67 downto 0);

begin

  pll_inst : pfpgapll PORT MAP (
    inclk0     => l_rxclk,
    c0     => hib_clk,                -- interface clock @ 100MHz
    c1     => clk2f,
    c2     => clkout
    );

  -- frequency defined in 'ifpgapll1.vhd' can be modified by QuartusII MegaWizard.
  lo_eclk1 <= hib_clk;
  clk <= hib_clk;
  pll1_inst : pfpgapll1 PORT MAP (
    inclk0     => lo_iclk1,
    c0 => backend_clk0,           -- backend clock @ 133MHz
    c1 => backend_clk1,           -- backend clock @ 100MHz
    c2 => backend_clk2            -- backend clock @ 100MHz
    );

  ddioin_inst : pfpgaddioin PORT MAP (
    datain     => l_rx,
    inclock     => clk2f,
    dataout_h  => rxout_h0,
    dataout_l  => rxout_l0
    );

  process(clk2f)
  begin
    if(clk2f'event and clk2f='1') then
      rxout_h  <= rxout_h0;
    end if;
  end process;

  process(clk2f)
  begin
    if(clk2f'event and clk2f='1') then
      rxout_l  <= rxout_l0;
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      rxout3 <= rxout_l;
      rxout2 <= rxout_h;            
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='0') then
      rxout1 <= rxout_l;
      rxout0 <= rxout_h;            
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      rx_out_sig <= rxout3(17) & rxout2(17) & rxout1(17) & rxout0(17) & rxout3(16) & rxout2(16) & rxout1(16) & rxout0(16)
                    & rxout3(15) & rxout2(15) & rxout1(15) & rxout0(15) & rxout3(14) & rxout2(14) & rxout1(14) & rxout0(14)
                    & rxout3(13) & rxout2(13) & rxout1(13) & rxout0(13) & rxout3(12) & rxout2(12) & rxout1(12) & rxout0(12)
                    & rxout3(11) & rxout2(11) & rxout1(11) & rxout0(11) & rxout3(10) & rxout2(10) & rxout1(10) & rxout0(10)
                    & rxout3(9) & rxout2(9) & rxout1(9) & rxout0(9) & rxout3(8) & rxout2(8) & rxout1(8) & rxout0(8)
                    & rxout3(7) & rxout2(7) & rxout1(7) & rxout0(7) & rxout3(6) & rxout2(6) & rxout1(6) & rxout0(6)
                    & rxout3(5) & rxout2(5) & rxout1(5) & rxout0(5) & rxout3(4) & rxout2(4) & rxout1(4) & rxout0(4)
                    & rxout3(3) & rxout2(3) & rxout1(3) & rxout0(3) & rxout3(2) & rxout2(2) & rxout1(2) & rxout0(2)
                    & rxout3(1) & rxout2(1) & rxout1(1) & rxout0(1) & rxout3(0) & rxout2(0) & rxout1(0) & rxout0(0);
    end if;
  end process;

-- ----------------------------------------------------------------------------

  process(clk)
  begin
    if(clk'event and clk='1') then
      if(rx_out_sig(70 downto 68) = o_cid) then 
        hib_we <= rx_out_sig(71);
      elsif(rx_out_sig(70 downto 68) = "000") then
        hib_we <= rx_out_sig(71);
      else
        hib_we <= '0';
      end if;
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      hib_data <= rx_out_sig(63 downto 0);
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      if(rx_out_sig(71) = '1') then
--         o_led  <= rx_out_sig(6 downto 4);
        p1_out <= rx_out_sig(2 downto 0);
      end if;
    end if;
  end process;

--  rst <= not rx_out_sig(64);
  rst <= '1';
  backend_instance : backend
    port map (
      hib_clk      => hib_clk,
      rst          => rst,
      board_info   => open,
      hib_we       => hib_we,
      hib_data     => hib_data,
      backend_we   => backend_we,
      backend_run  => backend_run,      
      backend_data => backend_data
      );

  fifo_instance : pfpgafifo64
    port map (
      data => backend_data,
      wrreq => backend_we,
      wrclk => clk,
      rdreq  => rdreq, 
      rdempty  => fifo_empty,
      q  => fifoout,
      rdclk  => clk
      );

  req_flag <= fifo_noempty;
  fifo_noempty <= not fifo_empty;

  with rx_out_sig(71 downto 68) select
    rdreq <= '1' when "1111",
             '0' when others;

  process(clk)
  begin
    if(clk'event and clk='1') then
       rdreq1 <= rdreq;
       adddata <= rx_out_sig(63 downto 0);
       adddatau <= rx_out_sig(67 downto 64);
       rx_out_sig1 <= rx_out_sig;
    end if;
  end process;

  u1: lpm_add_sub generic map (LPM_WIDTH=>64,LPM_DIRECTION=>"ADD")
    port map(result=>adddata2,dataa=>adddata,datab=>fifoout);

  process(clk)
  begin
    if(clk'event and clk='1') then
      if(rdreq1 ='1') then
        tx_in_sig <= "1111" & adddatau & adddata2;
      else
        tx_in_sig <= rx_out_sig1;
      end if;
    end if;
  end process;

--   p1_out(0) <= req_flag;
--   ok_flag <= p1_in(0);

  ok_flag <= req_flag;

  process(clk)
  begin
    if(clk'event and clk='1') then
      backend_run1 <= backend_run;
      if(backend_run = '1' and backend_run1 = '0') then
        cnt <= cnt + "001";
      end if;          
    end if;
  end process;
  o_led <= cnt;
  
------------------------------------------------------------------------------

  tx_in <= tx_in_sig;
  process(clk2f)
  begin
    if(clk2f'event and clk2f='0') then
      if(clk = '1') then
        txin_h  <= tx_in(71) & tx_in(67)
                   & tx_in(63) & tx_in(59) & tx_in(55) & tx_in(51) & tx_in(47) & tx_in(43) & tx_in(39) & tx_in(35)
                   & tx_in(31) & tx_in(27) & tx_in(23) & tx_in(19) & tx_in(15) & tx_in(11) & tx_in(7) & tx_in(3);
        txin_l  <= tx_in(70) & tx_in(66)
                   & tx_in(62) & tx_in(58) & tx_in(54) & tx_in(50) & tx_in(46) & tx_in(42) & tx_in(38) & tx_in(34)
                   & tx_in(30) & tx_in(26) & tx_in(22) & tx_in(18) & tx_in(14) & tx_in(10) & tx_in(6) & tx_in(2);
      else
        txin_h  <= tx_in(69) & tx_in(65)
                   & tx_in(61) & tx_in(57) & tx_in(53) & tx_in(49) & tx_in(45) & tx_in(41) & tx_in(37) & tx_in(33)
                   & tx_in(29) & tx_in(25) & tx_in(21) & tx_in(17) & tx_in(13) & tx_in(9) & tx_in(5) & tx_in(1);
        txin_l  <= tx_in(68) & tx_in(64)
                   & tx_in(60) & tx_in(56) & tx_in(52) & tx_in(48) & tx_in(44) & tx_in(40) & tx_in(36) & tx_in(32)
                   & tx_in(28) & tx_in(24) & tx_in(20) & tx_in(16) & tx_in(12) & tx_in(8) & tx_in(4) & tx_in(0);
      end if;
    end if;
  end process;

  ddioout_inst : pfpgaddioout PORT MAP (
    datain_h     => txin_h,
    datain_l     => txin_l,
    outclock     => clk2f,
    dataout      => l_tx
    );
  l_txclk <= clkout;
  
end hierarchy;
