
--+-------------------------+
--| PGPG Fixed-Point Sub    |
--|      by Tsuyoshi Hamada |
--+-------------------------+
library ieee;
use ieee.std_logic_1164.all;

entity pg_fix_sub_32_1 is
  port(x,y : in std_logic_vector(31 downto 0);
       z : out std_logic_vector(31 downto 0);
       clk : in std_logic);
end pg_fix_sub_32_1;
architecture rtl of pg_fix_sub_32_1 is
  component pg_adder_RCA_SUB_32_1
    port (x,y: in std_logic_vector(31 downto 0);
          z:  out std_logic_vector(31 downto 0);
          clk: in std_logic);
  end component;
begin
  u0: pg_adder_RCA_SUB_32_1
      port map(x=>x,y=>y,z=>z,clk=>clk);
end rtl;

--+--------------------------+
--| PGPG Ripple-Carry Adder  |
--|  2003/10/31              |
--|      by Tsuyoshi Hamada  |
--+--------------------------+
library ieee;
use ieee.std_logic_1164.all;

entity pg_adder_RCA_SUB_32_1 is
  port(x,y : in std_logic_vector(31 downto 0);
       z : out std_logic_vector(31 downto 0);
       clk : in std_logic);
end pg_adder_RCA_SUB_32_1;

architecture rtl of pg_adder_RCA_SUB_32_1 is
  component pg_lcell_ari
    generic (MASK: string := "96E8";
             FF: integer  := 1);
    port (x,y,ci,clk: in std_logic;
          z,co: out std_logic);
  end component;

  signal co : std_logic_vector(30 downto 0);
begin
-- ADDER: (32-b)*1 + (33-b)*0
-- [ADD: MASK="96E8", u0:ci='0'],[SUB: MASK="69B2", u0:ci='1']
--  0-stage (32-bit)--
  u0: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(0),y=>y(0),ci=>'1',clk=>clk,z=>z(0),co=>co(0));
  u1: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(1),y=>y(1),ci=>co(0),clk=>clk,z=>z(1),co=>co(1));
  u2: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(2),y=>y(2),ci=>co(1),clk=>clk,z=>z(2),co=>co(2));
  u3: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(3),y=>y(3),ci=>co(2),clk=>clk,z=>z(3),co=>co(3));
  u4: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(4),y=>y(4),ci=>co(3),clk=>clk,z=>z(4),co=>co(4));
  u5: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(5),y=>y(5),ci=>co(4),clk=>clk,z=>z(5),co=>co(5));
  u6: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(6),y=>y(6),ci=>co(5),clk=>clk,z=>z(6),co=>co(6));
  u7: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(7),y=>y(7),ci=>co(6),clk=>clk,z=>z(7),co=>co(7));
  u8: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(8),y=>y(8),ci=>co(7),clk=>clk,z=>z(8),co=>co(8));
  u9: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(9),y=>y(9),ci=>co(8),clk=>clk,z=>z(9),co=>co(9));
  u10: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(10),y=>y(10),ci=>co(9),clk=>clk,z=>z(10),co=>co(10));
  u11: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(11),y=>y(11),ci=>co(10),clk=>clk,z=>z(11),co=>co(11));
  u12: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(12),y=>y(12),ci=>co(11),clk=>clk,z=>z(12),co=>co(12));
  u13: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(13),y=>y(13),ci=>co(12),clk=>clk,z=>z(13),co=>co(13));
  u14: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(14),y=>y(14),ci=>co(13),clk=>clk,z=>z(14),co=>co(14));
  u15: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(15),y=>y(15),ci=>co(14),clk=>clk,z=>z(15),co=>co(15));
  u16: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(16),y=>y(16),ci=>co(15),clk=>clk,z=>z(16),co=>co(16));
  u17: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(17),y=>y(17),ci=>co(16),clk=>clk,z=>z(17),co=>co(17));
  u18: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(18),y=>y(18),ci=>co(17),clk=>clk,z=>z(18),co=>co(18));
  u19: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(19),y=>y(19),ci=>co(18),clk=>clk,z=>z(19),co=>co(19));
  u20: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(20),y=>y(20),ci=>co(19),clk=>clk,z=>z(20),co=>co(20));
  u21: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(21),y=>y(21),ci=>co(20),clk=>clk,z=>z(21),co=>co(21));
  u22: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(22),y=>y(22),ci=>co(21),clk=>clk,z=>z(22),co=>co(22));
  u23: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(23),y=>y(23),ci=>co(22),clk=>clk,z=>z(23),co=>co(23));
  u24: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(24),y=>y(24),ci=>co(23),clk=>clk,z=>z(24),co=>co(24));
  u25: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(25),y=>y(25),ci=>co(24),clk=>clk,z=>z(25),co=>co(25));
  u26: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(26),y=>y(26),ci=>co(25),clk=>clk,z=>z(26),co=>co(26));
  u27: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(27),y=>y(27),ci=>co(26),clk=>clk,z=>z(27),co=>co(27));
  u28: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(28),y=>y(28),ci=>co(27),clk=>clk,z=>z(28),co=>co(28));
  u29: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(29),y=>y(29),ci=>co(28),clk=>clk,z=>z(29),co=>co(29));
  u30: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(30),y=>y(30),ci=>co(29),clk=>clk,z=>z(30),co=>co(30));
  u31: pg_lcell_ari generic map (MASK=>"69B2", FF=>1)
     port map(x=>x(31),y=>y(31),ci=>co(30),clk=>clk,z=>z(31));
end rtl;
-- ***************************************************************
-- * PGPG FIXED-POINT TO LOGARITHMIC FORMAT CONVERTER            *
-- *  AUTHOR: Tsuyoshi Hamada                                    *
-- *  VERSION: 2.00                                              *
-- *  LAST MODIFIED AT Tue Jun 03 22:52:01 JST 2003              *
-- ***************************************************************
library ieee;
use ieee.std_logic_1164.all;

entity pg_conv_ftol_32_17_8_4 is
  port(fixdata : in std_logic_vector(31 downto 0);
       logdata : out std_logic_vector(16 downto 0);
       clk : in std_logic);
end pg_conv_ftol_32_17_8_4;

architecture rtl of pg_conv_ftol_32_17_8_4 is

  component table
  generic (IN_WIDTH: integer ;
           OUT_WIDTH: integer ;
           TABLE_FILE: string);
  port(indata : in std_logic_vector(IN_WIDTH-1 downto 0);
      outdata : out std_logic_vector(OUT_WIDTH-1 downto 0);
      clk : in std_logic);
  end component;

  component lpm_add_sub
    generic (LPM_WIDTH: integer;
             LPM_DIRECTION: string);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  component penc_31_5
    port( a : in std_logic_vector(30 downto 0);
          c : out std_logic_vector(4 downto 0));
  end component;

  component shift_ftol_30_10
    port( indata : in std_logic_vector(29 downto 0);
          control : in std_logic_vector(4 downto 0);
          outdata : out std_logic_vector(9 downto 0));
  end component;

  signal d1,d0: std_logic_vector(30 downto 0);
  signal d2: std_logic_vector(30 downto 0);
  signal d3,d3r: std_logic_vector(30 downto 0);
  signal one: std_logic_vector(30 downto 0);
  signal sign: std_logic;
  signal c1: std_logic_vector(4 downto 0);
  signal d4: std_logic_vector(29 downto 0);
  signal c2,c3,c4,add: std_logic_vector(4 downto 0);
  signal d5,d6: std_logic_vector(9 downto 0);
  signal sign0,sign0r,sign1,sign2,sign3: std_logic;
  signal nz0,nz1,nz2: std_logic;

begin

  d1 <=  NOT fixdata(30 downto 0);
  one <= "0000000000000000000000000000001";
  u1: lpm_add_sub generic map (LPM_WIDTH=>31,LPM_DIRECTION=>"ADD")
                  port map(result=>d2,dataa=>d1,datab=>one);
  d0 <= fixdata(30 downto 0);
  sign0 <= fixdata(31);

  with sign0 select
    d3 <= d0 when '0',
    d2 when others;

  process(clk) begin
    if(clk'event and clk='1') then
      d3r <= d3;
      sign1 <= sign0;
    end if;
  end process;

  u2: penc_31_5 port map (a=>d3r,c=>c1);
  with d3r select
    nz0 <= '0' when "0000000000000000000000000000000",
           '1' when others;

  process(clk) begin
    if(clk'event and clk='1') then
      d4 <= d3r(29 downto 0);
      c2 <= c1;
      sign2 <= sign1;
      nz1 <= nz0;
    end if;
  end process;

  u3: shift_ftol_30_10
            port map (indata=>d4,control=>c2,outdata=>d5);

  process(clk) begin
    if(clk'event and clk='1') then
      d6 <= d5;
      sign3 <= sign2;
      nz2 <= nz1;
      c3 <= c2;
    end if;
  end process;

  u4: table generic map(IN_WIDTH=>10,OUT_WIDTH=>8,TABLE_FILE=>"f10tl8.mif")
            port map(indata=>d6,outdata=>logdata(7 downto 0),clk=>clk);

  with d6 select
    add <= "00001" when "1111111111",
           "00001" when "1111111110",
           "00001" when "1111111101",
           "00000" when others;

  u5: lpm_add_sub generic map (LPM_WIDTH=>5,LPM_DIRECTION=>"ADD")
                  port map(result=>c4,dataa=>c3,datab=>add);

  logdata(14 downto 13) <= "00";

  process(clk) begin
    if(clk'event and clk='1') then
      logdata(16) <= sign3 ;
      logdata(15) <= nz2;
      logdata(12 downto 8) <= c4;
    end if;
  end process;

end rtl;

library ieee;
use ieee.std_logic_1164.all;

entity penc_31_5 is
port( a : in std_logic_vector(30 downto 0);
      c : out std_logic_vector(4 downto 0));
end penc_31_5;

architecture rtl of penc_31_5 is
begin

  process(a) begin
    if(a(30)='1') then
      c <= "11110";
    elsif(a(29)='1') then
      c <= "11101";
    elsif(a(28)='1') then
      c <= "11100";
    elsif(a(27)='1') then
      c <= "11011";
    elsif(a(26)='1') then
      c <= "11010";
    elsif(a(25)='1') then
      c <= "11001";
    elsif(a(24)='1') then
      c <= "11000";
    elsif(a(23)='1') then
      c <= "10111";
    elsif(a(22)='1') then
      c <= "10110";
    elsif(a(21)='1') then
      c <= "10101";
    elsif(a(20)='1') then
      c <= "10100";
    elsif(a(19)='1') then
      c <= "10011";
    elsif(a(18)='1') then
      c <= "10010";
    elsif(a(17)='1') then
      c <= "10001";
    elsif(a(16)='1') then
      c <= "10000";
    elsif(a(15)='1') then
      c <= "01111";
    elsif(a(14)='1') then
      c <= "01110";
    elsif(a(13)='1') then
      c <= "01101";
    elsif(a(12)='1') then
      c <= "01100";
    elsif(a(11)='1') then
      c <= "01011";
    elsif(a(10)='1') then
      c <= "01010";
    elsif(a(9)='1') then
      c <= "01001";
    elsif(a(8)='1') then
      c <= "01000";
    elsif(a(7)='1') then
      c <= "00111";
    elsif(a(6)='1') then
      c <= "00110";
    elsif(a(5)='1') then
      c <= "00101";
    elsif(a(4)='1') then
      c <= "00100";
    elsif(a(3)='1') then
      c <= "00011";
    elsif(a(2)='1') then
      c <= "00010";
    elsif(a(1)='1') then
      c <= "00001";
    else
      c <= "00000";
    end if;
  end process;

end rtl;

library ieee;
use ieee.std_logic_1164.all;

entity shift_ftol_30_10 is
  port( indata : in std_logic_vector(29 downto 0);
        control : in std_logic_vector(4 downto 0);
        outdata : out std_logic_vector(9 downto 0));
end shift_ftol_30_10;

architecture rtl of shift_ftol_30_10 is

  component lpm_clshift
    generic (LPM_WIDTH : POSITIVE;
             LPM_WIDTHDIST : POSITIVE);
    port(data : in std_logic_vector(LPM_WIDTH-1 downto 0);
         distance : in std_logic_vector(LPM_WIDTHDIST-1 downto 0);
         direction : in std_logic;
         result : out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  signal d0 : std_logic_vector(39 downto 0);
  signal o0 : std_logic_vector(39 downto 0);
  signal one : std_logic;

begin

  one <= '1';
  d0 <= indata & "0000000000";
  u1: lpm_clshift generic map (LPM_WIDTH=>40,LPM_WIDTHDIST=>5)
         port map (data=>d0,distance=>control,result=>o0,direction=>one);
  outdata <= o0(9 downto 0);

end rtl;

library ieee;
use ieee.std_logic_1164.all;

entity table is
  generic(IN_WIDTH: integer := 7;
       OUT_WIDTH: integer := 5;
       TABLE_FILE: string := "ftol.mif");
  port(indata : in std_logic_vector(IN_WIDTH-1 downto 0);
       outdata : out std_logic_vector(OUT_WIDTH-1 downto 0);
       clk : in std_logic);
end table;

architecture rtl of table is

  component lpm_rom
    generic (LPM_WIDTH: POSITIVE;
             LPM_WIDTHAD: POSITIVE;
          LPM_ADDRESS_CONTROL: STRING;
          LPM_FILE: STRING);
   port (address: in std_logic_vector(LPM_WIDTHAD-1 downto 0);
         outclock: in std_logic;
         q: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

begin

  u1: lpm_rom generic map (LPM_WIDTH=>OUT_WIDTH,
                           LPM_WIDTHAD=>IN_WIDTH,
                           LPM_ADDRESS_CONTROL=>"UNREGISTERED",
                           LPM_FILE=>TABLE_FILE)
  port map(address=>indata,outclock=>clk,q=>outdata);

end rtl;

library ieee;
use ieee.std_logic_1164.all;

entity pg_log_shift_1 is
  generic (PG_WIDTH: integer);
  port( x : in std_logic_vector(PG_WIDTH-1 downto 0);
	   y : out std_logic_vector(PG_WIDTH-1 downto 0);
	   clk : in std_logic);
end pg_log_shift_1;

architecture rtl of pg_log_shift_1 is

begin

  y <= '0' & x(PG_WIDTH-2) & x(PG_WIDTH-4 downto 0) & '0';

end rtl;

-- ***************************************************************
-- * PGPG UNSIGNED LOGARITHMIC ADDER(INTERPOLATED) MODULE        *
-- *  AUTHOR: Tsuyoshi Hamada                                    *
-- *  VERSION: 1.03                                              *
-- *  LAST MODIFIED AT Tue Mar 25 10:52:09 JST 2003              *
-- ***************************************************************
-- Nman	8-bit
-- Ncut	6-bit
-- Npipe	6
-- rom_c0(address)	6-bit
-- rom_c1(address)	6-bit
-- rom_c0(data)	10-bit
-- rom_c1(data)	9-bit

library ieee;
use ieee.std_logic_1164.all;

entity pg_log_unsigned_add_itp_17_8_6_6 is
  port( x,y : in std_logic_vector(16 downto 0);
        z : out std_logic_vector(16 downto 0);
        clock : in std_logic);
end pg_log_unsigned_add_itp_17_8_6_6;

architecture rtl of pg_log_unsigned_add_itp_17_8_6_6 is

  COMPONENT lpm_mult
    GENERIC (
      lpm_widtha            : INTEGER;
      lpm_widthb            : INTEGER;
      lpm_widthp            : INTEGER;
      lpm_widths            : INTEGER;
      lpm_type              : STRING;
      lpm_representation    : STRING;
      lpm_hint              : STRING
    );
    PORT (
      dataa : IN STD_LOGIC_VECTOR (lpm_widtha-1 DOWNTO 0);
      datab : IN STD_LOGIC_VECTOR (lpm_widthb-1 DOWNTO 0);
      result : OUT STD_LOGIC_VECTOR (lpm_widthp-1 DOWNTO 0)
    );
  END COMPONENT;

  COMPONENT reged_add_sub
    GENERIC (WIDTH: INTEGER;
             PIPELINE: INTEGER;
             DIRECTION: STRING);
    PORT (dataa,datab: in std_logic_vector(WIDTH-1 downto 0);
          clock: in std_logic;
          result: out std_logic_vector(WIDTH-1 downto 0));
  END COMPONENT;

  COMPONENT lpm_add_sub
    GENERIC (LPM_WIDTH: INTEGER;
             LPM_DIRECTION: STRING);
    PORT (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  END COMPONENT;

  component lcell_rom_a106_6_10_1
   port (indata: in std_logic_vector(5 downto 0);
         clk: in std_logic;
         outdata: out std_logic_vector(9 downto 0));
  end component;

  component lcell_rom_a906_6_9_1
   port (indata: in std_logic_vector(5 downto 0);
         clk: in std_logic;
         outdata: out std_logic_vector(8 downto 0));
  end component;


  signal x1,y1,xy : std_logic_vector(16 downto 0);
  signal yx : std_logic_vector(15 downto 0);
  signal xd,yd : std_logic_vector(15 downto 0);
  signal x2,x3,x4,x5,x6,x7,x8 : std_logic_vector(15 downto 0);
  signal d0,d1,d4 : std_logic_vector(15 downto 0);
  signal z0 : std_logic_vector(15 downto 0);
  signal sign0,sign1,sign2,sign3,sign4,sign5,sign6,sign7,sign8 : std_logic;
  signal signxy : std_logic_vector(1 downto 0);
  -- FOR TABLE SUB LOGIC
  signal df0,df1,df2,df3,df4,df5 : std_logic;
  signal d_isz0,d_isz1,d_isz2,d_isz3,d_isz4,d_isz5 : std_logic;
  signal d2 : std_logic_vector(8 downto 0);
  signal itp_x  : std_logic_vector(5 downto 0);
  signal itp_dx0,itp_dx1 : std_logic_vector(5 downto 0);
  signal itp_c0,itp_c0d0,itp_c0d1,itp_c0d2 : std_logic_vector(9 downto 0);
  signal itp_c1 : std_logic_vector(8 downto 0);
  signal itp_c1dx : std_logic_vector(14 downto 0);
  signal itp_c1dx_shift : std_logic_vector(9 downto 0);
  signal itp_c1dx2: std_logic_vector(9 downto 0);
  signal itp_subx,itp_suby,itp_subz: std_logic_vector(10 downto 0);
  signal itp_c0_c1dx: std_logic_vector(7 downto 0);
  signal itp_out0,itp_out1: std_logic_vector(7 downto 0);

begin

  x1 <= '0' & x(15 downto 0);
  y1 <= '0' & y(15 downto 0);

  --- PIPELINE 1 ---
  u1: reged_add_sub
       generic map(WIDTH=>17,DIRECTION=>"SUB",PIPELINE=>1)
       port map(dataa=>x1,datab=>y1,result=>xy,clock=>clock);
  u2: reged_add_sub
       generic map(WIDTH=>16,DIRECTION=>"SUB",PIPELINE=>1)
       port map(dataa=>y(15 downto 0),datab=>x(15 downto 0),result=>yx,clock=>clock);
  process(clock) begin
    if(clock'event and clock='1') then
      xd <= x(15 downto 0);
      yd <= y(15 downto 0);
      sign1 <= sign0;
    end if;
  end process;
  ------------------.


  x2 <= xd when xy(16)='0' else yd;
  d0 <= xy(15 downto 0) when xy(16)='0' else yx;

  signxy <= x(16)&y(16);
  with signxy select
    sign0 <= y(16) when "01",
             x(16) when others;

  --- PIPELINE 2 ---
  process(clock) begin
    if(clock'event and clock='1') then
      x3 <= x2;
      d1 <= d0;
      sign2 <= sign1;
    end if;
  end process;
  ------------------.


-- TABLE PART (START) ---------------------------------------------
-- INPUT  d1 : 16-bit
-- OUTPUT d4 : 16-bit
  df0 <= '1' when d1(15 downto 12)="0000" else '0';

  -- ALL OR -> NOT (PLUS) --
  d_isz0 <= '1' when d1(11 downto 0)="000000000000" else '0';

-- TABLE (INTERPOLATION) --
-- ***************************************************************
-- * PGPG UNSIGNED LOGARITHMIC ADDER MODULE OF                   *
-- * INTERPORATED TABLE LOGIC : f(x+dx) ~= c0(x) + c1(x)dx       *
-- *  c0(x) and c1(x) are chebyshev coefficients.                *
-- ***************************************************************
  itp_x   <= d1(11 downto 6);
  itp_dx0 <= d1(5 downto 0);

  --- PIPELINE 3 ---

  -- OUT REGISTERED TABLE --
  -- c0(x) --
  itp_c0_rom: lcell_rom_a106_6_10_1
  port map(indata=>itp_x,outdata=>itp_c0,clk=>clock);

  -- c1(x) --
  itp_c1_rom: lcell_rom_a906_6_9_1
  port map(indata=>itp_x,outdata=>itp_c1,clk=>clock);

  process(clock) begin
    if(clock'event and clock='1') then
      df1 <= df0;
      d_isz1 <= d_isz0;
      itp_dx1 <= itp_dx0;
    end if;
  end process;
  ------------------.


  --- PIPELINE 4,5 (OFF) ---
  -- ITP MULT --  9-bit * 6-bit -> 15-bit
  itp_mult: lpm_mult
    GENERIC MAP (
    lpm_widtha => 9,
    lpm_widthb => 6,
    lpm_widthp => 15,
    lpm_widths => 15,
    lpm_type => "LPM_MULT",
    lpm_representation => "UNSIGNED",
    lpm_hint => "MAXIMIZE_SPEED=1"
    )
    PORT MAP (
    dataa  => itp_c1,
    datab  => itp_dx1,
    result => itp_c1dx
    );
  ------------------.
  --- PIPELINE 4(OFF) ---
  df2 <= df1;
  d_isz2 <= d_isz1;
  itp_c0d0 <= itp_c0;
  ------------------.
  --- PIPELINE 5(OFF) ---
  df3 <= df2;
  d_isz3 <= d_isz2;
  itp_c0d1 <= itp_c0d0;
  ------------------.


  -- SHIFT >> 8-bit , JOINE ZERO-VECTORS TO THE UPPER-BIT
  itp_c1dx_shift <= "000" & itp_c1dx(14 downto 8);

  --- PIPELINE 6 ---
  process(clock) begin
    if(clock'event and clock='1') then
      df4 <= df3;
      d_isz4 <= d_isz3;
      itp_c0d2 <= itp_c0d1;
      itp_c1dx2 <= itp_c1dx_shift;
    end if;
  end process;
  ------------------.


  itp_subx <= '0' & itp_c0d2;
  itp_suby <= '0' & itp_c1dx2;
  itp_sub: lpm_add_sub
    generic map(LPM_WIDTH=>11,LPM_DIRECTION=>"SUB")
    port map(dataa=>itp_subx,datab=>itp_suby,result=>itp_subz);

  -- IF [f(x+dx)=c0(x)-c1(x)dx<0] THEN [f(x+dx) := 0] ELSE SHIFT >> 2-bit
  itp_c0_c1dx <= "00000000" when (itp_subz(10)='1') else itp_subz(9 downto 2);


  itp_out0 <= itp_c0_c1dx when (d_isz4='0') else "00000000";


  --- PIPELINE 7 ---
  process(clock) begin
    if(clock'event and clock='1') then
      df5 <= df4;
      d_isz5 <= d_isz4;
      itp_out1 <= itp_out0;
    end if;
  end process;
  ------------------.

  d2(8) <= d_isz5;
  d2(7 downto 0) <= itp_out1;
  d4(8 downto 0) <= d2 when (df5 = '1') else "000000000";
  d4(15 downto 9) <= "0000000";

-- TABLE PART (END) ---------------------------------------------


  --- PIPELINE 3 ---
  process(clock) begin
    if(clock'event and clock='1') then
      x4 <= x3;
      sign3 <= sign2;
    end if;
  end process;
  ------------------.

  --- PIPELINE 4(OFF) ---
  x5 <= x4;
  sign4 <= sign3;
  ------------------.

  --- PIPELINE 5(OFF) ---
  x6 <= x5;
  sign5 <= sign4;
  ------------------.

  --- PIPELINE 6 ---
  process(clock) begin
    if(clock'event and clock='1') then
      x7 <= x6;
      sign6 <= sign5;
    end if;
  end process;
  ------------------.

  --- PIPELINE 7 ---
  process(clock) begin
    if(clock'event and clock='1') then
      x8 <= x7;
      sign7 <= sign6;
    end if;
  end process;
  ------------------.

  --- PIPELINE 8(OFF) ---
  u4: lpm_add_sub generic map(LPM_WIDTH=>16,LPM_DIRECTION=>"ADD")
       port map(dataa=>x8,datab=>d4,result=>z0);

  sign8 <= sign7;
  ------------------.

  --- PIPELINE 9 ---
  process(clock) begin
    if(clock'event and clock='1') then
      z(15 downto 0) <= z0;
      z(16) <= sign8;
    end if;
  end process;
  ------------------.

end rtl;
-- ============= END  pg_log_unsigned_add interporation version

-- The Pipelined Add/Sub (LPM Wrapper)
-- Author: Tsuyoshi Hamada
-- Last Modified at Mar 31,2003
library ieee;
use ieee.std_logic_1164.all;

ENTITY reged_add_sub IS
  GENERIC(WIDTH : INTEGER;DIRECTION: STRING;PIPELINE: INTEGER);
    PORT (dataa,datab: in std_logic_vector(WIDTH-1 downto 0);
          clock: in std_logic;
          result: out std_logic_vector(WIDTH-1 downto 0));
END reged_add_sub;
ARCHITECTURE rtl OF reged_add_sub IS
  COMPONENT lpm_add_sub
    GENERIC (LPM_WIDTH: INTEGER;
             LPM_PIPELINE: INTEGER;
             LPM_DIRECTION: STRING);
    PORT (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          clock: in std_logic;
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  END COMPONENT;
BEGIN
  u1: lpm_add_sub GENERIC MAP(LPM_WIDTH=>WIDTH,LPM_DIRECTION=>DIRECTION,LPM_PIPELINE=>PIPELINE)
  PORT MAP(dataa=>dataa,datab=>datab,result=>result,clock=>clock);
END rtl;


-- ROM using Lcell not ESB
-- Author: Tsuyoshi Hamada
-- Last Modified at May 29,2003
-- In 6 Out 10 Stage 1 Type"a106"
library ieee;
use ieee.std_logic_1164.all;

entity lcell_rom_a106_6_10_1 is
  port( indata : in std_logic_vector(5 downto 0);
        clk : in std_logic;
        outdata : out std_logic_vector(9 downto 0));
end lcell_rom_a106_6_10_1;

architecture rtl of lcell_rom_a106_6_10_1 is

  component pg_lcell
    generic (MASK : string  := "ffff";
             FF   : integer :=0);
    port (x   : in  std_logic_vector(3 downto 0);
          z   : out std_logic;
          clk : in  std_logic);
  end component;

  signal adr0 : std_logic_vector(5 downto 0);
  signal adr1 : std_logic_vector(5 downto 0);
  signal adr2 : std_logic_vector(5 downto 0);
  signal lc_4_0 : std_logic_vector(9 downto 0);
  signal lc_4_1 : std_logic_vector(9 downto 0);
  signal lc_4_2 : std_logic_vector(9 downto 0);
  signal lc_4_3 : std_logic_vector(9 downto 0);
  signal lut_5_0,lc_5_0 : std_logic_vector(9 downto 0);
  signal lut_5_1,lc_5_1 : std_logic_vector(9 downto 0);
  signal lut_6_0,lc_6_0 : std_logic_vector(9 downto 0);

begin

  LC_000_00 : pg_lcell
  generic map(MASK=>"6305",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(0));

  LC_000_01 : pg_lcell
  generic map(MASK=>"B071",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(1));

  LC_000_02 : pg_lcell
  generic map(MASK=>"5877",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(2));

  LC_000_03 : pg_lcell
  generic map(MASK=>"DB41",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(3));

  LC_000_04 : pg_lcell
  generic map(MASK=>"665D",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(4));

  LC_000_05 : pg_lcell
  generic map(MASK=>"D449",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(5));

  LC_000_06 : pg_lcell
  generic map(MASK=>"CD11",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(6));

  LC_000_07 : pg_lcell
  generic map(MASK=>"3CCB",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(7));

  LC_000_08 : pg_lcell
  generic map(MASK=>"03C7",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(8));

  LC_000_09 : pg_lcell
  generic map(MASK=>"003F",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(9));

  LC_001_00 : pg_lcell
  generic map(MASK=>"9393",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(0));

  LC_001_01 : pg_lcell
  generic map(MASK=>"BBAA",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(1));

  LC_001_02 : pg_lcell
  generic map(MASK=>"8938",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(2));

  LC_001_03 : pg_lcell
  generic map(MASK=>"7893",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(3));

  LC_001_04 : pg_lcell
  generic map(MASK=>"0789",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(4));

  LC_001_05 : pg_lcell
  generic map(MASK=>"0078",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(5));

  LC_001_06 : pg_lcell
  generic map(MASK=>"0007",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(6));

--LC_001_07
  lc_4_1(7) <= '0';

--LC_001_08
  lc_4_1(8) <= '0';

--LC_001_09
  lc_4_1(9) <= '0';

  LC_002_00 : pg_lcell
  generic map(MASK=>"001A",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_2(0));

  LC_002_01 : pg_lcell
  generic map(MASK=>"0079",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_2(1));

  LC_002_02 : pg_lcell
  generic map(MASK=>"0007",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_2(2));

--LC_002_03
  lc_4_2(3) <= '0';

--LC_002_04
  lc_4_2(4) <= '0';

--LC_002_05
  lc_4_2(5) <= '0';

--LC_002_06
  lc_4_2(6) <= '0';

--LC_002_07
  lc_4_2(7) <= '0';

--LC_002_08
  lc_4_2(8) <= '0';

--LC_002_09
  lc_4_2(9) <= '0';

--LC_003_00
  lc_4_3(0) <= '0';

--LC_003_01
  lc_4_3(1) <= '0';

--LC_003_02
  lc_4_3(2) <= '0';

--LC_003_03
  lc_4_3(3) <= '0';

--LC_003_04
  lc_4_3(4) <= '0';

--LC_003_05
  lc_4_3(5) <= '0';

--LC_003_06
  lc_4_3(6) <= '0';

--LC_003_07
  lc_4_3(7) <= '0';

--LC_003_08
  lc_4_3(8) <= '0';

--LC_003_09
  lc_4_3(9) <= '0';

  adr0 <= indata;
  adr1(5 downto 4) <= adr0(5 downto 4);
  process(clk) begin
    if(clk'event and clk='1') then
      adr2(5) <= adr1(5);
    end if;
  end process;

--  =================================
  with adr1(4) select
    lut_5_0 <= lc_4_0 when '0',
              lc_4_1 when others;

  with adr1(4) select
    lut_5_1 <= lc_4_2 when '0',
              lc_4_3 when others;

--  =================================
  with adr2(5) select
    lut_6_0 <= lc_5_0 when '0',
              lc_5_1 when others;


--  =================================
  process(clk) begin
    if(clk'event and clk='1') then
      lc_5_0 <= lut_5_0;
      lc_5_1 <= lut_5_1;
    end if;
  end process;
--  =================================
    lc_6_0 <= lut_6_0;
  outdata <= lc_6_0;
end rtl;

-- ROM using Lcell not ESB
-- Author: Tsuyoshi Hamada
-- Last Modified at May 29,2003
-- In 6 Out 9 Stage 1 Type"a906"
library ieee;
use ieee.std_logic_1164.all;

entity lcell_rom_a906_6_9_1 is
  port( indata : in std_logic_vector(5 downto 0);
        clk : in std_logic;
        outdata : out std_logic_vector(8 downto 0));
end lcell_rom_a906_6_9_1;

architecture rtl of lcell_rom_a906_6_9_1 is

  component pg_lcell
    generic (MASK : string  := "ffff";
             FF   : integer :=0);
    port (x   : in  std_logic_vector(3 downto 0);
          z   : out std_logic;
          clk : in  std_logic);
  end component;

  signal adr0 : std_logic_vector(5 downto 0);
  signal adr1 : std_logic_vector(5 downto 0);
  signal adr2 : std_logic_vector(5 downto 0);
  signal lc_4_0 : std_logic_vector(8 downto 0);
  signal lc_4_1 : std_logic_vector(8 downto 0);
  signal lc_4_2 : std_logic_vector(8 downto 0);
  signal lc_4_3 : std_logic_vector(8 downto 0);
  signal lut_5_0,lc_5_0 : std_logic_vector(8 downto 0);
  signal lut_5_1,lc_5_1 : std_logic_vector(8 downto 0);
  signal lut_6_0,lc_6_0 : std_logic_vector(8 downto 0);

begin

  LC_000_00 : pg_lcell
  generic map(MASK=>"DD64",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(0));

  LC_000_01 : pg_lcell
  generic map(MASK=>"2F5F",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(1));

  LC_000_02 : pg_lcell
  generic map(MASK=>"47A2",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(2));

  LC_000_03 : pg_lcell
  generic map(MASK=>"7DEB",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(3));

  LC_000_04 : pg_lcell
  generic map(MASK=>"29E6",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(4));

  LC_000_05 : pg_lcell
  generic map(MASK=>"1B4B",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(5));

  LC_000_06 : pg_lcell
  generic map(MASK=>"F8D9",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(6));

  LC_000_07 : pg_lcell
  generic map(MASK=>"07C7",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(7));

  LC_000_08 : pg_lcell
  generic map(MASK=>"003F",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_0(8));

  LC_001_00 : pg_lcell
  generic map(MASK=>"5892",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(0));

  LC_001_01 : pg_lcell
  generic map(MASK=>"350A",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(1));

  LC_001_02 : pg_lcell
  generic map(MASK=>"F352",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(2));

  LC_001_03 : pg_lcell
  generic map(MASK=>"0F37",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(3));

  LC_001_04 : pg_lcell
  generic map(MASK=>"00F1",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(4));

  LC_001_05 : pg_lcell
  generic map(MASK=>"000F",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_1(5));

--LC_001_06
  lc_4_1(6) <= '0';

--LC_001_07
  lc_4_1(7) <= '0';

--LC_001_08
  lc_4_1(8) <= '0';

  LC_002_00 : pg_lcell
  generic map(MASK=>"0046",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_2(0));

  LC_002_01 : pg_lcell
  generic map(MASK=>"003E",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_2(1));

  LC_002_02 : pg_lcell
  generic map(MASK=>"0001",FF=>0)
  port map( x=>adr0(3 downto 0),clk=>clk,
            z=>lc_4_2(2));

--LC_002_03
  lc_4_2(3) <= '0';

--LC_002_04
  lc_4_2(4) <= '0';

--LC_002_05
  lc_4_2(5) <= '0';

--LC_002_06
  lc_4_2(6) <= '0';

--LC_002_07
  lc_4_2(7) <= '0';

--LC_002_08
  lc_4_2(8) <= '0';

--LC_003_00
  lc_4_3(0) <= '0';

--LC_003_01
  lc_4_3(1) <= '0';

--LC_003_02
  lc_4_3(2) <= '0';

--LC_003_03
  lc_4_3(3) <= '0';

--LC_003_04
  lc_4_3(4) <= '0';

--LC_003_05
  lc_4_3(5) <= '0';

--LC_003_06
  lc_4_3(6) <= '0';

--LC_003_07
  lc_4_3(7) <= '0';

--LC_003_08
  lc_4_3(8) <= '0';

  adr0 <= indata;
  adr1(5 downto 4) <= adr0(5 downto 4);
  process(clk) begin
    if(clk'event and clk='1') then
      adr2(5) <= adr1(5);
    end if;
  end process;

--  =================================
  with adr1(4) select
    lut_5_0 <= lc_4_0 when '0',
              lc_4_1 when others;

  with adr1(4) select
    lut_5_1 <= lc_4_2 when '0',
              lc_4_3 when others;

--  =================================
  with adr2(5) select
    lut_6_0 <= lc_5_0 when '0',
              lc_5_1 when others;


--  =================================
  process(clk) begin
    if(clk'event and clk='1') then
      lc_5_0 <= lut_5_0;
      lc_5_1 <= lut_5_1;
    end if;
  end process;
--  =================================
    lc_6_0 <= lut_6_0;
  outdata <= lc_6_0;
end rtl;

library ieee;
use ieee.std_logic_1164.all;

entity pg_log_shift_m1 is
  generic (PG_WIDTH: integer);
  port( x : in std_logic_vector(PG_WIDTH-1 downto 0);
	   y : out std_logic_vector(PG_WIDTH-1 downto 0);
	   clk : in std_logic);
end pg_log_shift_m1;

architecture rtl of pg_log_shift_m1 is

begin

  y <= '0' & x(PG_WIDTH-2) & '0' & x(PG_WIDTH-3 downto 1);

end rtl;


library ieee;
use ieee.std_logic_1164.all;

entity pg_log_mul_17_1 is
  port( x,y : in std_logic_vector(16 downto 0);
          z : out std_logic_vector(16 downto 0);
        clk : in std_logic);
end pg_log_mul_17_1;

architecture rtl of pg_log_mul_17_1 is

  component lpm_add_sub
    generic (LPM_WIDTH: integer;
             LPM_PIPELINE: integer;
             LPM_DIRECTION: string);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          clock: in std_logic;
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

 signal addx,addy,addz: std_logic_vector(14 downto 0);

begin

  process(clk) begin
    if(clk'event and clk='1') then
      z(16) <= x(16) xor y(16);
      z(15) <= x(15) and y(15);
    end if;
  end process;
  addx <= x(14 downto 0);
  addy <= y(14 downto 0);

  u1: lpm_add_sub generic map(LPM_WIDTH=>15,LPM_PIPELINE=>1,LPM_DIRECTION=>"ADD")
       port map(dataa=>addx,datab=>addy,clock=>clk,result=>addz);
  z(14 downto 0) <= addz;

end rtl;

library ieee;
use ieee.std_logic_1164.all;

entity pg_log_div_17_1 is
  port( x,y : in std_logic_vector(16 downto 0);
          z : out std_logic_vector(16 downto 0);
        clk : in std_logic);
end pg_log_div_17_1;

architecture rtl of pg_log_div_17_1 is

  component lpm_add_sub
    generic (LPM_REPRESENTATION: string;
             LPM_WIDTH: integer;
             LPM_PIPELINE: integer;
             LPM_DIRECTION: string);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          clock: in std_logic;
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

 signal addx,addy,addz: std_logic_vector(14 downto 0);

begin

  process(clk) begin
    if(clk'event and clk='1') then
      z(16) <= x(16) xor y(16);
      z(15) <= x(15) and y(15);
    end if;
  end process;
  addx <= x(14 downto 0);
  addy <= y(14 downto 0);

  u1: lpm_add_sub
    generic map(LPM_WIDTH=>15,LPM_PIPELINE=>1,LPM_DIRECTION=>"SUB",LPM_REPRESENTATION=>"UNSIGNED")
    port map(dataa=>addx,datab=>addy,clock=>clk,result=>addz);
  z(14 downto 0) <= addz;

end rtl;

-- pg_fix_accum
-- Pipelined, Virtual Multiple Pipelined Fixed-Point Accumulator for Programmable GRAPE
-- Author: Tsuyoshi Hamada
-- Last Modified at May 9 13:33:33
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity pg_fix_accum_57_64_2 is
  port (fdata: in std_logic_vector(56 downto 0);
        sdata: out std_logic_vector(63 downto 0);
        run : in std_logic;
        clk : in std_logic);
end pg_fix_accum_57_64_2;

architecture rtl of pg_fix_accum_57_64_2 is

  component fix_accum_reg_1
    generic (WIDTH: integer);
    port (indata: in std_logic_vector(WIDTH-1 downto 0);
          cin : in std_logic;
          run : in std_logic;
          addsub : in std_logic;
          addsubd : out std_logic;
          rund : out std_logic;
          cout : out std_logic;
          reg0 : out std_logic_vector(WIDTH-1 downto 0);
          clk : in std_logic);
  end component;

  component fix_accum_reg_last_1
    generic (WIDTH: integer);
    port (indata: in std_logic_vector(WIDTH-1 downto 0);
          cin : in std_logic;
          run : in std_logic;
          addsub : in std_logic;
--        countd : out std_logic_vector(-1 downto 0);
--        addsubd : out std_logic;
--        rund : out std_logic;
--        cout : out std_logic;
          reg0 : out std_logic_vector(WIDTH-1 downto 0);
          clk : in std_logic);
  end component;

  signal fx: std_logic_vector(63 downto 0);
  signal fx_0_0: std_logic_vector(31 downto 0);
  signal fx_1_0: std_logic_vector(31 downto 0);
  signal fx_1_1: std_logic_vector(31 downto 0);
  signal rsig : std_logic_vector(1 downto 0);
  signal addsub : std_logic_vector(1 downto 0);
  signal carry : std_logic_vector(1 downto 0);

begin

  fx <= "00000000" & fdata(55 downto 0);

  fx_0_0 <= fx(31 downto 0);
  fx_1_0 <= fx(63 downto 32);
  addsub(0) <= not fdata(56);
  carry(0) <= fdata(56);
  rsig(0)  <= run;


  process(clk) begin
    if(clk'event and clk='1') then
      fx_1_1 <= fx_1_0;
    end if;
  end process;

  u0: fix_accum_reg_1
    generic map(WIDTH=>32)
    port map(indata=>fx_0_0,
             cin=>carry(0),
             run=>rsig(0),
             addsub=>addsub(0),
             addsubd=>addsub(1),
             rund=>rsig(1),
             cout=>carry(1),
             reg0=>sdata(31 downto 0),
             clk=>clk);

  u1: fix_accum_reg_last_1
    generic map(WIDTH=>32)
    port map(indata=>fx_1_1,
             cin=>carry(1),
             run=>rsig(1),
             addsub=>addsub(1),
--           countd=>count2,
--           addsubd=>addsub(2),
--           rund=>rsig(2),
--           cout=>carry(2),
             reg0=>sdata(63 downto 32),
             clk=>clk);

end rtl;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity fix_accum_reg_1 is
  generic(WIDTH: integer := 28);
  port(indata : in std_logic_vector(WIDTH-1 downto 0);
       cin : in std_logic;
       run : in std_logic;
       addsub : in std_logic;
       addsubd : out std_logic;
       rund : out std_logic;
       cout : out std_logic;
       reg0 : out std_logic_vector(WIDTH-1 downto 0);
       clk : in std_logic);
end fix_accum_reg_1;

architecture rtl of fix_accum_reg_1 is

  component lpm_add_sub
    generic (LPM_WIDTH: integer);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          cin : in std_logic;
          add_sub : in std_logic;
          cout : out std_logic;
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

signal sx : std_logic_vector(WIDTH-1 downto 0);
signal zero : std_logic_vector(WIDTH-1 downto 0);
signal addout : std_logic_vector(WIDTH-1 downto 0);
signal run1 : std_logic;
signal cout0 : std_logic;
signal reg_vmp0 : std_logic_vector(WIDTH-1 downto 0);

begin

  forgen1 : for i in 0 to WIDTH-1 generate
    zero(i) <= '0';
  end generate;

  process(clk) begin
    if(clk'event and clk='1') then
      if(run1 = '1') then
        reg_vmp0 <= addout;
      else
        if(run = '1') then
          reg_vmp0 <= zero;
        end if;
      end if;
    end if;
  end process;
  reg0 <= reg_vmp0;

    sx <= reg_vmp0;

  u1: lpm_add_sub generic map(LPM_WIDTH=>WIDTH)
      port map(dataa=>sx,
               datab=>indata,add_sub=>addsub,
               cin=>cin,
               cout=>cout0,
               result=>addout);

  process(clk) begin
    if(clk'event and clk='1') then
      run1 <= run;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      addsubd <= addsub;
      cout <= cout0;
    end if;
  end process;

  rund <= run1;

end rtl;


library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity fix_accum_reg_last_1 is
  generic(WIDTH: integer := 28);
  port(indata : in std_logic_vector(WIDTH-1 downto 0);
       cin : in std_logic;
       run : in std_logic;
       addsub : in std_logic;
--     countd : out std_logic_vector(-1 downto 0);
--     addsubd : out std_logic;
--     rund : out std_logic;
--     cout : out std_logic;
       reg0 : out std_logic_vector(WIDTH-1 downto 0);
       clk : in std_logic);
end fix_accum_reg_last_1;

architecture rtl of fix_accum_reg_last_1 is

  component lpm_add_sub
    generic (LPM_WIDTH: integer);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          cin : in std_logic;
          add_sub : in std_logic;
--          cout : out std_logic;
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

signal sx : std_logic_vector(WIDTH-1 downto 0);
signal zero : std_logic_vector(WIDTH-1 downto 0);
signal addout : std_logic_vector(WIDTH-1 downto 0);
signal run1 : std_logic;
--signal cout0 : std_logic;
signal reg_vmp0 : std_logic_vector(WIDTH-1 downto 0);

begin

  forgen1 : for i in 0 to WIDTH-1 generate
    zero(i) <= '0';
  end generate;

  process(clk) begin
    if(clk'event and clk='1') then
      if(run1 = '1') then
        reg_vmp0 <= addout;
      else
        if(run = '1') then
          reg_vmp0 <= zero;
        end if;
      end if;
    end if;
  end process;
  reg0 <= reg_vmp0;

    sx <= reg_vmp0;

  u1: lpm_add_sub generic map(LPM_WIDTH=>WIDTH)
      port map(dataa=>sx,
               datab=>indata,add_sub=>addsub,
               cin=>cin,
--               cout=>cout0,
               result=>addout);

  process(clk) begin
    if(clk'event and clk='1') then
      run1 <= run;
    end if;
  end process;

--process(clk) begin
--  if(clk'event and clk='1') then
--    addsubd <= addsub;
--    cout <= cout0;
--    countd <= count;
--  end if;
--end process;

--rund <= run1;

end rtl;


--+-------------------------------+
--| PG_LCELL/PG_LCELL_ARI         |
--| Multidevice Logic Cell Module |.GKey:hYj8zgUkjgdkfhB3ozXM
--| 2003/10/31                    |
--|            by Tsuyoshi Hamada |
--+-------------------------------+
--+-------------+----------+
--| x3,x2,x1,x0 |    z     |
--+-------------+----------+
--|  0, 0, 0, 0 | MASK(0)  |
--|  0, 0, 0, 1 | MASK(1)  |
--|  0, 0, 1, 0 | MASK(2)  |
--|  0, 0, 1, 1 | MASK(3)  |
--|  0, 1, 0, 0 | MASK(4)  |
--|  0, 1, 0, 1 | MASK(5)  |
--|  .......... | .......  |
--|  1, 1, 1, 1 | MASK(16) |
--+-------------+----------+
library ieee;
use ieee.std_logic_1164.all;
library wysiwyg;
use wysiwyg.stratix_components.all;

entity pg_lcell is
  generic(MASK: string  := "ffff";
            FF: integer := 0);
    port(x : in std_logic_vector(3 downto 0);
         z : out std_logic;
         clk : in std_logic);
end pg_lcell;

architecture rtl of pg_lcell is

component stratix_lcell
  generic
  (
    operation_mode : string := "normal";
    synch_mode     : string := "off";
    register_cascade_mode : string := "off";
    sum_lutc_input : string := "datac";
    lut_mask       : string := "0000";
    power_up       : string := "low";
    cin0_used      : string := "false";
    cin1_used      : string := "false";
    cin_used       : string := "false";
    output_mode    : string := "comb_and_reg"
  );
  port (clk: in std_logic := '0';
    dataa  : in std_logic := '1';
    datab  : in std_logic := '1';
    datac  : in std_logic := '1';
    datad  : in std_logic := '1';
--  aclr   : in std_logic := '0';
--  aload  : in std_logic := '0';
--  sclr   : in std_logic := '0';
--  sload  : in std_logic := '0';
    ena    : in std_logic := '1';
--  cin    : in std_logic := '0';
--  cin0   : in std_logic := '0';
--  cin1   : in std_logic := '1';
--  inverta   : in std_logic := '0';
--  regcascin : in std_logic := '0';
    combout   : out std_logic;
    regout    : out std_logic);
--  cout   : out std_logic;
--  cout0  : out std_logic;
--  cout1  : out std_logic);
end component;
begin
ifgen0: if (FF=0) generate
  u0: stratix_lcell generic map(lut_mask=>MASK)
      port map(dataa=>x(0),datab=>x(1),datac=>x(2),datad=>x(3),
               clk=>clk,combout=>z);
end generate;
ifgen1: if (FF>0) generate
  u0: stratix_lcell generic map(lut_mask=>MASK)
      port map(dataa=>x(0),datab=>x(1),datac=>x(2),datad=>x(3),
               clk=>clk,regout=>z);
end generate;
end rtl;

--+--------+----------------------+
--| ci,y,x | z       , co         |
--+--------+----------------------+
--|  0,0,0 | MASK(8) , MASK(0)    |
--|  0,0,1 | MASK(9) , MASK(1)    |
--|  0,1,0 | MASK(10), MASK(2)    |
--|  0,1,1 | MASK(11), MASK(3)    |
--|  1,0,0 | MASK(12), MASK(4)    |
--|  1,0,1 | MASK(13), MASK(5)    |
--|  1,1,0 | MASK(14), MASK(6)    |
--|  1,1,1 | MASK(15), MASK(7)    |
--+--------+----------------------+
library ieee;
use ieee.std_logic_1164.all;
library wysiwyg;
use wysiwyg.stratix_components.all;

entity pg_lcell_ari is
  generic(MASK: string  := "96E8";
            FF: integer := 0);
    port(x,y,ci : in std_logic;
         z,co : out std_logic;
         clk : in std_logic);
end pg_lcell_ari;

architecture rtl of pg_lcell_ari is

component stratix_lcell
   generic
  (
   operation_mode    : string := "arithmetic";
   synch_mode : string := "off";
   register_cascade_mode   : string := "off";
-- sum_lutc_input : string := "datac";
   lut_mask       : string := "96E8";
   power_up       : string := "low";
   cin0_used      : string := "false";
   cin1_used      : string := "false";
   cin_used       : string := "true";
   output_mode    : string := "comb_and_reg"
  );
 port (clk : in std_logic := '0';
   dataa   : in std_logic := '1';
   datab   : in std_logic := '1';
-- datac   : in std_logic := '1';
-- datad   : in std_logic := '1';
-- aclr    : in std_logic := '0';
-- aload   : in std_logic := '0';
-- sclr    : in std_logic := '0';
-- sload   : in std_logic := '0';
   ena     : in std_logic := '1';
   cin     : in std_logic := '0';
-- cin0    : in std_logic := '0';
-- cin1    : in std_logic := '1';
-- inverta : in std_logic := '0';
-- regcascin : in std_logic := '0';
   combout   : out std_logic;
   regout    : out std_logic;
   cout   : out std_logic);
-- cout0  : out std_logic;
-- cout1  : out std_logic);
end component;
begin

ifgen0: if (FF=0) generate
  u0: stratix_lcell generic map(lut_mask=>MASK)
      port map(dataa=>x,datab=>y,cin=>ci,combout=>z,cout=>co,clk=>clk);
end generate;
ifgen1: if (FF>0) generate
  u0: stratix_lcell generic map(lut_mask=>MASK)
      port map(dataa=>x,datab=>y,cin=>ci,regout=>z,cout=>co,clk=>clk);
end generate;

end rtl;




-- manually edited by Atsushi Kawai -------------------------------------------

--
-- format converter
-- (fixed point to floating point)
--
-- pipeline delay: 3
--

library ieee;
use ieee.std_logic_arith.all;
use ieee.std_logic_1164.all;

entity my_conv_fixtofp_32_17_9 is
  port (fixdata: in std_logic_vector(31 downto 0);
        fpdata:  out std_logic_vector(16 downto 0);
        clk: in std_logic);
end my_conv_fixtofp_32_17_9;

architecture rtl of my_conv_fixtofp_32_17_9 is

  component penc_31_5
    port( a : in std_logic_vector(30 downto 0);
          c : out std_logic_vector(4 downto 0));
  end component;

  component lpm_clshift
    generic (LPM_WIDTH : POSITIVE;
             LPM_WIDTHDIST : POSITIVE);
    port(data : in std_logic_vector(LPM_WIDTH-1 downto 0);
         distance : in std_logic_vector(LPM_WIDTHDIST-1 downto 0);
         direction : in std_logic;
         result : out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  component lpm_add_sub
    generic (LPM_WIDTH: integer;
             LPM_DIRECTION: string);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  signal fminus0, fminus0a, fplus0, f0, f1: std_logic_vector(30 downto 0);
  signal f2: std_logic_vector(30 downto 0);
  signal s0,s0a,s1,s2: std_logic;
  signal s0b: std_logic_vector(1 downto 0);
  signal e1, e2: std_logic_vector(4 downto 0);
  signal n1, n2: std_logic_vector(4 downto 0);
  signal m1: std_logic_vector(30 downto 0);
  signal m2: std_logic_vector(30 downto 0);

begin  -- rtl

  -- stage 0
  s0 <= fixdata(31);
  fplus0 <= fixdata(30 downto 0);
  fminus0 <=  NOT fixdata(30 downto 0);
  u1: lpm_add_sub
    generic map (LPM_WIDTH=>31,LPM_DIRECTION=>"ADD")
    port map(result=>fminus0a,
             dataa=>fminus0,
             datab=>conv_std_logic_vector(0, 30) & '1');
  s0a <= '0' when fixdata(30 downto 0) = conv_std_logic_vector(0,31) else '1';
  s0b <= s0a & s0;
   
  with s0b select
    f0 <=
    fminus0a when "11",                 -- negative number
    fminus0 when "01",                  -- NaN should be treated as "1111...11"
    fplus0 when others;                 -- positive number

  process(clk)
  begin
    if(clk'event and clk='1') then
      f1 <= f0;
      s1 <= s0;
    end if;
  end process;

  -- stage 1
  -- f1: |fixdata|
  -- s1: sign of fixdata
  u2: penc_31_5 port map (a=>f1, c=>e1);

  process(clk)
  begin
    if(clk'event and clk='1') then
      f2 <= f1(30 downto 0);
      s2 <= s1;
      e2 <= e1;
    end if;
  end process;
  
  -- stage 2
  -- m4: MSB omitted |fixdata|
  -- e2: exponent of fpdata
  -- s2: sign of fixdata

  u3: lpm_add_sub
    generic map (LPM_WIDTH=>5,LPM_DIRECTION=>"SUB")
    port map(result=>n2,
             dataa=>"11111",
             datab=>e2);

  u4: lpm_clshift
    generic map (LPM_WIDTH=>31,
                 LPM_WIDTHDIST=>5)
    port map (data=>f2,
              distance=>n2,
              result=>m2,
              direction=>'0');

  -- m2(30 downto 22): mantissa of fpdata

  process(clk)                          -- force-1 rounding
  begin
    if(clk'event and clk='1') then
      fpdata(8 downto 1) <= m2(30 downto 23);
      if (m2(22 downto 0) = conv_std_logic_vector(0, 23)) then
        fpdata(0) <= '0';
      else
        fpdata(0) <= '1';
      end if;
    end if;
  end process;

  fpdata(15 downto 14) <= "00";

  process(clk)
  begin
    if(clk'event and clk='1') then
      fpdata(16) <= s2;
      fpdata(13 downto 9) <= e2;
    end if;
  end process;

  -- stage 3
  -- fpdata: number converted to floating-point format

end rtl;

--
-- format converter
-- (floating point to fixed point)
--
-- pipeline delay: 2
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity my_conv_fptofix_17_9_57 is
  port (
        fpdata:  in std_logic_vector(16 downto 0);
        fixdata: out std_logic_vector(56 downto 0);
        clk: in std_logic);
end my_conv_fptofix_17_9_57;

architecture rtl of my_conv_fptofix_17_9_57 is

  component lpm_add_sub
    generic (LPM_WIDTH: integer;
             LPM_DIRECTION: string);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  component reged_shift_fptofix_10_7_56
    port( indata : in std_logic_vector(9 downto 0);
          control : in std_logic_vector(6 downto 0);
          clk : in std_logic;
          outdata : out std_logic_vector(55 downto 0));
  end component;

  signal sign: std_logic_vector(1 downto 0);
  signal nz0: std_logic;
  signal e0, e0a, e1: std_logic_vector(6 downto 0);
  signal m0: std_logic_vector(8 downto 0);
  signal m1: std_logic_vector(9 downto 0);
  signal m1a: std_logic_vector(55 downto 0);

begin

  sign(0) <= fpdata(16);                -- sign
  e0 <= fpdata(15 downto 9);            -- exponent
  m0 <= fpdata(8 downto 0);             -- mantissa


  with fpdata(15 downto 0) select
    nz0 <=
    '0' when  conv_std_logic_vector(0, 16),
    '1' when  others;

  process(clk) begin
    if(clk'event and clk='1') then
      sign(1) <= sign(0);
    end if;
  end process;

  -- remove 23-bit mass-offset added by the host computer
  u1: lpm_add_sub generic map (LPM_WIDTH=>7,LPM_DIRECTION=>"SUB")
                  port map(result=>e0a,dataa=>e0,datab=>conv_std_logic_vector(23,7));
  
  process(clk)
  begin
    if(clk'event and clk='1') then
      e1 <= e0a;
      m1 <= nz0 & m0;                   -- add hidden MSB
    end if;
  end process;

  u2: reged_shift_fptofix_10_7_56
      port map (indata=>m1,control=>e1,outdata=>m1a,clk=>clk);

  process(clk) begin
    if(clk'event and clk='1') then
      fixdata(56) <= sign(1);
      fixdata(55 downto 0) <= m1a;
    end if;
  end process;

end rtl;

library ieee;
use ieee.std_logic_arith.all;
use ieee.std_logic_1164.all;

entity reged_shift_fptofix_10_7_56 is
  port( indata : in std_logic_vector(9 downto 0);
        control : in std_logic_vector(6 downto 0);
        clk : in std_logic;
        outdata : out std_logic_vector(55 downto 0));
end reged_shift_fptofix_10_7_56;

architecture rtl of reged_shift_fptofix_10_7_56 is

  signal c0 : std_logic_vector(6 downto 0);
  signal c1 : std_logic_vector(6 downto 0);
  signal c2 : std_logic_vector(6 downto 0);
  signal c3 : std_logic_vector(6 downto 0);
  signal c4 : std_logic_vector(6 downto 0);
  signal c5 : std_logic_vector(6 downto 0);
  signal o0,o0d : std_logic_vector(9 downto 0);
  signal o1,o1d : std_logic_vector(10 downto 0);
  signal o2,o2d : std_logic_vector(12 downto 0);
  signal o3,o3d : std_logic_vector(16 downto 0);
  signal o4,o4d : std_logic_vector(24 downto 0);
  signal o5,o5d : std_logic_vector(40 downto 0);
  signal o6,o6d : std_logic_vector(72 downto 0);

begin

  c0 <= control;

  o0d <= indata;
  with c0(0) select
    o1 <= o0d & '0' when '1',
          '0' & o0d when others;

  with c1(1) select
    o2 <= o1d & "00" when '1',
          "00" & o1d when others;

  with c2(2) select
    o3 <= o2d & "0000" when '1',
          "0000" & o2d when others;

  with c3(3) select
    o4 <= o3d & "00000000" when '1',
          "00000000" & o3d when others;

  with c4(4) select
    o5 <= o4d & "0000000000000000" when '1',
          "0000000000000000" & o4d when others;

  with c5(5) select
    o6 <= o5d & "00000000000000000000000000000000" when '1',
          "00000000000000000000000000000000" & o5d when others;

  with c5(6) select
    outdata <= o6(64 downto 9) when '0',
    conv_std_logic_vector(0, 56) when others;

  
  o1d <= o1;
  c1 <= c0;

  o2d <= o2;
  c2 <= c1;

  o3d <= o3;
  c3 <= c2;

  o4d <= o4;
  c4 <= c3;

  o5d <= o5;
  c5 <= c4;

end rtl;


--
-- format converter
-- (floating point to logarithmic)
--
-- pipeline delay: 1
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity my_conv_fptol_17_9_17_8 is
  port (fpdata:  in std_logic_vector(16 downto 0);
        logdata: out std_logic_vector(16 downto 0);
        clk: in std_logic);
end my_conv_fptol_17_9_17_8;

architecture rtl of my_conv_fptol_17_9_17_8 is

  component table
    generic (IN_WIDTH: integer ;
             OUT_WIDTH: integer ;
             TABLE_FILE: string);
    port (indata : in std_logic_vector(IN_WIDTH-1 downto 0);
         outdata : out std_logic_vector(OUT_WIDTH-1 downto 0);
         clk : in std_logic);
  end component;

  component lpm_add_sub
    generic (LPM_WIDTH: integer;
             LPM_DIRECTION: string);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  signal sign0, sign1, sign2: std_logic;
  signal nz1, nz2: std_logic;
  signal c0, c1: std_logic;
  signal e0, e1, e1a, e2: std_logic_vector(6 downto 0);
  signal m0: std_logic_vector(8 downto 0);
  signal m1: std_logic_vector(7 downto 0);
  signal add: std_logic_vector(7 downto 0);

begin

  sign0 <= fpdata(16);
  e0 <= fpdata(15 downto 9);            -- exponent
  m0 <= fpdata(8 downto 0);       -- mantissa

  process(clk)                          -- non zero
  begin
    if(clk'event and clk='1') then
      if (fpdata(15 downto 0) = conv_std_logic_vector(0, 16)) then
        nz1 <= '0';
      else
        nz1 <= '1';
      end if;
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      if (m0 = "111111111") then
        c1 <= '1';
      else
        c1 <= '0';
      end if;
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      sign1 <= sign0;
      e1 <= e0;
    end if;
  end process;

  u1: table generic map(IN_WIDTH=>9,OUT_WIDTH=>8,TABLE_FILE=>"f9tl8.mif")
    port map (indata=>m0,outdata=>m1,clk=>clk);

  u2: lpm_add_sub generic map (LPM_WIDTH=>7,LPM_DIRECTION=>"ADD")
                  port map(result=>e1a,dataa=>e1,datab=>conv_std_logic_vector(0,6) & c1);
  
  logdata(16) <= sign1;
  logdata(15) <= nz1;
  logdata(14 downto 8) <= e1a;
  logdata(7 downto 0) <= m1;

end rtl;

--
-- format converter
-- (logarithmic to floating point)
--
-- pipeline delay: 2
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity my_conv_ltofp_17_8_17_9 is
  port (logdata: in std_logic_vector(16 downto 0);
        fpdata:  out std_logic_vector(16 downto 0);
        clk: in std_logic);
end my_conv_ltofp_17_8_17_9;

architecture rtl of my_conv_ltofp_17_8_17_9 is

  component reged_table
    generic (IN_WIDTH: integer ;
             OUT_WIDTH: integer ;
             TABLE_FILE: string);
    port (indata : in std_logic_vector(IN_WIDTH-1 downto 0);
         outdata : out std_logic_vector(OUT_WIDTH-1 downto 0);
         clk : in std_logic);
  end component;

  signal sign0, sign1, sign2: std_logic;
  signal nz0, nz1, nz2: std_logic;
  signal e0, e1, e2: std_logic_vector(6 downto 0);
  signal m0, m2: std_logic_vector(7 downto 0);
  signal fpdata2: std_logic_vector(16 downto 0);

begin
  -- stage 0
  sign0 <= logdata(16);                 -- sign
  nz0 <= logdata(15);                   -- non zero
  e0 <= logdata(14 downto 8);           -- exponent
  m0 <= logdata(7 downto 0);            -- mantissa

  -- stage 1
  process(clk)
  begin
    if(clk'event and clk='1') then
      sign1 <= sign0;
      sign2 <= sign1;
      nz1 <= nz0;
      nz2 <= nz1;
      e1 <= e0;
      e2 <= e1;
    end if;
  end process;

  u1: reged_table generic map(IN_WIDTH=>8,OUT_WIDTH=>8,TABLE_FILE=>"l8tf8.mif")
    port map (indata=>m0,outdata=>m2,clk=>clk);

  fpdata2(16) <= sign2;
  fpdata2(15 downto 9) <= e2;
  fpdata2(8 downto 0) <= m2 & "0";

  with nz2 select
    fpdata <=
    fpdata2                      when '1',
    conv_std_logic_vector(0, 17) when others;

end rtl;

--
-- my_fp_sqr_17_9
--
-- 17-bit floating-point square calculator
--
-- 1     7            9
-- sign  exponent     mantissa
--       (no offset)
--
-- pipeline delay: 2
--
-- this implementation assumes use of embedded multiplier,
-- and thus is specific to CycloneII, Stratix, or StratixII.
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity my_fp_sqr_17_9 is
  port
    (
        clk		: in std_logic;
        x		: in std_logic_vector(16 downto 0);
        z		: out std_logic_vector(16 downto 0)
      );
end my_fp_sqr_17_9;

architecture syn of my_fp_sqr_17_9 is
  component pg_ufix_mult_9
    port
      (
        clock		: in std_logic ;
        dataa		: in std_logic_vector (8 downto 0);
        datab		: in std_logic_vector (8 downto 0);
        result		: out std_logic_vector (17 downto 0)
	);
  end component;

  component lpm_add_sub
    generic (LPM_WIDTH: integer;
             LPM_DIRECTION: string);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          cout: out std_logic;
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  signal sx0, sy0 : std_logic;
  signal ex0, ey0 : std_logic_vector(6 downto 0);
  signal mx0, my0 : std_logic_vector(8 downto 0);

  signal s1, s2: std_logic;
  signal nz1, nz2, nz3 : std_logic;
  signal e0, e1, e2, ea2: std_logic_vector(6 downto 0);
  signal mm1 : std_logic_vector(17 downto 0);
  signal mma1 : std_logic_vector(9 downto 0);
  signal mp0, mp1 : std_logic_vector(9 downto 0);
  signal m1, m1a : std_logic_vector(10 downto 0);
  signal c2 : std_logic;
  signal ma2: std_logic_vector(8 downto 0);
  
begin

  sx0 <= x(16);                            -- sign
  ex0 <= x(15 downto 9);                   -- exponent
  mx0 <= x(8 downto 0);                    -- mantissa
  
  sy0 <= x(16);                            -- sign
  ey0 <= x(15 downto 9);                   -- exponent
  my0 <= x(8 downto 0);                    -- mantissa

  process(clk)
  begin
    if(clk'event and clk='1') then
      s1 <= sx0 xor sy0;
      s2 <= s1;
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      if (x(15 downto 0) = conv_std_logic_vector(0, 16)) then
        nz1 <= '0';
      else
        nz1 <= '1';
      end if;
    end if;
  end process;

  u0: lpm_add_sub                       -- e0 <= ex0 + ey0
    generic map (LPM_WIDTH=>7,
                 LPM_DIRECTION=>"ADD")
    port map(result => e0,
             dataa  => ex0,
             datab  => ey0);
  process(clk)
  begin
    if(clk'event and clk='1') then
      e1 <= e0;
      e2 <= e1;
    end if;
  end process;

  u1: pg_ufix_mult_9                    -- mm1 <= mx0 * my0
    port map (
      clock => clk,
      result => mm1,
      dataa => mx0,
      datab => my0);

  with mm1(9 downto 0) select           -- force-1 round mm1 to obtain mma1
    mma1(0) <=
    '0' when conv_std_logic_vector(0, 10),
    '1' when others;
  mma1(8 downto 1) <= mm1(17 downto 10);
  mma1(9) <= '0';
  
  u2: lpm_add_sub                       -- mp0 <= mx0 + my0
    generic map (LPM_WIDTH=>9,
                 LPM_DIRECTION=>"ADD")
    port map(result => mp0(8 downto 0),
             cout => mp0(9),
             dataa  => mx0,
             datab  => my0);
  process(clk)
  begin
    if(clk'event and clk='1') then
      mp1 <= mp0;
    end if;
  end process;

  u3: lpm_add_sub                       -- m2 <= mma1 + mp1
    generic map (LPM_WIDTH=>10,
                 LPM_DIRECTION=>"ADD")
    port map(result => m1(9 downto 0),
             cout => m1(10),
             dataa  => mma1,
             datab  => mp1);


  u4: lpm_add_sub                       -- add hidden 1.0 to m2
    generic map (LPM_WIDTH=>11,
                 LPM_DIRECTION=>"ADD")
    port map(result => m1a,
             dataa  => m1,
             datab  => "01000000000");

  process(clk)
  begin
    if(clk'event and clk='1') then
      if (m1a(10) = '1') then
        ma2(8 downto 1) <= m1a(9 downto 2);
        if (m1a(1 downto 0) = conv_std_logic_vector(0, 2)) then  -- force-1 rounding
          ma2(0) <= '0';
        else
          ma2(0) <= '1';
        end if;
      else
        ma2(8 downto 0) <= m1a(8 downto 0);
      end if;
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      c2 <= m1a(10);
    end if;
  end process;

  u5: lpm_add_sub                       -- exponent would be increased by 1
    generic map (LPM_WIDTH=>7,
                 LPM_DIRECTION=>"ADD")
    port map(result => ea2,
             dataa  => e2,
             datab  => conv_std_logic_vector(0, 6) & c2);


  process(clk)
  begin
    if(clk'event and clk='1') then
      nz2 <= nz1;
    end if;
  end process;

  with nz2 select
    z(16) <=
    s2 when '1',
    '0' when others;

  with nz2 select
    z(15 downto 9) <=
    ea2 when '1',
    conv_std_logic_vector(0, 7) when others;

  with nz2 select
    z(8 downto 0) <=
    ma2 when '1',
    conv_std_logic_vector(0, 9) when others;

end syn;

--
-- my_fp_mult_17_9
--
-- 17-bit floating-point multiplier
--
-- 1     7            9
-- sign  exponent     mantissa
--       (no offset)
--
-- pipeline delay: 3
--
-- this implementation assumes use of embedded multiplier,
-- and thus is specific to CycloneII, Stratix, or StratixII.
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity my_fp_mult_17_9 is
  port
    (
        clk		: in std_logic;
        x		: in std_logic_vector(16 downto 0);
        y		: in std_logic_vector(16 downto 0);
        z		: out std_logic_vector(16 downto 0)
      );
end my_fp_mult_17_9;

architecture syn of my_fp_mult_17_9 is
  component pg_ufix_mult_9
    port
      (
        clock		: in std_logic ;
        dataa		: in std_logic_vector (8 downto 0);
        datab		: in std_logic_vector (8 downto 0);
        result		: out std_logic_vector (17 downto 0)
	);
  end component;

  component lpm_add_sub
    generic (LPM_WIDTH: integer;
             LPM_DIRECTION: string);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          cout: out std_logic;
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  signal sx0, sy0 : std_logic;
  signal ex0, ey0 : std_logic_vector(6 downto 0);
  signal mx0, my0 : std_logic_vector(8 downto 0);

  signal s1, s2: std_logic;
  signal nz1, nz2, nz3 : std_logic;
  signal e0, e1, e2, ea2: std_logic_vector(6 downto 0);
  signal mm1 : std_logic_vector(17 downto 0);
  signal mma1 : std_logic_vector(9 downto 0);
  signal mp0, mp1 : std_logic_vector(9 downto 0);
  signal m1, m1a : std_logic_vector(10 downto 0);
  signal c2 : std_logic;
  signal ma2: std_logic_vector(8 downto 0);
  
begin

  sx0 <= x(16);                            -- sign
  ex0 <= x(15 downto 9);                   -- exponent
  mx0 <= x(8 downto 0);                    -- mantissa
  
  sy0 <= y(16);                            -- sign
  ey0 <= y(15 downto 9);                   -- exponent
  my0 <= y(8 downto 0);                    -- mantissa

  process(clk)
  begin
    if(clk'event and clk='1') then
      s1 <= sx0 xor sy0;
      s2 <= s1;
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      if (x(15 downto 0) = conv_std_logic_vector(0, 16) or
          y(15 downto 0) = conv_std_logic_vector(0, 16)) then
        nz1 <= '0';
      else
        nz1 <= '1';
      end if;
    end if;
  end process;

  u0: lpm_add_sub                       -- e0 <= ex0 + ey0
    generic map (LPM_WIDTH=>7,
                 LPM_DIRECTION=>"ADD")
    port map(result => e0,
             dataa  => ex0,
             datab  => ey0);
  process(clk)
  begin
    if(clk'event and clk='1') then
      e1 <= e0;
      e2 <= e1;
    end if;
  end process;

  u1: pg_ufix_mult_9                    -- mm1 <= mx0 * my0
    port map (
      clock => clk,
      result => mm1,
      dataa => mx0,
      datab => my0);

  with mm1(9 downto 0) select           -- force-1 round mm1 to obtain mma1
    mma1(0) <=
    '0' when conv_std_logic_vector(0, 10),
    '1' when others;
  mma1(8 downto 1) <= mm1(17 downto 10);
  mma1(9) <= '0';
  
  u2: lpm_add_sub                       -- mp0 <= mx0 + my0
    generic map (LPM_WIDTH=>9,
                 LPM_DIRECTION=>"ADD")
    port map(result => mp0(8 downto 0),
             cout => mp0(9),
             dataa  => mx0,
             datab  => my0);
  process(clk)
  begin
    if(clk'event and clk='1') then
      mp1 <= mp0;
    end if;
  end process;

  u3: lpm_add_sub                       -- m2 <= mma1 + mp1
    generic map (LPM_WIDTH=>10,
                 LPM_DIRECTION=>"ADD")
    port map(result => m1(9 downto 0),
             cout => m1(10),
             dataa  => mma1,
             datab  => mp1);


  u4: lpm_add_sub                       -- add hidden 1.0 to m2
    generic map (LPM_WIDTH=>11,
                 LPM_DIRECTION=>"ADD")
    port map(result => m1a,
             dataa  => m1,
             datab  => "01000000000");

  process(clk)
  begin
    if(clk'event and clk='1') then
      if (m1a(10) = '1') then
        ma2(8 downto 1) <= m1a(9 downto 2);
        if (m1a(1 downto 0) = conv_std_logic_vector(0, 2)) then  -- force-1 rounding
          ma2(0) <= '0';
        else
          ma2(0) <= '1';
        end if;
      else
        ma2(8 downto 0) <= m1a(8 downto 0);
      end if;
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      c2 <= m1a(10);
    end if;
  end process;

  u5: lpm_add_sub                       -- exponent would be increased by 1
    generic map (LPM_WIDTH=>7,
                 LPM_DIRECTION=>"ADD")
    port map(result => ea2,
             dataa  => e2,
             datab  => conv_std_logic_vector(0, 6) & c2);


  process(clk)
  begin
    if(clk'event and clk='1') then
      nz2 <= nz1;
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      if (nz2 = '1') then
        z(16) <= s2;
        z(15 downto 9) <= ea2;
        z(8 downto 0) <= ma2;
      else
        z <= conv_std_logic_vector(0, 17);
      end if;
    end if;
  end process;

end syn;

--
-- my_fp_add_17_9
--
-- 17-bit floating-point adder
--
-- 1     7            9
-- sign  exponent     mantissa
--       (no offset)
--
-- pipeline delay: 4
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity my_fp_add_17_9 is
  port
    (
        clk		: in std_logic;
        x		: in std_logic_vector(16 downto 0);
        y		: in std_logic_vector(16 downto 0);
        z		: out std_logic_vector(16 downto 0)
      );
end my_fp_add_17_9;

architecture syn of my_fp_add_17_9 is

  component lpm_compare
    generic (LPM_WIDTH: integer;
             LPM_REPRESENTATION: string := "UNSIGNED");
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          alb,ageb: out std_logic);
  end component;

  component lpm_add_sub
    generic (LPM_WIDTH: integer;
             LPM_DIRECTION: string;
             LPM_REPRESENTATION: string := "UNSIGNED");
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          cout: out std_logic;
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  component lpm_clshift
    generic (LPM_WIDTH : POSITIVE;
             LPM_WIDTHDIST : POSITIVE);
    port(data : in std_logic_vector(LPM_WIDTH-1 downto 0);
         distance : in std_logic_vector(LPM_WIDTHDIST-1 downto 0);
         direction : in std_logic;
         result : out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  signal s : std_logic_vector(5 downto 0);

  signal ex0, ey0 : std_logic_vector(6 downto 0);
  signal mx0, my0 : std_logic_vector(8 downto 0);
  signal nzx0, nzx1, nzy0, nzy1 : std_logic;
  signal exley0 : std_logic;
  signal exy0, eyx0 : std_logic_vector(6 downto 0);
  signal de0, de1 : std_logic_vector(6 downto 0);
  signal e0, e1, ea1, e2, e3, ea3, e4 : std_logic_vector(6 downto 0);
  signal mx1, my1 : std_logic_vector(8 downto 0);
  signal dege20 : std_logic;
  signal dea1 : std_logic_vector(6 downto 0);
  signal de2 : std_logic_vector(4 downto 0);
  signal mya1, my2, mya2 : std_logic_vector(19 downto 0);
  signal myb2, my3, mx2, mx3, m3 : std_logic_vector(10 downto 0);
  signal ma3, m4 : std_logic_vector(8 downto 0);
  
begin


  ex0 <= x(15 downto 9);                   -- exponent
  mx0 <= x(8 downto 0);                    -- mantissa
  with x(15 downto 0) select               -- non zero
    nzx0 <=
    '0' when conv_std_logic_vector(0, 16),
    '1' when others;
  
  ey0 <= y(15 downto 9);                   -- exponent
  my0 <= y(8 downto 0);                    -- mantissa
  with y(15 downto 0) select               -- non zero
    nzy0 <=
    '0' when conv_std_logic_vector(0, 16),
    '1' when others;

  u0: lpm_compare                       -- ex < ey ? 1 : 0
    generic map (LPM_WIDTH=>7)
    port map(alb => exley0,
             dataa  => ex0,
             datab  => ey0);
  u1: lpm_add_sub
    generic map (
                 LPM_WIDTH=>7,
                 LPM_DIRECTION=>"SUB")
    port map(result => exy0,
             dataa  => ex0,
             datab  => ey0);
  u2: lpm_add_sub
    generic map (LPM_WIDTH=>7,
                 LPM_DIRECTION=>"SUB")
    port map(result => eyx0,
             dataa  => ey0,
             datab  => ex0);
  with exley0 select                    -- de0 <= |ex0 - ey0|
    de0 <=
    eyx0 when '1',
    exy0 when others;

  process(clk)
  begin
    if(clk'event and clk='1') then
      de1 <= de0;
    end if;
  end process;

  with exley0 select                    -- e0 <= larger(ex0, ey0)
    e0 <=
    ey0 when '1',
    ex0 when others;

  process(clk)
  begin
    if(clk'event and clk='1') then
      e1 <= e0;
      e2 <= e1;
      e3 <= e2;
    end if;
  end process;

  process(clk)                          -- now x >= y is guaranteed
  begin
    if(clk'event and clk='1') then
      if (exley0 = '1') then
        mx1 <= my0;
        my1 <= mx0;
      else
        mx1 <= mx0;
        my1 <= my0;
      end if;
    end if;
  end process;

  process(clk)
  begin
    if(clk'event and clk='1') then
      if (exley0 = '1') then
        nzx1 <= nzy0;
        nzy1 <= nzx0;
      else
        nzx1 <= nzx0;
        nzy1 <= nzy0;
      end if;
    end if;
  end process;
  
  u3: lpm_compare                       -- de1 > 20 ? 1 : 0
    generic map (LPM_WIDTH=>7)
    port map(ageb => dege20,
             dataa  => de1,
             datab  => "0010100");
  with dege20 select                     -- now 0 <= dea1 <= 20
    dea1 <=
    "0010100" when '1',
    de1       when others;
  process(clk)
  begin
    if(clk'event and clk='1') then
      de2 <= dea1(4 downto 0);
    end if;
  end process;

  mya1 <= nzy1 & my1 & conv_std_logic_vector(0, 10);
  process(clk)
  begin
    if(clk'event and clk='1') then
      my2 <= mya1;
    end if;
  end process;
  u4: lpm_clshift generic map (LPM_WIDTH=>20,LPM_WIDTHDIST=>5)
         port map (data => my2,
                   distance => de2,
                   result => mya2,
                   direction => '1');
  myb2(10) <= '0';
  myb2(9 downto 1) <= mya2(19 downto 11);
  with mya2(10 downto 0) select         -- force-1 rounding
    myb2(0) <=
    '0' when conv_std_logic_vector(0, 11),
    '1' when others;

  process(clk)
  begin
    if(clk'event and clk='1') then
      my3 <= myb2;
    end if;
  end process;
  process(clk)
  begin
    if(clk'event and clk='1') then
      mx2 <= '0' & nzx1 & mx1;
      mx3 <= mx2;
    end if;
  end process;
  u5: lpm_add_sub
    generic map (LPM_WIDTH=>11,
                 LPM_DIRECTION=>"ADD")
    port map(result => m3,
             dataa  => mx3,
             datab  => my3);
  
  u6: lpm_add_sub                     -- exponent would be increased by 1
    generic map (LPM_WIDTH=>7,
                 LPM_DIRECTION=>"ADD")
    port map(result => ea3,
             dataa  => e3,
             datab  => conv_std_logic_vector(0, 6) & m3(10));

  with m3(10) select
    ma3 <=
    m3(9 downto 1) when '1',
    m3(8 downto 0) when others;

  process(clk)
  begin
    if(clk'event and clk='1') then
      if (m3(10) = '1') then
        m4(8 downto 1) <= m3(9 downto 2);
        if (m3(1 downto 0) = conv_std_logic_vector(0, 2)) then  -- force-1 rounding
          m4(0) <= '0';
        else
          m4(0) <= '1';
        end if;
      else
        m4(8 downto 0) <= m3(8 downto 0);
      end if ;
    end if;
  end process;
  
  process(clk)
  begin
    if(clk'event and clk='1') then
      e4 <= ea3;
    end if;
  end process;
  
  z(16) <= '0';
  z(15 downto 9) <= e4;
  z(8 downto 0) <= m4;
  
end syn;

--
-- my_fp_multw_17_9
--
-- 17-bit floating-point multiplier
--
-- 1     7            9
-- sign  exponent     mantissa
--       (no offset)
--
-- pipeline delay: 7
--
-- this implementation uses altfp_mult
-- (32-bit floating-point multiplier megafunction),
-- disabling unnecessary part (14 bits out of 23) of mantissa.
--
-- this is not efficient at all and not intended for practical use.
-- should be used just for debugging purpose.
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity my_fp_multw_17_9 is
  port
    (clk		: in std_logic;
        x		: in std_logic_vector(16 downto 0);
        y		: in std_logic_vector(16 downto 0);
        z		: out std_logic_vector(16 downto 0)
      );
end my_fp_multw_17_9;

architecture syn of my_fp_multw_17_9 is

  component my_fp_mult_32_1
    port
      (
        clock		: in std_logic;
        dataa		: in std_logic_vector (31 downto 0);
        datab		: in std_logic_vector (31 downto 0);
        nan		: out std_logic;
        overflow	: out std_logic;
        result		: out std_logic_vector (31 downto 0);
        underflow	: out std_logic 
	);
  end component;

  component lpm_add_sub                                            
    generic (LPM_WIDTH: integer;                                   
             LPM_DIRECTION: string);                               
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);  
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));     
  end component;                                                   
  

  signal ina, ina0 : std_logic_vector(31 downto 0);
  signal inb, inb0 : std_logic_vector(31 downto 0);
  signal outa : std_logic_vector(31 downto 0);
  signal ab : std_logic_vector(31 downto 0);
  signal ea, eb, eab : std_logic_vector(7 downto 0);
  signal nza, nzb, nzab : std_logic;
  
begin

  -- stage 0
  ina0(31) <= x(16);                                  -- sign
  ina0(30 downto 23) <= '0' & x(15 downto 9);         -- exponent
  ina0(22 downto 14) <= x(8 downto 0);                -- mantissa
  ina0(13 downto 0) <= conv_std_logic_vector(0, 14);  -- unused mantissa
  
  inb0(31) <= y(16);                                  -- sign
  inb0(30 downto 23) <= '0' & y(15 downto 9);         -- exponent
  inb0(22 downto 14) <= y(8 downto 0);                -- mantissa
  inb0(13 downto 0) <= conv_std_logic_vector(0, 14);  -- unused mantissa

  -- stage 1
  process(clk)
  begin
    if(clk'event and clk='1') then
      ina(31) <= ina0(31);
      ina(22 downto 0) <= ina0(22 downto 0);
    end if;
  end process;

  with x(15 downto 0) select
    nza <=
    '0' when conv_std_logic_vector(0, 16),
    '1' when others;

  u0: lpm_add_sub                       -- add 127 offset to exponent
    generic map (LPM_WIDTH=>8,LPM_DIRECTION=>"ADD")
    port map(result => ea,
             dataa  => ina0(30 downto 23),
             datab  => "01111111");

  process(clk)
  begin
    if(clk'event and clk='1') then                               
      if (nza = '1') then
        ina(30 downto 23) <= ea;
      else
        ina(30 downto 23) <= "00000000";
      end if;
    end if;                                                      
  end process;                                                   

  process(clk)
  begin
    if(clk'event and clk='1') then                               
      inb(31) <= inb0(31);
      inb(22 downto 0) <= inb0(22 downto 0);
    end if;                                                      
  end process;                                                   

  with y(15 downto 0) select
    nzb <=
    '0' when conv_std_logic_vector(0, 16),
    '1' when others;

  u1: lpm_add_sub                       -- add 127 offset to exponent
    generic map (LPM_WIDTH=>8,LPM_DIRECTION=>"ADD")
    port map(result => eb,
             dataa  => inb0(30 downto 23),
             datab  => "01111111");

  process(clk) begin                                             
    if(clk'event and clk='1') then                               
      if (nzb = '1') then
        inb(30 downto 23) <= eb;
      else
        inb(30 downto 23) <= "00000000";
      end if;
    end if;                                                      
  end process;                                                   

  -- stage 2 to 7
  u2 : my_fp_mult_32_1
    port map (
		clock	 => clk,
		dataa	 => ina,
		datab	 => inb,
		result	 => ab
	);

  -- stage 8
  process(clk)
  begin
    if(clk'event and clk='1') then
      outa(31) <= ab(31);
      outa(22 downto 0) <= ab(22 downto 0);
    end if;
  end process;

  with ab(30 downto 0) select
    nzab <=
    '0' when conv_std_logic_vector(0, 31),
    '1' when others;

  u3: lpm_add_sub                       -- sub 127 offset from exponent
    generic map (LPM_WIDTH=>8,LPM_DIRECTION=>"SUB")
    port map(result => eab,
             dataa  => ab(30 downto 23),
             datab  => "01111111");

  process(clk)
  begin
    if(clk'event and clk='1') then                               
      if (nzab = '1') then
        outa(30 downto 23) <= eab;
      else
        outa(30 downto 23) <= "00000000";
      end if;
    end if;                                                      
  end process;                                                   

  z(16) <= outa(31);                     -- sign
  z(15 downto 9) <= outa(29 downto 23);  -- exponent
  z(8 downto 0) <= outa(22 downto 14);   -- mantissa

end syn;

--
-- my_fp_addw_17_9
--
-- 17-bit floating-point adder
--
-- 1     7            9
-- sign  exponent     mantissa
--       (no offset)
--
-- pipeline delay: 9
--
-- this implementation uses altfp_add_sub
-- (32-bit floating-point adder/subtractor megafunction),
-- disabling unnecessary part (14 bits out of 23) of mantissa.
--
-- this is not efficient at all and not intended for practical use.
-- should be used just for debugging purpose.
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity my_fp_addw_17_9 is
  port
    (
        clk		: in std_logic;
        x		: in std_logic_vector(16 downto 0);
        y		: in std_logic_vector(16 downto 0);
        z		: out std_logic_vector(16 downto 0)
      );
end my_fp_addw_17_9;

architecture syn of my_fp_addw_17_9 is

  component my_fp_add_32_1
    port
      (
        clock		: in std_logic;
        dataa		: in std_logic_vector (31 downto 0);
        datab		: in std_logic_vector (31 downto 0);
        nan		: out std_logic;
        overflow	: out std_logic;
        result		: out std_logic_vector (31 downto 0);
        underflow	: out std_logic 
	);
  end component;

  component lpm_add_sub                                            
    generic (LPM_WIDTH: integer;                                   
             LPM_DIRECTION: string);                               
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);  
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));     
  end component;                                                   
  

  signal ina, ina0 : std_logic_vector(31 downto 0);
  signal inb, inb0 : std_logic_vector(31 downto 0);
  signal outa : std_logic_vector(31 downto 0);
  signal ab : std_logic_vector(31 downto 0);
  signal ea, eb, eab : std_logic_vector(7 downto 0);
  signal nza, nzb, nzab : std_logic;
  
begin
  
  -- stage 0
  ina0(31) <= x(16);                                  -- sign
  ina0(30 downto 23) <= '0' & x(15 downto 9);         -- exponent
  ina0(22 downto 14) <= x(8 downto 0);                -- mantissa
  ina0(13 downto 0) <= conv_std_logic_vector(0, 14);  -- unused mantissa
  
  inb0(31) <= y(16);                                  -- sign
  inb0(30 downto 23) <= '0' & y(15 downto 9);         -- exponent
  inb0(22 downto 14) <= y(8 downto 0);                -- mantissa
  inb0(13 downto 0) <= conv_std_logic_vector(0, 14);  -- unused mantissa

  -- stage 1
  process(clk)
  begin
    if(clk'event and clk='1') then
      ina(31) <= ina0(31);
      ina(22 downto 0) <= ina0(22 downto 0);
    end if;
  end process;

  with x(15 downto 0) select
    nza <=
    '0' when conv_std_logic_vector(0, 16),
    '1' when others;

  u0: lpm_add_sub                       -- add 127 offset to exponent
    generic map (LPM_WIDTH=>8,LPM_DIRECTION=>"ADD")
    port map(result => ea,
             dataa  => ina0(30 downto 23),
             datab  => "01111111");

  process(clk)
  begin
    if(clk'event and clk='1') then                               
      if (nza = '1') then
        ina(30 downto 23) <= ea;
      else
        ina(30 downto 23) <= "00000000";
      end if;
    end if;                                                      
  end process;                                                   

  process(clk)
  begin
    if(clk'event and clk='1') then                               
      inb(31) <= inb0(31);
      inb(22 downto 0) <= inb0(22 downto 0);
    end if;                                                      
  end process;                                                   

  with y(15 downto 0) select
    nzb <=
    '0' when conv_std_logic_vector(0, 16),
    '1' when others;

  u1: lpm_add_sub                       -- add 127 offset to exponent
    generic map (LPM_WIDTH=>8,LPM_DIRECTION=>"ADD")
    port map(result => eb,
             dataa  => inb0(30 downto 23),
             datab  => "01111111");

  process(clk) begin                                             
    if(clk'event and clk='1') then                               
      if (nzb = '1') then
        inb(30 downto 23) <= eb;
      else
        inb(30 downto 23) <= "00000000";
      end if;
    end if;                                                      
  end process;                                                   

  -- stage 2 to 9
  u2 : my_fp_add_32_1
    port map (
		clock	 => clk,
		dataa	 => ina,
		datab	 => inb,
		result	 => ab
	);

  -- stage 10
  process(clk)
  begin
    if(clk'event and clk='1') then
      outa(31) <= ab(31);
      outa(22 downto 0) <= ab(22 downto 0);
    end if;
  end process;

  with ab(30 downto 0) select
    nzab <=
    '0' when conv_std_logic_vector(0, 31),
    '1' when others;

  u3: lpm_add_sub                       -- sub 127 offset from exponent
    generic map (LPM_WIDTH=>8,LPM_DIRECTION=>"SUB")
    port map(result => eab,
             dataa  => ab(30 downto 23),
             datab  => "01111111");

  process(clk)
  begin
    if(clk'event and clk='1') then                               
      if (nzab = '1') then
        outa(30 downto 23) <= eab;
      else
        outa(30 downto 23) <= "00000000";
      end if;
    end if;                                                      
  end process;                                                   

  z(16) <= outa(31);                     -- sign
  z(15 downto 9) <= outa(29 downto 23);  -- exponent
  z(8 downto 0) <= outa(22 downto 14);   -- mantissa

end syn;

library ieee;
use ieee.std_logic_1164.all;

entity reged_table is
  generic (IN_WIDTH: integer;
           OUT_WIDTH: integer;
           TABLE_FILE: string);
  port (indata : in std_logic_vector(IN_WIDTH-1 downto 0);
        outdata : out std_logic_vector(OUT_WIDTH-1 downto 0);
        clk : in std_logic);
end reged_table;

architecture rtl of reged_table is

  component lpm_rom
    generic (LPM_WIDTH: POSITIVE;
             LPM_WIDTHAD: POSITIVE;
             LPM_ADDRESS_CONTROL: STRING;
             LPM_FILE: STRING);
    port (address: in std_logic_vector(LPM_WIDTHAD-1 downto 0);
          inclock: in std_logic;
          outclock: in std_logic;
          q: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

begin

  u1: lpm_rom generic map (LPM_WIDTH=>OUT_WIDTH,
                           LPM_WIDTHAD=>IN_WIDTH,
                           LPM_ADDRESS_CONTROL=>"REGISTERED",
                           LPM_FILE=>TABLE_FILE)
  port map(address=>indata,inclock=>clk,outclock=>clk,q=>outdata);

end rtl;

library ieee;
use ieee.std_logic_1164.all;

entity pg_pdelay is
  generic (PG_WIDTH: integer;
           PG_NDELAY: integer);
  port( x : in std_logic_vector(PG_WIDTH-1 downto 0);
        y : out std_logic_vector(PG_WIDTH-1 downto 0);
        clk : in std_logic);
end pg_pdelay;


architecture rtl of pg_pdelay is

  signal s : std_logic_vector((PG_NDELAY + 1) * PG_WIDTH downto 0);

begin

  each_bit: for i in 0 to PG_WIDTH-1 generate
    s((PG_NDELAY + 1) * i + 0) <= x(i);
    process(clk)
    begin
      if(clk'event and clk='1') then
        each_delay: for j in 0 to PG_NDELAY-1 loop
          s((PG_NDELAY + 1) * i + j + 1) <= s((PG_NDELAY + 1) * i + j);
        end loop each_delay;
      end if;
    end process;
    y(i) <= s((PG_NDELAY + 1) * i + PG_NDELAY);
  end generate each_bit;

end rtl;


-- ***************************************************************
-- * PGPG LOGARITHMIC TO FIXED-POINT FORMAT CONVERTER            *
-- *  AUTHOR: Tsuyoshi Hamada                                    *
-- *  VERSION: 2.00                                              *
-- *  LAST MODIFIED AT Tue Jun 03 22:52:01 JST 2003              *
-- * 
-- *  manually edited by AK 2007/02/17
-- ***************************************************************
library ieee;
use ieee.std_logic_arith.all;
use ieee.std_logic_1164.all;

entity pg_conv_ltof_17_8_57_7 is
  port(logdata : in std_logic_vector(16 downto 0);
       fixdata : out std_logic_vector(56 downto 0);
       clk : in std_logic);
end pg_conv_ltof_17_8_57_7;

architecture rtl of pg_conv_ltof_17_8_57_7 is

  component table
    generic (IN_WIDTH: integer;
             OUT_WIDTH: integer;
             TABLE_FILE: string);
    port(indata : in std_logic_vector(IN_WIDTH-1 downto 0);
         outdata : out std_logic_vector(OUT_WIDTH-1 downto 0);
         clk : in std_logic);
  end component;

  component lpm_add_sub                                            
    generic (LPM_WIDTH: integer;                                   
             LPM_DIRECTION: string);                               
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);  
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));     
  end component;                                                   
  
  component reged_shift_ltof_9_7_56_5
    port( indata : in std_logic_vector(8 downto 0);
          control : in std_logic_vector(6 downto 0);
          clk : in std_logic;
          outdata : out std_logic_vector(55 downto 0));
  end component;

  signal frac1 : std_logic_vector(7 downto 0);
  signal frac2 : std_logic_vector(8 downto 0);
  signal sign1 : std_logic;
  signal sign2 : std_logic;
  signal sign3 : std_logic;
  signal sign4 : std_logic;
  signal sign5 : std_logic;
  signal sign6 : std_logic;
  signal nz1 : std_logic;
  signal exp1, exp1a : std_logic_vector(6 downto 0);
  signal fix1 : std_logic_vector(55 downto 0);

begin

  process(clk) begin
    if(clk'event and clk='1') then
      sign1 <= logdata(16);
      nz1 <= logdata(15);
      exp1 <= logdata(14 downto 8);
    end if;
  end process;

  u1: table generic map (IN_WIDTH=>8,OUT_WIDTH=>8,TABLE_FILE=>"l8tf8.mif")
          port map(indata=>logdata(7 downto 0),outdata=>frac1,clk=>clk);

  with nz1 select
    frac2 <= '1' & frac1 when '1',
             "000000000" when others;

  -------------------------------------------------------------------
  -- PIPELINE 3,4,5,6,7 STAGES

  -- remove 23-bit mass-offset added by the host computer
  u2: lpm_add_sub generic map (LPM_WIDTH=>7,LPM_DIRECTION=>"SUB")
                  port map(result=>exp1a,dataa=>exp1,datab=>conv_std_logic_vector(23,7));

  u3: reged_shift_ltof_9_7_56_5
      port map (indata=>frac2,control=>exp1a,outdata=>fix1,clk=>clk);
  process(clk) begin
    if(clk'event and clk='1') then
      sign2 <= sign1;
    end if;
  end process;
  process(clk) begin
    if(clk'event and clk='1') then
      sign3 <= sign2;
    end if;
  end process;
  process(clk) begin
    if(clk'event and clk='1') then
      sign4 <= sign3;
    end if;
  end process;
  process(clk) begin
    if(clk'event and clk='1') then
      sign5 <= sign4;
    end if;
  end process;
  process(clk) begin
    if(clk'event and clk='1') then
      sign6 <= sign5;
    end if;
  end process;
  -------------------------------------------------------------------

  process(clk) begin
    if(clk'event and clk='1') then
      fixdata(56) <= sign6;
      fixdata(55 downto 0) <= fix1;
    end if;
  end process;

end rtl;

-- Pipelined Shifter for Log to Fix Converter
-- Author: Tsuyoshi Hamada
-- Last Modified at Apr 11,2003

library ieee;
use ieee.std_logic_arith.all;
use ieee.std_logic_1164.all;

entity reged_shift_ltof_9_7_56_5 is
  port( indata : in std_logic_vector(8 downto 0);
        control : in std_logic_vector(6 downto 0);
        clk : in std_logic;
        outdata : out std_logic_vector(55 downto 0));
end reged_shift_ltof_9_7_56_5;

architecture rtl of reged_shift_ltof_9_7_56_5 is

  signal c0 : std_logic_vector(6 downto 0);
  signal c1 : std_logic_vector(6 downto 0);
  signal c2 : std_logic_vector(6 downto 0);
  signal c3 : std_logic_vector(6 downto 0);
  signal c4 : std_logic_vector(6 downto 0);
  signal c5 : std_logic_vector(6 downto 0);
  signal o0,o0d : std_logic_vector(8 downto 0);
  signal o1,o1d : std_logic_vector(9 downto 0);
  signal o2,o2d : std_logic_vector(11 downto 0);
  signal o3,o3d : std_logic_vector(15 downto 0);
  signal o4,o4d : std_logic_vector(23 downto 0);
  signal o5,o5d : std_logic_vector(39 downto 0);
  signal o6,o6d : std_logic_vector(71 downto 0);

begin

  c0 <= control;

  o0d <= indata;
  with c0(0) select
    o1 <= o0d & '0' when '1',
          '0' & o0d when others;

  with c1(1) select
    o2 <= o1d & "00" when '1',
          "00" & o1d when others;

  with c2(2) select
    o3 <= o2d & "0000" when '1',
          "0000" & o2d when others;

  with c3(3) select
    o4 <= o3d & "00000000" when '1',
          "00000000" & o3d when others;

  with c4(4) select
    o5 <= o4d & "0000000000000000" when '1',
          "0000000000000000" & o4d when others;

  with c5(5) select
    o6 <= o5d & "00000000000000000000000000000000" when '1',
          "00000000000000000000000000000000" & o5d when others;

  with c5(6) select
    outdata <= o6(63 downto 8) when '0',
    conv_std_logic_vector(0, 56) when others;
  
  process(clk) begin
    if(clk'event and clk='1') then
      o1d <= o1;
      c1 <= c0;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      o2d <= o2;
      c2 <= c1;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      o3d <= o3;
      c3 <= c2;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      o4d <= o4;
      c4 <= c3;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      o5d <= o5;
      c5 <= c4;
    end if;
  end process;
end rtl;

--
-- entry generator for cut-off function table.
-- 
-- pipeline delay: 4
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity egen_4 is 
port(x : in std_logic_vector(14 downto 0);
     y : in std_logic_vector(14 downto 0);
     z : out std_logic_vector(8 downto 0);
     clk : in std_logic
     );
end egen_4;

architecture egen_ar of egen_4 is

  component lpm_add_sub
    generic (LPM_WIDTH: integer;
             LPM_DIRECTION: string);
    port (dataa,datab: in std_logic_vector(LPM_WIDTH-1 downto 0);
          result: out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  component lpm_clshift
    generic (LPM_WIDTH : POSITIVE;
             LPM_WIDTHDIST : POSITIVE);
    port(data : in std_logic_vector(LPM_WIDTH-1 downto 0);
         distance : in std_logic_vector(LPM_WIDTHDIST-1 downto 0);
         direction : in std_logic;
         result : out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  component my_conv_ltofp_17_8_17_9
    port (logdata: in std_logic_vector(16 downto 0);
          fpdata:  out std_logic_vector(16 downto 0);
          clk: in std_logic);
  end component;

  signal xe, xeoff0: std_logic_vector(6 downto 0);
  signal xoff0: std_logic_vector(14 downto 0);
  signal xylog0,xylog1: std_logic_vector(14 downto 0);
  signal xyfp3: std_logic_vector(16 downto 0);
  signal m3,m3a: std_logic_vector(17 downto 0);
  signal e3: std_logic_vector(6 downto 0);
  signal z4: std_logic_vector(8 downto 0);
  signal nz1,nz2,nz3: std_logic;
  signal ovflw2,ovflw3: std_logic;

begin

  xe <= x(14 downto 8);
    
  -- add 8-bit offset to x
  -- pipeline delay: 0
  u0: lpm_add_sub
    generic map (LPM_WIDTH=>7,LPM_DIRECTION=>"ADD")
    port map(result=>xeoff0,dataa=>xe,datab=>conv_std_logic_vector(8,7));

  xoff0 <= xeoff0 & x(7 downto 0);

  -- 2^8 * x / y in log fmt
  -- pipeline delay: 1
  u1: lpm_add_sub
    generic map(LPM_WIDTH=>15,LPM_DIRECTION=>"SUB")
    port map(dataa=>xoff0,datab=>y,result=>xylog0);

  process (clk)
  begin
    if(clk'event and clk='1') then
      xylog1 <= xylog0;
      end if;
  end process;

  process (clk)
  begin
    if(clk'event and clk='1') then
      if (xylog1(13 downto 8) >= "001001") then
        ovflw2 <= '1';
      else
        ovflw2 <= '0';
      end if;
    end if;
  end process;

  with xylog1(14) select 
    nz1 <=
    '1' when '0',
    '0' when others;  --  x/y is smaller than 2^-8

  process (clk)
  begin
    if(clk'event and clk='1') then
      nz2 <= nz1;
      nz3 <= nz2;
    end if;
  end process;
  
  process (clk)
  begin
    if(clk'event and clk='1') then
      ovflw3 <= ovflw2;
    end if;
  end process;
  
  -- entry in log fmt -> fp fmt
  -- pipeline delay: 2
  u2: my_conv_ltofp_17_8_17_9
    port map (logdata=>"01" & xylog1,fpdata=>xyfp3,clk=>clk);

  -- entry in fp fmt -> fix fmt
  -- pipeline delay: 
  e3 <= xyfp3(15 downto 9);
  m3 <= conv_std_logic_vector(0,8) & '1' & xyfp3(8 downto 0);

  u3: lpm_clshift generic map (LPM_WIDTH=>18,LPM_WIDTHDIST=>4)
    port map (data=>m3,distance=>e3(3 downto 0),result=>m3a,direction=>'0');

  process(clk)
  begin
    if(clk'event and clk='1') then
      if (nz3 = '0') then
        z4 <= "000000000";
      elsif (ovflw3 = '1') then
        z4 <= "111111111";
      else
        z4 <= m3a(17 downto 9);
      end if;
    end if;
  end process;

  z <= z4;
  
end egen_ar;

-- 
-- cut-off function
--
-- pipeline delay: 1
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity cutofftable_1 is
  generic (TABLE_FILE : string);
  port (index: in std_logic_vector(8 downto 0);
        value: out std_logic_vector(11 downto 0);
        nz: out std_logic;
        clk: in std_logic);
end cutofftable_1;

architecture rtl of cutofftable_1 is

  component table
    generic (IN_WIDTH: integer ;
             OUT_WIDTH: integer ;
             TABLE_FILE: string);
    port (indata : in std_logic_vector(IN_WIDTH-1 downto 0);
          outdata : out std_logic_vector(OUT_WIDTH-1 downto 0);
          clk : in std_logic);
  end component;

  signal ginv1 : std_logic_vector(11 downto 0);
  signal nz0 : std_logic;
  
begin
  
  u0: table generic map(IN_WIDTH=>8,OUT_WIDTH=>12,TABLE_FILE=>TABLE_FILE)
            port map(indata=>index(8 downto 1),outdata=>ginv1,clk=>clk);
  value <= ginv1;

  -- index 0xf3 (1111 0011) inficate r/eta
  -- at which 12-bit 1/g table for P3M overflows.
  nz0 <= '1' when (index(8 downto 1) < "11110011") else '0';

  process(clk) begin
    if(clk'event and clk='1') then
      nz <= nz0;
    end if;
  end process;

end rtl;
