library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
library lpm;
use lpm.lpm_components.all;

entity pg_ctl is 
  generic (
    JDATA_WIDTH : integer :=128;
    MEM_WIDTH : integer);
  port(
-- PCI-X side
      hib_we: in std_logic;
      hib_data: in std_logic_vector(63 downto 0);
      backend_we: out std_logic;
      backend_data: out std_logic_vector(63 downto 0);
      clk,rst: in std_logic;

-- pg_pipe side
      p_jdata : out std_logic_vector(JDATA_WIDTH-1 downto 0);     
      p_run : out std_logic;                                      
      p_runret : in std_logic;
      p_we :  out std_logic;                                      
      p_adri : out std_logic_vector(11 downto 0);                 
      p_datai : out std_logic_vector(63 downto 0);                
      p_adro : out std_logic_vector(11 downto 0);                 
      p_datao : in std_logic_vector(63 downto 0);
      p_eta : out std_logic_vector(14 downto 0)
  );
end pg_ctl;

architecture hierarchy of pg_ctl is

  component ipw
    generic(MEM_WIDTH: integer);
    port( 
      hib_we: in std_logic;
      hib_data : in std_logic_vector(63 downto 0);
      m_we: out std_logic;
      m_cs: out std_logic;      
      m_adr: out std_logic_vector(MEM_WIDTH-1 downto 0);
      m_data: out std_logic_vector(63 downto 0);                  
      p_we : out std_logic;
      p_adri : out std_logic_vector(11 downto 0);
      p_datai: out std_logic_vector(63 downto 0);
      i_ipwon: out std_logic;
      clk,rst : in std_logic );
  end component;

  component calc
    generic(MEM_WIDTH: integer);
    port(
      hib_we: in std_logic;
      hib_data : in std_logic_vector(63 downto 0);
      c_adr : out std_logic_vector(MEM_WIDTH-1 downto 0);
      p_run : out std_logic;
      i_ipwon: in std_logic;
      rst,clk : in std_logic);
  end component;

  component fo
    port(
      hib_we: in std_logic;
      hib_data : in std_logic_vector(63 downto 0);
      backend_we: out std_logic;
      backend_data : out std_logic_vector(63 downto 0);
      p_adro : out std_logic_vector(11 downto 0);
      p_datao : in std_logic_vector(63 downto 0);      
      p_runret : in std_logic;
      i_ipwon: in std_logic;
      rst,clk : in std_logic );
  end component;

  component dpram
	PORT
	(
		data		: IN STD_LOGIC_VECTOR (63 DOWNTO 0);
		wren		: IN STD_LOGIC  := '1';
		wraddress	: IN STD_LOGIC_VECTOR (MEM_WIDTH-1 DOWNTO 0);
		rdaddress	: IN STD_LOGIC_VECTOR (MEM_WIDTH-1 DOWNTO 0);
		clock		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (63 DOWNTO 0)
	);
  end component;

--  component lpm_ram_dp
--       generic (LPM_WIDTH: positive;
--                LPM_WIDTHAD: positive;
--		 LPM_RDADDRESS_CONTROL: string;
--		 LPM_WRADDRESS_CONTROL: string;
--		 LPM_INDATA: string;
--  		 LPM_OUTDATA: string);
--        port(wren: in std_logic;
--	     data: in std_logic_vector(LPM_WIDTH-1 downto 0);
--	     wrclock: in std_logic;
--	     wraddress: in std_logic_vector(LPM_WIDTHAD-1 downto 0);
--	     rden: in std_logic;
--	     rdclock: in std_logic;
--	     rdaddress: in std_logic_vector(LPM_WIDTHAD-1 downto 0);
--	     q: out std_logic_vector(LPM_WIDTH-1 downto 0)
--        );
--  end component;

  signal m_we: std_logic;
  signal m_cs: std_logic;  
  signal m_adr: std_logic_vector(MEM_WIDTH-1 downto 0);
  signal m_data: std_logic_vector(63 downto 0);                  
  signal c_adr: std_logic_vector(MEM_WIDTH-1 downto 0);
--  signal rden : std_logic ;
  signal we: std_logic_vector(1 downto 0);
  signal i_ipwon: std_logic;
  signal eta: std_logic_vector(14 downto 0);
  signal hib_we1: std_logic;
  signal hib_data1 : std_logic_vector(63 downto 0);
  
begin
  
  uipw : ipw generic map (MEM_WIDTH => MEM_WIDTH)
             PORT MAP(hib_we=>hib_we,hib_data=>hib_data,
                     m_we=>m_we, m_cs=>m_cs,m_adr=>m_adr,m_data=>m_data,
                     p_we=>p_we, p_adri=>p_adri, p_datai=>p_datai,
                     i_ipwon=>i_ipwon,clk=>clk,rst=>rst);

  ucalc: calc generic map (MEM_WIDTH => MEM_WIDTH)
              PORT MAP(hib_we=>hib_we,hib_data=>hib_data,
                       c_adr=>c_adr,p_run=>p_run, i_ipwon=>i_ipwon,
                       rst=>rst,clk=>clk);

  ufo: fo PORT MAP(hib_we=>hib_we,hib_data=>hib_data,
                   backend_we=>backend_we, backend_data=>backend_data,
                   p_adro=>p_adro, p_datao=>p_datao, p_runret=>p_runret,
                   i_ipwon=>i_ipwon,rst=>rst,clk=>clk);

--  rden <= '1';
                    
  process(m_we,m_cs) begin
    if((m_we = '1') and (m_cs = '0')) then
      we(0) <= '1';
    else
      we(0) <= '0';
    end if;
  end process;
   
  udpram0 : dpram PORT MAP (
		data	 => m_data,
		wren	 => we(0),
		wraddress	 => m_adr,
		rdaddress	 => c_adr,
		clock	 => clk,
		q	 => p_jdata(63 downto 0)
	);

--  udpram0: lpm_ram_dp generic map(LPM_WIDTH => 64, LPM_WIDTHAD => MEM_WIDTH,
--                    LPM_RDADDRESS_CONTROL => "REGISTERED",
--		    LPM_WRADDRESS_CONTROL => "REGISTERED",
--		    LPM_INDATA => "REGISTERED",
--    		    LPM_OUTDATA => "REGISTERED")
--                    port map(wren=>we(0), data=>m_data,
--	            wraddress=>m_adr, wrclock=>clk, rden=>rden, 
--	            rdaddress=>c_adr, rdclock=>clk, q=>p_jdata(63 downto 0));

  process(m_we,m_cs) begin
    if((m_we = '1') and (m_cs = '1')) then
      we(1) <= '1';
    else
      we(1) <= '0';
    end if;
  end process;

  udpram1 : dpram PORT MAP (
		data	 => m_data,
		wren	 => we(1),
		wraddress	 => m_adr,
		rdaddress	 => c_adr,
		clock	 => clk,
		q	 => p_jdata(127 downto 64)
	);

--  udpram1: lpm_ram_dp generic map(LPM_WIDTH => 64, LPM_WIDTHAD => MEM_WIDTH,
--		    LPM_RDADDRESS_CONTROL => "REGISTERED",
--		    LPM_WRADDRESS_CONTROL => "REGISTERED",
--		    LPM_INDATA => "REGISTERED",
--    		    LPM_OUTDATA => "REGISTERED")
--                    port map(wren=>we(1), data=>m_data,
--	            wraddress=>m_adr, wrclock=>clk, rden=>rden, 
--	            rdaddress=>c_adr, rdclock=>clk, q=>p_jdata(127 downto 64));

  process(clk) begin
    if(clk'event and clk='1') then
      hib_we1 <= hib_we;
      hib_data1 <= hib_data;
    end if;
  end process;
  
  process(clk,rst)
  begin
    if(rst = '0') then
      eta <= "111111111111111";        -- any large value will do.
    elsif(clk'event and clk='1') then
      if(hib_we1 ='1' and hib_data1(31 downto 28)="1101" and i_ipwon='0') then
        eta <= hib_data1(46 downto 32);
      end if;
    end if;
  end process;
  p_eta <= eta;
  
end hierarchy;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity ipw is 
  generic (
    MEM_WIDTH : integer);
  port(
      hib_we: in std_logic;
      hib_data : in std_logic_vector(63 downto 0);
      m_we: out std_logic;
      m_cs: out std_logic;      
      m_adr: out std_logic_vector(MEM_WIDTH-1 downto 0);
      m_data: out std_logic_vector(63 downto 0);                  
      p_we : out std_logic;
      p_adri : out std_logic_vector(11 downto 0);
      p_datai: out std_logic_vector(63 downto 0);
      i_ipwon: out std_logic;
      clk,rst : in std_logic );
end ipw;

architecture rtl of ipw is

signal hib_we1: std_logic;
signal hib_data1 : std_logic_vector(63 downto 0);
signal iword_dc: std_logic_vector(15 downto 0);
signal iword_uc: std_logic_vector(16 downto 0);
signal ipwon,iflag,jflag: std_logic;
signal ni,nd : std_logic_vector(15 downto 0);
signal ah_dc,ah_uc : std_logic_vector(8 downto 0);
signal al_dc,al_uc : std_logic_vector(4 downto 0);

begin

--
-- hib_we      __~~~~~~~~_____
-- hib_data    --<      >-----
-- hib_we1       __~~~~~~~~_____
-- hib_data1     --<      >-----
-- word_dc      -----<><><>-----
-- 

  process(clk) begin
    if(clk'event and clk='1') then
      hib_we1 <= hib_we;
      hib_data1 <= hib_data;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      if(hib_we1 ='1' and hib_data1(31 downto 28)="1100" and ipwon='0') then
        ni <= hib_data1(47 downto 32);
        nd <= hib_data1(63 downto 48);        
      end if;
    end if;
  end process;

-- i word counter

  process(iword_dc) begin
    if(iword_dc /= "0000000000000000") then
      ipwon <= '1';
    else
      ipwon <= '0';      
    end if;
  end process;
  i_ipwon <= ipwon;
  
  process(clk,rst)
  begin
    if (rst = '0') then 
      iword_dc <= "0000000000000000";
    elsif (clk'event and clk='1') then
      if(hib_we1 = '1') then 
        if(iword_dc = "0000000000000000") then
          if(hib_data1(31)='0') then
            iword_dc <= hib_data1(47 downto 32);
            iword_uc <= hib_data1(63 downto 48) & '0' ;
            if(hib_data1(30)='0') then
              iflag <= '1';
              jflag <= '0';             
            else
              iflag <= '0';
              jflag <= '1';             
            end if;
          end if;
        else
          iword_dc <= iword_dc - "0000000000000001";
          iword_uc <= iword_uc + "00000000000000001";                     
        end if;
      end if;
    end if;
  end process;

-- ip 
 
  process(clk) begin
    if(clk'event and clk='1') then
--      if(ipwon='1' and iflag = '1') then  -- !!!
      if(ipwon='1' and iflag = '1' and hib_we1 = '1') then
        p_we <= '1';
        p_datai <= hib_data1;
        p_adri <= ah_uc(7 downto 0) & al_uc(3 downto 0); 
      else
        p_we <= '0';        
      end if;
    end if;
  end process;
  
  process(clk) begin
    if(clk'event and clk='1') then
      if(hib_we1 = '1' and iword_dc = "0000000000000000" and hib_data1(31 downto 30)="00") then 
        ah_dc <= ni(8 downto 0);
        ah_uc <= "000000000"; 
      elsif(ah_dc /= "000000000" and al_dc = "00001") then
        ah_dc <= ah_dc - "000000001"; 
        ah_uc <= ah_uc + "000000001"; 
      end if;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      if(hib_we1 = '1' and iword_dc = "0000000000000000" and hib_data1(31 downto 30)="00") then 
        al_dc <= nd(4 downto 0);
        al_uc <= "00000"; 
      elsif(al_dc = "00001" and ah_dc /= "000000000") then
        al_dc <= nd(4 downto 0);
        al_uc <= "00000"; 
      elsif(al_dc /= "00000") then 
        al_dc <= al_dc - "00001"; 
        al_uc <= al_uc + "00001"; 
      end if;
    end if;
  end process;

-- jp
 
  process(clk) begin
    if(clk'event and clk='1') then
--      if(ipwon = '1' and jflag = '1') then  -- !!!
      if(ipwon = '1' and jflag = '1' and hib_we1 = '1') then 
        m_we <= '1';
        m_data <= hib_data1;
        m_adr <= iword_uc(MEM_WIDTH downto 1);
        m_cs <= iword_uc(0);
      else
        m_we <= '0';        
      end if;
    end if;
  end process;

end rtl;
  
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity calc is
    generic(MEM_WIDTH: integer);
    port(
      hib_we: in std_logic;
      hib_data : in std_logic_vector(63 downto 0);
      c_adr : out std_logic_vector(MEM_WIDTH-1 downto 0);
      p_run : out std_logic;
      i_ipwon : in std_logic;
      rst,clk : in std_logic);
end calc;

architecture rtl of calc is

signal hib_we1: std_logic;
signal hib_data1 : std_logic_vector(63 downto 0);
signal ncnt_dc : std_logic_vector(15 downto 0);
signal ncnt_uc : std_logic_vector(15 downto 0);
signal run0 : std_logic;

begin

--
-- hib_we      __~~_____
-- hib_data    --<> -----
-- hib_we1       __~~_____
-- hib_data1     --<>-----
-- ncnt_dc      -----<3<2<1<0---
-- ncnt_uc      -----<0<1<2<3---
-- c_adr        -----<0<1<2-----
-- p_jdata      ---------<0<1<2-----  
-- run          _______~~~~~~__
-- p_run        _______~~~~~~__  

  
  process(clk) begin
    if(clk'event and clk='1') then
      hib_we1 <= hib_we;
      hib_data1 <= hib_data;
    end if;
  end process;

  process(clk,rst)
  begin
    if(rst = '0') then
      ncnt_dc <= "0000000000000000";
    elsif(clk'event and clk='1') then
      if(hib_we1 ='1' and hib_data1(31 downto 30)="10" and i_ipwon='0') then
        ncnt_dc <= hib_data1(47 downto 32);
        ncnt_uc <= "0000000000000000";
      elsif(ncnt_dc /= "0000000000000000") then 
        ncnt_dc <= ncnt_dc - "0000000000000001";
        ncnt_uc <= ncnt_uc + "0000000000000001";          
      end if;
    end if;
  end process;

  c_adr <= ncnt_uc(MEM_WIDTH-1 downto 0);

  process(clk) begin
    if(clk'event and clk='1') then
      if(ncnt_dc /= "0000000000000000" ) then
        run0 <= '1';
      else
        run0 <= '0';
      end if;
    end if;
  end process;

  p_run <= run0;
  
end rtl;
  
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity fo is
    port(
      hib_we: in std_logic;
      hib_data : in std_logic_vector(63 downto 0);
      backend_we: out std_logic;
      backend_data : out std_logic_vector(63 downto 0);
      p_adro : out std_logic_vector(11 downto 0);
      p_datao : in std_logic_vector(63 downto 0);      
      p_runret : in std_logic;
      i_ipwon: in std_logic;
      rst,clk : in std_logic );
end fo;

architecture rtl of fo is

signal hib_we1: std_logic;
signal hib_data1 : std_logic_vector(63 downto 0);
signal ni,nd : std_logic_vector(15 downto 0);
signal ah_dc,ah_uc : std_logic_vector(8 downto 0);
signal al_dc,al_uc : std_logic_vector(4 downto 0);
signal runret1, we : std_logic;
  
begin

-- p_runret   ~~____________
-- runret1    ~~~~__________ 
-- ah_dc      ----<2 ><1 ><0
-- ah_uc      ----<0 ><1 ><2  
-- al_dc      ----<2<1<2<1<2<1<0
-- al_uc      ----<0<1<0<1<0<1<2
-- p_adro     ----<      >------
-- p_datao    ------<      >----
-- backend    --------<      >----
--   _data
-- backend_we ________~~~~~~~~____


  process(clk) begin
    if(clk'event and clk='1') then
      hib_we1 <= hib_we;
      hib_data1 <= hib_data;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      if(hib_we1 ='1' and hib_data1(31 downto 29)="111" and i_ipwon='0') then
        ni <= hib_data1(47 downto 32);
        nd <= hib_data1(63 downto 48);        
      end if;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      runret1 <= p_runret;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      if(p_runret = '0' and runret1 = '1') then
        ah_dc <= ni(8 downto 0);
        ah_uc <= "000000000"; 
      elsif(ah_dc /= "000000000" and al_dc = "00001") then
        ah_dc <= ah_dc - "000000001"; 
        ah_uc <= ah_uc + "000000001"; 
      end if;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      if(p_runret = '0' and runret1 = '1') then
        al_dc <= nd(4 downto 0);
        al_uc <= "00000"; 
      elsif(al_dc = "00001" and ah_dc /= "000000000") then
        al_dc <= nd(4 downto 0);
        al_uc <= "00000"; 
      elsif(al_dc /= "00000") then 
        al_dc <= al_dc - "00001"; 
        al_uc <= al_uc + "00001"; 
      end if;
    end if;
  end process;

  p_adro <= ah_uc(7 downto 0) & al_uc(3 downto 0); 

  process(clk) begin
    if(clk'event and clk='1') then
      if(ah_dc /= "000000000") then
        we <= '1';
      else
        we <= '0';
      end if;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      backend_we <= we;
      backend_data <= p_datao;
    end if;
  end process;

end rtl;
