library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
library lpm;
use lpm.lpm_components.all;

entity pg_ifbuf is 
  port(
-- PCI-X side
      hib_we: in std_logic;
      hib_data: in std_logic_vector(63 downto 0);
      backend_we: out std_logic;
      backend_data: out std_logic_vector(63 downto 0);

-- pg_pipe side
      hib_we_buf: out std_logic;
      hib_data_buf: out std_logic_vector(63 downto 0);
      backend_we_buf: in std_logic;
      backend_data_buf: in std_logic_vector(63 downto 0);

      stat : out std_logic_vector(1 downto 0);
      clk,rst: in std_logic
  );
end pg_ifbuf;

architecture rtl of pg_ifbuf is

component pg_scfifo
	PORT
	(
		data		: IN STD_LOGIC_VECTOR (63 DOWNTO 0);
		wrreq		: IN STD_LOGIC ;
		rdreq		: IN STD_LOGIC ;
		clock		: IN STD_LOGIC ;
		aclr		: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (63 DOWNTO 0);
		empty		: OUT STD_LOGIC ;
		almost_empty		: OUT STD_LOGIC 
	);
end component;

signal hib_we1: std_logic;
signal hib_data1 : std_logic_vector(63 downto 0);
signal hib_we2: std_logic;
signal hib_data2 : std_logic_vector(63 downto 0);
signal iword_dc: std_logic_vector(15 downto 0);
signal ipwon,passflag,iflag: std_logic;
signal hib_we_npass: std_logic;
signal hib_data_npass : std_logic_vector(63 downto 0);
signal nn,nd : std_logic_vector(15 downto 0);
signal ififo_wrreq : std_logic;
signal ififo_rdreq : std_logic;
signal ififo_data : std_logic_vector(63 downto 0);
signal ififo_q : std_logic_vector(63 downto 0);
signal ffifo_q : std_logic_vector(63 downto 0);
signal nrst : std_logic;
signal ififo_empty,almost_empty : std_logic;
signal status,status1,status2,status3,status4 : std_logic_vector(1 downto 0);
signal nrun_we : std_logic;
signal nrun_data : std_logic_vector(63 downto 0);
signal ipcnt : std_logic_vector(15 downto 0);
signal runret1,ififo_rdreq1: std_logic;
signal backend_we_buf1: std_logic;

begin

  process(clk) begin
    if(clk'event and clk='1') then
      hib_we1 <= hib_we;
      hib_data1 <= hib_data;
      hib_we2 <= hib_we1;
      hib_data2 <= hib_data1;
    end if;
  end process;

-- i word counter

  process(iword_dc) begin
    if(iword_dc /= "0000000000000000") then
      ipwon <= '1';
    else
      ipwon <= '0';      
    end if;
  end process;
  
  process(clk) begin
    if(clk'event and clk='1') then
      if(rst = '0') then 
        iword_dc <= "0000000000000000";
      elsif(hib_we1 = '1') then 
        if(iword_dc = "0000000000000000") then
          if(hib_data1(31)='0') then
             iword_dc <= hib_data1(47 downto 32);
             if(hib_data1(30)='0') then
               iflag <= '1';
             else
               iflag <= '0';
             end if;
          end if;
        else
          iword_dc <= iword_dc - "0000000000000001";
        end if;
      end if;
    end if;
  end process;


  process(clk) begin
    if(clk'event and clk='1') then
      if(hib_we1 = '1') then 
        if(iword_dc = "0000000000000000") then
          if((hib_data1(31 downto 30)= "00") or (hib_data1(31 downto 30)= "10")) then
            passflag <= '0';
          else  
            passflag <= '1';
          end if;
        end if;
      end if;
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then 
      if(passflag = '1') then  
        hib_data_buf <= hib_data2;
        hib_we_buf <= hib_we2;
      else
        hib_data_buf <= hib_data_npass;
        hib_we_buf <= hib_we_npass;
      end if;
    end if;
  end process;


-- ip buf
 
 process(clk) begin
    if(clk'event and clk='1') then
      if(ipwon='1' and iflag = '1' and hib_we1 = '1') then
        ififo_wrreq <= '1';
        ififo_data <= hib_data1;
      else
        ififo_wrreq <= '0';        
      end if;
    end if;
  end process;

  nrst <= not rst;
  uififo : pg_scfifo PORT MAP (
		data	 => ififo_data, 
		wrreq	 => ififo_wrreq,
		rdreq	 => ififo_rdreq,
		q	 => ififo_q,
                empty	 => ififo_empty,
                clock	 => clk,
		aclr	 => nrst);

-- status "00" FO read, "01" IP write, "10" N and run     
  
  process(clk) begin
    if(clk'event and clk='1') then
      if(rst = '0') then 
	status <= "00";
      else 	
        if(status = "00") then
          if(hib_we1 ='1' and hib_data1(31 downto 30)="10" and ipwon='0') then
	    status <= "01";
          end if;
        elsif(status = "01") then
          if(ipcnt = "00000001") then
	    status <= "10";
	  end if;
        elsif(status = "10") then
	  if((backend_we_buf1 = '1') and (backend_we_buf = '0')) then
	    if(ififo_empty = '1') then
	      status <= "00";
	    else
	      status <= "01";
            end if;
	  end if;
	end if;
      end if;
      status1 <= status;
      status2 <= status1;
      status3 <= status2;
      status4 <= status3; 	            
    end if;
  end process;

  process(clk) begin
    if(clk'event and clk='1') then
      if(status2 = "01") then
	if((status3 /= "01") and (status2 = "01")) then  
          hib_data_npass <= "0000000000000000" & nd & "00000000000000000000000000000000";
          hib_we_npass <= '1';
	else 
          hib_data_npass <= ififo_q;
          hib_we_npass <= ififo_rdreq1;
	end if;
      elsif(status2 = "10") then
        hib_data_npass <= nrun_data;
        hib_we_npass <= nrun_we;
      else  
        hib_data_npass <= "0000000000000000000000000000000000000000000000000000000000000000";
        hib_we_npass <= '0';
      end if;
    end if;
  end process;

  stat <= status;

--  N and run

  process(clk) begin
    if(clk'event and clk='1') then
      if(hib_we1 ='1' and hib_data1(31 downto 30)="10" and ipwon='0') then
        nd <= hib_data1(63 downto 48);
	nn <= hib_data1(47 downto 32);
      end if;
    end if;
  end process;


--  status IP write
  process(clk) begin
    if(clk'event and clk='1') then  
      if(rst = '0') then
	ipcnt <= "0000000000000000";
      elsif(ipcnt = "0000000000000000") then
        if((status1 /= "01") and (status = "01")) then
	  ipcnt <= nd;
	end if;
      else
	ipcnt <= ipcnt - "0000000000000001";
      end if;
    end if;
  end process;


  process(clk) begin
    if(clk'event and clk='1') then
      if(ipcnt /= "0000000000000000") then 
        ififo_rdreq <= '1';
      else
        ififo_rdreq <= '0';        
      end if;
      ififo_rdreq1 <= ififo_rdreq;
    end if;
  end process;


-- hib_we      __~~~~~~~~_____
-- hib_data    --<      >-----
-- hib_we1       __~~~~~~~~_____
-- hib_data1     --<      >-----
-- iword_dc     -----<><><>-----
-- iflag        _____~~~~~~~~~~~
-- ipon         _____~~~~~~_____
-- hib_we2         __~~~~~~~~_____
-- hib_data2       --<      >-----
-- passflag        --->< 
-- hib_buf         -----><
-- ififo_wrreq     ____~~~~~~______
-- ififo_data      ----<    >------ 
-- nd,nn           -><-------------
-- status       00    ><01    ><10             ><00
-- status1        00    ><01    ><               ><
-- status2          00    ><01    ><               ><
-- status3            00    ><01    ><               ><
-- status4               00   ><01    ><               ><
-- hib_npass                ><      ><
-- ipcnt             ----<><><>----
-- ififo_rdreq       ______~~~~~~____
-- ififo_q           -------><    >-----
-- ififo_rdreq1        ______~~~~~~____
-- + com              -----<>----------
-- nrun_we,data       _________________~~__


--  status N and Run 

  process(clk) begin
    if(clk'event and clk='1') then  
      if((status4 /= "10") and (status3 = "10")) then
	nrun_we <= '1';
	nrun_data <= "0000000000000000" & nn & "10000000000000000000000000000000";
      else
	nrun_we <= '0';
	nrun_data <= "0000000000000000000000000000000000000000000000000000000000000000";
      end if;
    end if;
  end process;

--  FO read

-- status        10><00  
-- status1         10><00  
-- ffifo_rdreq    ______~~~~~~~~________
-- ffifo_q        --------<><><><>-------
-- almost         ____________~~~~~~~~~~~
-- backend_we     ________~~~~~~~~________

--  uffifo : fifo PORT MAP (
--  		data	 => backend_data_buf, 
--  		wrreq	 => backend_we_buf,
--  		rdreq	 => ffifo_rdreq,
--  		q	 => ffifo_q,
--                  almost_empty => almost_empty,
--                  clock	 => clk,
--  		sclr	 => nrst);

  process(clk) begin
    if(clk'event and clk='1') then  
      backend_we_buf1 <= backend_we_buf;
      backend_we <=  backend_we_buf;
      backend_data <= backend_data_buf;
    end if;
  end process;
end rtl;
