library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

-- KFCR board_info register initial value:
--
-- (31:28) product ID      0x1:GRAPE-7 0x2:GRAPE-7E 0x3:GRAPE-DR
-- (27:24) model No        0x1:model100 0x2:model300D 0x3:model300 0x6:model600 
-- (23:20) backend design  0x0:empty 0x1:G5X 0x2:G6X
-- (19:16) not used
-- (15)    P3M cutoff      0x0:not available 0x1:available
-- (14)    eps2 format     0x0:logarithmic 0x1:floating point
-- (13:10) reserved for use in hib entity
-- (9:8)   j-mem size      0x0:2k 0x1:4k 0x2:8k 0x3:16k in particles
-- (7:0)   # of pipes      min:0x00 max:0xff
-- 
entity backend is
  generic(
    -- board info register initial value
    KFCR_PRODUCT_ID    : integer := 0;
    G7_MODEL_NO        : integer := 0;
    G7_BACKEND         : integer := 0;
    P3MCUTOFF          : integer := 0;
    EPS2_IN            : integer := 0;
    J_MEM_SIZE         : integer := 0;
    NPIPES             : integer := 0
  );
  port (
    -- DMA signals
    hib_we             : in std_logic;
    hib_data           : in std_logic_vector(63 downto 0);
    backend_we         : out std_logic;
    backend_data       : out std_logic_vector(63 downto 0);

    -- board info register initial value
    board_info         : out std_logic_vector(31 downto 0);

    -- global signals
    hib_clk            : in std_logic;    -- interface logic
--    backend_clk0       : in std_logic;  -- you can add 3 backend clocks at max
--    backend_clk1       : in std_logic;
--    backend_clk2       : in std_logic;
    rst: in std_logic                     -- reset (negative logic)
    );
end backend;

architecture hierarchy of backend is

begin

  -- the simplest loop back logic
  backend_we   <= hib_we;
  backend_data <= hib_data;

  -- let the interface logic know the value of board info register
  board_info <=
      conv_std_logic_vector(KFCR_PRODUCT_ID, 4) &
      conv_std_logic_vector(G7_MODEL_NO, 4) &
      conv_std_logic_vector(G7_BACKEND, 4) &
      conv_std_logic_vector(0, 4) &
      conv_std_logic_vector(P3MCUTOFF, 1) &
      conv_std_logic_vector(EPS2_IN, 1) &
      conv_std_logic_vector(0, 2) &
      conv_std_logic_vector(0, 2) &
      conv_std_logic_vector(J_MEM_SIZE, 2) &
      conv_std_logic_vector(NPIPES, 8);
  
end hierarchy;
