--
-- template: pg_comp_int/float/log
--
-- <DELAY=1>
--
-- <$w1>-bit int/float/log comparator
--
-- int   : int (2's complement)
-- float : sign exponent mantissa
-- log   : sign exponent mantissa
--
-- output is 1 if:
-- alb   aeb    agb   ageb   aneb    aleb
-- a<b   a==b   a>b   a>=b   a!=b    a<=b
--
--
library ieee;
use ieee.std_logic_1164.all;

entity <$mname> is
  port (srca       : in  std_logic_vector(<$w1-1> downto 0);
        srcb       : in  std_logic_vector(<$w2-1> downto 0);
        dst_alb    : out std_logic;
        dst_aeb    : out std_logic;
        dst_agb    : out std_logic;
        dst_ageb   : out std_logic;
        dst_aneb   : out std_logic;
        dst_aleb   : out std_logic;
        clk        : in  std_logic);
end <$mname>;

architecture rtl of <$mname> is

  component lpm_compare
    generic (LPM_WIDTH     : integer;
             LPM_PIPELINE  : integer
    );
    port (dataa : in  std_logic_vector(LPM_WIDTH-1 downto 0);
          datab : in  std_logic_vector(LPM_WIDTH-1 downto 0);
          clock : in  std_logic;
          alb   : out std_logic;
          aeb   : out std_logic;
          agb   : out std_logic;
          ageb  : out std_logic;
          aneb  : out std_logic;
          aleb  : out std_logic
    );
  end component;

  signal signab0, signab1 : std_logic;
  signal alb1, aeb1, agb1, ageb1, aneb1, aleb1 : std_logic;

begin

  signab0 <= srca(<$w1-1>) & srcb(<$w2-1>);
  process(clk)
  begin
    if (clk'event and clk='1') then
      signab1 <= signab0;
    end if;
  end process;
  
  u1: lpm_compare
    generic map (LPM_WIDTH    => <$w1-1>,
                 LPM_PIPELINE => 1
    )
    port map (dataa => srca(<$w1-2> downto 0),  -- compare exp & man
              datab => srcb(<$w2-2> downto 0),
              clock => clk,
              alb   => alb1,
              aeb   => aeb1,
              agb   => agb1,
              ageb  => ageb1,
              aneb  => aneb1,
              aleb  => aleb1
    );

  with signab1 select
    dst_alb <= alb1     when "00",
           '0'      when "01",
           '1'      when "10",
           not alb1 when "11";

  with signab1 select
    dst_aleb <= aleb1     when "00",
            '0'       when "01",
            '1'       when "10",
            not aleb1 when "11";

  with signab1 select
    dst_agb <= agb1     when "00",
           '1'      when "01",
           '0'      when "10",
           not agb1 when "11";

  with signab1 select
    dst_ageb <= ageb1     when "00",
            '1'       when "01",
            '0'       when "10",
            not ageb1 when "11";

  with signab1 select
    dst_aeb <= aeb1  when "00",
            '0'  when "01",
            '0'  when "10",
            aeb1 when "11";

  with signab1 select
    dst_aneb <= aneb1 when "00",
            '1'   when "01",
            '1'   when "10",
            aneb1 when "11";

end rtl;
