--
-- template: pg_conv_int_to_int
--
-- <DELAY=0>
--
-- convert a <$w1>-bit int to a <$w2>-bit one.
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity <$mname> is
  port (src    : in  std_logic_vector(<$w1-1> downto 0);
        dst    : out std_logic_vector(<$w2-1> downto 0);
        clk    : in  std_logic);
end <$mname>;

architecture rtl of <$mname> is

  component round_ubf1
    generic (IN_WIDTH   : integer;
             OUT_WIDTH  : integer
             );
    port (indata  : in  std_logic_vector(IN_WIDTH-1 downto 0);
          outdata : out std_logic_vector(OUT_WIDTH-1 downto 0)
          );
  end component;

  signal sign0 : std_logic;
  signal src0  : std_logic_vector(<$w1-1> downto 0);
  signal dst0  : std_logic_vector(<$w2-1> downto 0);

begin

  src0  <= src;
  sign0 <= src(<$w1-1>);

  <PG2>
    {
        my $outtext = q{};

        if ($w1 == $w2) {
            $outtext .= sprintf("dst0 <= src0;\n\n");
        }
        
        if ($w1 > $w2) {
            $outtext .= sprintf("dst0 <= src0(%d downto 0);\n\n", $w2 - 1);
        }

        if ($w1 < $w2) {
            $outtext .= sprintf("dst0(%d downto 0) <= src0;\n", $w1 - 1);
            for my $i ($w1 .. $w2-1) {
                $outtext .= "  dst0($i) <= sign0;\n";
            }    
            $outtext .= sprintf("\n");
        }

        return $outtext;
    }
  </PG2>
      
  dst <= dst0;

end rtl;
