--
-- template: pg_conv_log_to_float
--
-- <DELAY=2>
--
-- convert a <$w1>-bit log to a <$w2>-bit floationg-point.
-- using a table <$tablefilename>.
--
-- log:
-- 1     <$w1-$m1-1>            <$m1>
-- sign  exponent     mantissa
--
-- float:
-- 1     <$w2-$m2-1>            <$m2>
-- sign  exponent     mantissa
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity <$mname> is
  port (src    : in  std_logic_vector(<$w1-1> downto 0);
        dst    : out std_logic_vector(<$w2-1> downto 0);
        clk    : in  std_logic);
end <$mname>;

architecture rtl of <$mname> is

  component table_reg
    generic (IN_WIDTH   : integer ;
             OUT_WIDTH  : integer ;
             TABLE_FILE : string);
    port (indata : in  std_logic_vector(IN_WIDTH-1 downto 0);
         outdata : out std_logic_vector(OUT_WIDTH-1 downto 0);
         clk     : in  std_logic);
  end component;

  signal sign0, sign1, sign2 : std_logic;
  signal nz1, nz2            : std_logic;
  signal e0, e1              : std_logic_vector(<$e1-1> downto 0);
  signal e2                  : std_logic_vector(<$e2-1> downto 0);
  signal m0                  : std_logic_vector(<$m1-1> downto 0);
  signal m2                  : std_logic_vector(<$m2-1> downto 0);
  signal dst2                : std_logic_vector(<$w2-1> downto 0);

begin

  sign0 <= src(<$w1-1>);
  e0    <= src(<$w1-2> downto <$m1>);        -- exponent
  m0    <= src(<$m1-1> downto 0);        -- mantissa

  -- sign
  process(clk)
  begin
    if(clk'event and clk='1') then
      sign1 <= sign0;
      sign2 <= sign1;
    end if;
  end process;

  -- non zero
  process(clk)
  begin
    if(clk'event and clk='1') then
      if (src(<$w1-2> downto 0) = conv_std_logic_vector(0, <$w1-1>)) then
        nz1 <= '0';
      else
        nz1 <= '1';
      end if;
      nz2 <= nz1;
    end if;
  end process;

  -- exponent
  process(clk)
  begin
    if(clk'event and clk='1') then
      e1 <= e0 - ('1' & conv_std_logic_vector(0, <$e1-1>));  -- remove offset
      e2 <= (conv_std_logic_vector(0, <$e2-$e1>) & e1) + ('1' & conv_std_logic_vector(0, <$e2-1>));  -- add offset
    end if;
  end process;
  
  u1: table_reg
    generic map (IN_WIDTH   => <$m1>,
                 OUT_WIDTH  => <$m2>,
                 TABLE_FILE => <$tablefilename>)
    port map (indata  => m0,
              outdata => m2,  -- 2-clk delay
              clk     => clk);

  dst2(<$w2-1>)              <= sign2;
  dst2(<$w2-2> downto <$m2>) <= e2;
  dst2(<$m2-1> downto 0)     <= m2;

  with nz2 select
    dst <=
      dst2                            when '1',
      conv_std_logic_vector(0, <$w2>) when others;

end rtl;
