--
-- template: pg_conv_log_to_log
--
-- <DELAY=0>
--
-- convert a <$w1>-bit log to a <$w2>-bit one.
-- mantissa is rounded by unbiased force-1 if <$m1> > <$m2>.
-- (I know actually this is biased, but I don't have any better idea).
--
-- src log:
-- 1     <$w1-$m1-1>            <$m1>
-- sign  exponent     mantissa
--
-- dst log:
-- 1     <$w2-$m2-1>            <$m2>
-- sign  exponent     mantissa
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity <$mname> is
  port (src    : in  std_logic_vector(<$w1-1> downto 0);
        dst    : out std_logic_vector(<$w2-1> downto 0);
        clk    : in  std_logic);
end <$mname>;

architecture rtl of <$mname> is

  component round_ubf1
    generic (IN_WIDTH   : integer;
             OUT_WIDTH  : integer
             );
    port (indata  : in  std_logic_vector(IN_WIDTH-1 downto 0);
          outdata : out std_logic_vector(OUT_WIDTH-1 downto 0)
          );
  end component;

  signal ssrc0 : std_logic;
  signal esrc0 : std_logic_vector(<$w1-$m1-2> downto 0);
  signal msrc0 : std_logic_vector(<$m1-1> downto 0);

  signal sdst0 : std_logic;
  signal edst0 : std_logic_vector(<$w2-$m2-2> downto 0);
  signal mdst0 : std_logic_vector(<$m2-1> downto 0);

begin

  ssrc0 <= src(<$w1 - 1>);
  esrc0 <= src(<$w1 - 2> downto <$m1>);
  msrc0 <= src(<$m1 - 1> downto 0);

  -- sign
  sdst0 <= ssrc0;

  -- exponent
  <PG2>
    {
        my $outtext = q{};

        if ($w1 - $m1 > $w2 - $m2) {
            warn("Error: cannot convert log$w1.$m1 to log$w2.$m2.\n" .
                 "       width of source's exponent (" . ($w1 - $m1 - 1) . ") is wider than " .
                         "destination's(" . ($w2 - $m2 - 1) . ").\n");
            return q{};
        }

        if ($w1 - $m1 < $w2 - $m2) {
            $outtext .= sprintf("edst0 <= (conv_std_logic_vector(0, %d) & esrc0) + \n" .
                                "           ('1' & conv_std_logic_vector(0, %d)) - \n" .
                                "           (conv_std_logic_vector(0, %d) & '1' & conv_std_logic_vector(0, %d));\n",
                                ($w2 - $m2) - ($w1 - $m1),
                                $w2 - $m2 - 2,
                                ($w2 - $m2) - ($w1 - $m1),
                                ($w1 - $m1 - 2));
        }
        elsif ($w1 - $m1 == $w2 - $m2) {
            $outtext .= sprintf("edst0 <= esrc0;\n\n");
        }

        return $outtext;
    }
  </PG2>
          
  -- mantissa
  <PG2>
    {
        my $outtext = q{};
        
        if ($m1 < $m2) {
            $outtext .= sprintf("mdst0 <= msrc0(%d downto 0) & " .
                                "conv_std_logic_vector(0, %d);\n\n",
                                $m1 - 1, $m2 - $m1);
        }
        elsif ($m1 == $m2) {
            $outtext .= sprintf("mdst0 <= msrc0;\n\n");
        }
        else {
            $outtext .= sprintf("u1: round_ubf1         -- force-1 rounding\n");
            $outtext .= sprintf("  generic map (IN_WIDTH  => <$m1>,\n");
            $outtext .= sprintf("               OUT_WIDTH => <$m2>\n");
            $outtext .= sprintf("  )\n");
            $outtext .= sprintf("  port map (indata  => msrc0,\n");
            $outtext .= sprintf("            outdata => mdst0\n");
            $outtext .= sprintf("  );\n\n");
        }

        return $outtext;
    }
  </PG2>
      
  dst(<$w2 - 1>)              <= sdst0;
  dst(<$w2 - 2> downto <$m2>) <= edst0;           -- exponent
  dst(<$m2 - 1> downto 0)     <= mdst0;           -- mantissa

end rtl;
