--
-- template: pg_inc_int
--
-- <DELAY=2>
--
-- <$w1>-bit to <$w2>-bit int accumulator
--
-- src: <$w1>-bit int
-- dst: <$w2>-bit int
--
-- clk      _|~|_|~|_|~|_|~|_|~|_|~|_|~|_|~|_|~|_|~|_|~|_|~|
-- srclow      [0 ][L0][L1][L2][L3]
-- cin     [ 0                                              ]
-- run     _____|~~~~~~~~~~~~~~|_____________________________
-- rund    _________|~~~~~~~~~~~~~~|_________________________
-- reg0             [0 ][L0][L1][L2][L3]
-- cout                 [C0][C1][C2][C3]
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
-- srchigh          [0 ][H0][H1][H2][H3]
-- cin                  [C0][C1][C2][C3]
-- run     _________|~~~~~~~~~~~~~~|_________________________
-- rund        _________|~~~~~~~~~~~~~~|_________________________
-- reg0                 [0 ][H0][H1][H2][H3]
--
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity <$mname> is
  port (src  : in  std_logic_vector(<$w1-1> downto 0);
        dst  : out std_logic_vector(<$w2-1> downto 0);
        run  : in  std_logic;
        clk  : in  std_logic);
end <$mname>;

architecture rtl of <$mname> is

  component inc_first_<$mid>
    generic (WIDTH : integer);
    port (indata   : in  std_logic_vector(WIDTH-1 downto 0);
          cin      : in  std_logic;
          run      : in  std_logic;
          rund     : out std_logic;
          cout     : out std_logic;
          outdata  : out std_logic_vector(WIDTH-1 downto 0);
          clk      : in  std_logic);
  end component;

  component inc_last_<$mid>
    generic (WIDTH : integer);
    port (indata   : in  std_logic_vector(WIDTH-1 downto 0);
          cin      : in  std_logic;
          run      : in  std_logic;
          outdata  : out std_logic_vector(WIDTH-1 downto 0);
          clk      : in  std_logic);
  end component;

  signal src0            : std_logic_vector(<$w2-1> downto 0);
  signal srclow0         : std_logic_vector(<int($w2/2)-1> downto 0);
  signal srchigh0        : std_logic_vector(<$w2 - int($w2/2) - 1> downto 0);
  signal srchigh1        : std_logic_vector(<$w2 - int($w2/2) - 1> downto 0);
  signal rsig            : std_logic_vector(1 downto 0);
  signal carry           : std_logic_vector(1 downto 0);
  signal dstlow1,dstlow2 : std_logic_vector(<int($w2/2) - 1> downto 0);
  signal dsthigh2        : std_logic_vector(<$w2-1> downto <int($w2/2)>);
  
begin

--  src0 <= conv_std_logic_vector(0, <$w2 - $w1 + 1>) & src(<$w1 - 2> downto 0);
  -- extend to width of 'dst' using sign-bit of src.
  <PG2>
    {
        my $outtext;
        $outtext = sprintf("src0(%d downto 0) <= src;\n", $w1 - 1);

        for my $i ($w1 .. $w2 - 1) {
            $outtext .= sprintf("  src0($i) <= src(%d);\n", $w1 - 1);
        }
        return $outtext;
    }
  </PG2>

  srclow0    <= src0(<int($w2/2) - 1> downto 0);
  srchigh0   <= src0(<$w2-1> downto <int($w2/2)>);

--  carry(0)  <=     src(<$w1-1>);
  carry(0)  <= '0';                     -- should always be 0.
  rsig(0)   <= run;

  process(clk)
  begin
    if (clk'event and clk='1') then
      srchigh1 <= srchigh0;
    end if;
  end process;

  u0: inc_first_<$mid>
    generic map (WIDTH => <int($w2/2)>)
    port map (indata  => srclow0,
              cin     => carry(0),
              run     => rsig(0),
              rund    => rsig(1),
              cout    => carry(1),
              outdata => dstlow1(<int($w2/2) - 1> downto 0),
              clk     => clk);

  u1: inc_last_<$mid>
    generic map (WIDTH => <$w2 - int($w2/2)>)
    port map(indata  => srchigh1,
             cin     => carry(1),
             run     => rsig(1),
             outdata => dsthigh2(<$w2-1> downto <int($w2/2)>),
             clk     => clk);


  process(clk)
  begin
    if (clk'event and clk='1') then
      dstlow2 <= dstlow1;
    end if;
  end process;

  dst <= dsthigh2 & dstlow2;
  
end rtl;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity inc_first_<$mid> is
  generic (WIDTH : integer);
  port (indata : in  std_logic_vector(WIDTH-1 downto 0);
       cin     : in  std_logic;
       run     : in  std_logic;
       rund    : out std_logic;
       cout    : out std_logic;
       outdata : out std_logic_vector(WIDTH-1 downto 0);
       clk     : in  std_logic);
end inc_first_<$mid>;

architecture rtl of inc_first_<$mid> is

  component lpm_add_sub
    generic (LPM_WIDTH          : integer;
             LPM_DIRECTION      : string
    );
    port (dataa   : in  std_logic_vector(LPM_WIDTH-1 downto 0);
          datab   : in  std_logic_vector(LPM_WIDTH-1 downto 0);
          cin     : in  std_logic;
          cout    : out std_logic;
          result  : out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

signal addout   : std_logic_vector(WIDTH-1 downto 0);
signal run1     : std_logic;
signal cout0    : std_logic;
signal reg0 : std_logic_vector(WIDTH-1 downto 0);

begin

  process (clk)
  begin
    if (clk'event and clk='1') then
      if(run1 = '1') then
        reg0 <= addout;             -- intake (reg0 + indata + cin)
      else
        if(run = '1') then
          reg0 <= (others => '0');  -- clear
        end if;
      end if;
    end if;
  end process;

  outdata <= reg0;

  u1: lpm_add_sub
      generic map (LPM_WIDTH => WIDTH,
                   LPM_DIRECTION => "ADD")
      port map (dataa   => reg0,
                datab   => indata,
                cin     => cin,
                cout    => cout0,
                result  => addout);

  process (clk)
  begin
    if (clk'event and clk='1') then
      run1 <= run;
    end if;
  end process;

  rund <= run1;

  process (clk)
  begin
    if (clk'event and clk='1') then
      cout    <= cout0;
    end if;
  end process;

end rtl;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity inc_last_<$mid> is
  generic (WIDTH : integer);
  port (indata : in  std_logic_vector(WIDTH-1 downto 0);
       cin     : in  std_logic;
       run     : in  std_logic;
       outdata : out std_logic_vector(WIDTH-1 downto 0);
       clk     : in  std_logic);
end inc_last_<$mid>;

architecture rtl of inc_last_<$mid> is

  component lpm_add_sub
    generic (LPM_WIDTH          : integer;
             LPM_DIRECTION      : string
    );
    port (dataa   : in  std_logic_vector(LPM_WIDTH-1 downto 0);
          datab   : in  std_logic_vector(LPM_WIDTH-1 downto 0);
          cin     : in  std_logic;
          result  : out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

signal addout : std_logic_vector(WIDTH-1 downto 0);
signal run1   : std_logic;
signal reg0 : std_logic_vector(WIDTH-1 downto 0);

begin

  process (clk)
  begin
    if (clk'event and clk='1') then
      if (run1 = '1') then
        reg0 <= addout;
      else
        if (run = '1') then
          reg0 <= (others => '0');
        end if;
      end if;
    end if;
  end process;

  outdata <= reg0;

  u1: lpm_add_sub
      generic map (LPM_WIDTH => WIDTH,
                   LPM_DIRECTION => "ADD")
      port map (dataa   => reg0,
                datab   => indata,
                cin     => cin,
                result  => addout);

  process (clk)
  begin
    if (clk'event and clk='1') then
      run1 <= run;
    end if;
  end process;

end rtl;
