--
-- template: pg_mul_int
--
-- <DELAY=2>
--
-- <$w1>-bit int multiplier
--
-- srca: <$w1>-bit int
-- srcb: <$w2>-bit int
-- dst:  <$w3>-bit int
--
-- this implementation assumes use of embedded multiplier,
-- and thus is specific to CycloneII, Stratix, or StratixII.
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity <$mname> is
  port (srca   : in  std_logic_vector(<$w1-1> downto 0);
        srcb   : in  std_logic_vector(<$w2-1> downto 0);
        dst    : out std_logic_vector(<$w3-1> downto 0);
        clk    : in  std_logic);
end <$mname>;

architecture rtl of <$mname> is

  component mul_int2
    generic (
      WIDTHA : integer;
      WIDTHB : integer;
      DELAY  : integer
    );
    port
    (clock        : in  std_logic;
     dataa        : in  std_logic_vector(WIDTHA - 1 downto 0);
     datab        : in  std_logic_vector(WIDTHB - 1 downto 0);
     result       : out std_logic_vector(WIDTHA + WIDTHB - 1 downto 0)
    );
  end component;

  component round_ubf1
    generic (IN_WIDTH   : integer;
             OUT_WIDTH  : integer
    );
    port (indata  : in  std_logic_vector(IN_WIDTH-1 downto 0);
          outdata : out std_logic_vector(OUT_WIDTH-1 downto 0)
    );
  end component;

  signal x0        :  std_logic_vector(<$w1 - 1> downto 0);
  signal y0        :  std_logic_vector(<$w2 - 1> downto 0);
  signal xy1       :  std_logic_vector(<$w1 + $w2 - 1> downto 0);
  signal xy1a, xy2 :  std_logic_vector(<$w3 - 1> downto 0);

begin

  x0 <= srca;
  y0 <= srcb;
  
  u1: mul_int2
    generic map (
      WIDTHA => <$w1>,
      WIDTHB => <$w2>,
      DELAY  => 1
    )
    port map (
      clock  => clk,
      result => xy1,
      dataa  => x0,
      datab  => y0);

  u2: round_ubf1
    generic map (IN_WIDTH  => <$w1 + $w2>,
                 OUT_WIDTH => <$w3>
    )
    port map (indata  => xy1,
              outdata => xy1a
    );

  process(clk)
  begin
    if(clk'event and clk='1') then
      xy2 <= xy1a;
    end if;
  end process;

  dst <= xy2;

end rtl;
