--
-- template: pg_mul_log
--
-- <DELAY=2>
--
-- <$w1>-bit logarithmic multiplier
--
-- srca, srcb, dst
-- log:
-- 1     <$e1>        <$m1>
-- sign  exponent     mantissa
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity <$mname> is
  port (srca   : in  std_logic_vector(<$w1-1> downto 0);
        srcb   : in  std_logic_vector(<$w2-1> downto 0);
        dst    : out std_logic_vector(<$w3-1> downto 0);
        clk    : in  std_logic);
end <$mname>;

architecture rtl of <$mname> is

  component lpm_add_sub
    generic (LPM_WIDTH     : integer;
             LPM_PIPELINE  : integer;
             LPM_DIRECTION : string
    );
    port (dataa : in  std_logic_vector(LPM_WIDTH-1 downto 0);
          datab : in  std_logic_vector(LPM_WIDTH-1 downto 0);
          clock : in  std_logic;
          result: out std_logic_vector(LPM_WIDTH-1 downto 0)
    );
  end component;

  signal nz1, nz2            : std_logic;
  signal signx0, signy0      : std_logic;
  signal signz1, signz2      : std_logic;
  signal addx0, addy0, addz1 : std_logic_vector(<$w1-2> downto 0);
  signal expz1, expz2        : std_logic_vector(<$e1-1> downto 0);
  signal manz1, manz2        : std_logic_vector(<$m1-1> downto 0);

begin

  signx0 <= srca(<$w1-1>);
  addx0  <= srca(<$w1-2> downto 0);

  signy0 <= srcb(<$w2-1>);
  addy0  <= srcb(<$w2-2> downto 0);

  -- sign bit
  process(clk)
  begin
    if (clk'event and clk='1') then
      signz1 <= signx0 xor signy0;
      signz2 <= signz1;
    end if;
  end process;

  -- non-zero
  process(clk)
  begin
    if (clk'event and clk='1') then
      if (addx0(<$w1-2> downto 0) = conv_std_logic_vector(0, <$w1-1>) or
          addy0(<$w2-2> downto 0) = conv_std_logic_vector(0, <$w2-1>)) then
        nz1 <= '0';
      else
        nz1 <= '1';
      end if;
      nz2 <= nz1;
    end if;
  end process;
  
  u1: lpm_add_sub
    generic map (LPM_WIDTH     => <$w1-1>,
                 LPM_PIPELINE  => 1,
                 LPM_DIRECTION => "ADD"
    )
    port map (clock  => clk,
              dataa  => addx0,
              datab  => addy0,
              result => addz1
    );

  expz1 <= addz1(<$w1-2> downto <$m1>);
  manz1 <= addz1(<$m1-1> downto 0);
  
  process(clk)
  begin
    if (clk'event and clk='1') then
      expz2 <= expz1 - ('1' & conv_std_logic_vector(0, <$e1-1>));  -- remove offset
      manz2 <= manz1;
    end if;
  end process;

  with nz2 select
    dst <=
      signz2 & expz2 & manz2 when '1',
      conv_std_logic_vector(0, <$w1>) when others;

end rtl;
