library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity pg_pipe is
    generic(
        JDATA_WIDTH : integer;
        NPIPES      : integer
    );
    port(
        p_jdata     : in  std_logic_vector(JDATA_WIDTH-1 downto 0);
        p_run       : in  std_logic;
        p_we        : in  std_logic;
        p_adri      : in  std_logic_vector(11+4 downto 0);
        p_datai     : in  std_logic_vector(63 downto 0);
        p_adro      : in  std_logic_vector(11+4 downto 0);
        p_datao     : out std_logic_vector(63 downto 0);
        p_runret    : out std_logic;
        p_bcast     : in  std_logic;
        p_cid       : in  std_logic_vector(2 downto 0);
        rst         : in  std_logic;
        clk         : in  std_logic
    );
end pg_pipe;

architecture std of pg_pipe is

    component pipe
        generic(
                JDATA_WIDTH : integer;
                PIPELINE_DELAY : integer := <DELAY>
        );
        port(
            p_jdata  : in std_logic_vector(JDATA_WIDTH-1 downto 0);
            p_run    : in std_logic;
            p_we     : in std_logic;
            p_adri   : in std_logic_vector(3+4 downto 0);
            p_adrivp : in std_logic_vector(3 downto 0);
            p_datai  : in std_logic_vector(63 downto 0);
            p_adro   : in std_logic_vector(3+4 downto 0);
            p_adrovp : in std_logic_vector(3 downto 0);
            p_datao  : out std_logic_vector(63 downto 0);
            p_runret : out std_logic;
            p_bcast  : in std_logic;
            p_cid    : in  std_logic_vector(2 downto 0);
            rst      : in std_logic;
            pclk     : in std_logic
        );
    end component;

    signal u_adri, u_adro, u_adror : std_logic_vector(7 downto 0);
    signal adrivp, adrovp          : std_logic_vector(3 downto 0);
    signal we, runret              : std_logic_vector(NPIPES-1 downto 0);
    signal datao                   : std_logic_vector(NPIPES * 64 - 1 downto 0);
    signal l_adro, l_adri          : std_logic_vector(3+4 downto 0);

begin

    u_adri <= p_adri(11+4 downto 4+4);
    l_adri <= p_adri(3+4 downto 0);
    u_adro <= p_adro(11+4 downto 4+4);
    l_adro <= p_adro(3+4 downto 0);

    for_we: for i in 0 to NPIPES-1 generate
        process (u_adri,p_we) begin
            if (p_we = '1') then
                if (u_adri = conv_std_logic_vector(i, 8)) then
                    we(i) <= '1';
                else
                    we(i) <= '0';
                end if;
            else
                we(i) <= '0';
            end if;
        end process;
    end generate for_we;

    with u_adri select
        adrivp <= "0000" when "00000000",
                  "0000" when others;

    with u_adro select
        adrovp <= "0000" when "00000000",
                  "0000" when others;

    for_pipe: for i in 0 to NPIPES-1 generate
        upipe: pipe
            generic map(JDATA_WIDTH => JDATA_WIDTH)
            port map(p_jdata  => p_jdata,
                     p_run    => p_run,
                     p_we     => we(i),
                     p_adri   => l_adri,
                     p_adrivp => adrivp,
                     p_datai  => p_datai,
                     p_adro   => l_adro,
                     p_adrovp => adrovp,
                     p_datao  => datao(64*(i+1)-1 downto 64*i),
                     p_runret => runret(i),
                     p_bcast  => p_bcast,
                     p_cid    => p_cid,
                     rst      => rst,
                     pclk     => clk
            );
    end generate for_pipe;

    p_runret <= runret(0);

    process (clk) begin
        if (clk'event and clk='1') then
            u_adror <= u_adro;
        end if;
    end process;

    with u_adror select
        p_datao <=
<DATAO>        datao(63 downto 0) when others;

end std;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity pipe is
    generic(JDATA_WIDTH    : integer;
            PIPELINE_DELAY : integer
    );
    port(p_jdata  : in  std_logic_vector(JDATA_WIDTH-1 downto 0);
         p_run    : in  std_logic;
         p_we     : in  std_logic;
         p_adri   : in  std_logic_vector(3+4 downto 0);
         p_adrivp : in  std_logic_vector(3 downto 0);
         p_datai  : in  std_logic_vector(63 downto 0);
         p_adro   : in  std_logic_vector(3+4 downto 0);
         p_adrovp : in  std_logic_vector(3 downto 0);
         p_datao  : out std_logic_vector(63 downto 0);
         p_runret : out std_logic;
         p_bcast  : in  std_logic;
         p_cid    : in  std_logic_vector(2 downto 0);
         rst      : in  std_logic;
         pclk     : in  std_logic
    );
end pipe;

architecture std of pipe is

<TYPEDEF>
<COMPONENT>
    signal run                  : std_logic_vector(PIPELINE_DELAY-1 downto 0);
    signal cid                  : std_logic_vector(2 downto 0);
<SIGNAL>
begin

    cid <= <CID>

    -- JPIN: JDATA_WIDTH-bit width x JDATA_DEPTH-bit depth
<JPSET>
    -- IPIN: 64-bit width x 4-bit depth
    process (pclk)
    begin
        if (pclk'event and pclk='1') then
            if (p_we ='1') then
<IPSET>                end if;
            end if;
        end if;
    end process;

<COEFFSET>

    process (pclk)
    begin
        if (pclk'event and pclk='1') then
            run(0) <= p_run;
            for i in 0 to PIPELINE_DELAY-2 loop
                run(i+1) <= run(i);
            end loop;
            p_runret <= run(PIPELINE_DELAY-1);
        end if;
    end process;

<INSTANCE>
    -- FOUT: 64-bit width x 8-bit depth
    process (pclk)
    begin
        if (pclk'event and pclk='1') then
<FOUT>            else
                p_datao <= conv_std_logic_vector(0, 64);
            end if;
        end if;
    end process;

<ADDITIONALLOGIC>
end std;
