--
-- template: pg_shift_float/log
--
-- <DELAY=1>
--
-- shift a <$w1>-bit float or log to the left/right,
-- by adding/subtracting 'shift'-bit to/from the exponent.
--
-- src:
-- float/log/int
-- 1     <$w1-$m1-1>           <$m1>
-- sign  exponent     mantissa
--
-- shift:
-- <$w2>-bit int
--
-- dst
-- float/log:
-- 1     <$w3-$m3-1>            <$m3>
-- sign  exponent     mantissa
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity <$mname> is
  generic (ADDSUB : string);
  port (src    : in  std_logic_vector(<$w1-1> downto 0);
        shift  : in  std_logic_vector(<$w2-1> downto 0);
        dst    : out std_logic_vector(<$w3-1> downto 0);
        clk    : in  std_logic);
end <$mname>;

architecture rtl of <$mname> is

  component lpm_add_sub
    generic (LPM_WIDTH          : integer;
             LPM_DIRECTION      : string;
             LPM_REPRESENTATION : string := "UNSIGNED");
    port (dataa, datab : in std_logic_vector(LPM_WIDTH-1 downto 0);
          cout         : out std_logic;
          result       : out std_logic_vector(LPM_WIDTH-1 downto 0));
  end component;

  signal s1          : std_logic;
  signal nz0, nz1    : std_logic;
  signal shift0      : std_logic_vector(<$w1 - $m1 - 2> downto 0);
  signal e0, e0a, e1 : std_logic_vector(<$w1 - $m1 - 2> downto 0);
  signal m0, m1      : std_logic_vector(<$m1 - 1> downto 0);

begin
  e0     <= src(<$w1 - 2> downto <$m1>);
  m0     <= src(<$m1 - 1> downto 0);
  shift0 <= conv_std_logic_vector(0, <($w1 - $m1 - 1) - $w2>) & shift;
    
  u0: lpm_add_sub
    generic map (
      LPM_WIDTH     => <$w1 - $m1 - 1>,
      LPM_DIRECTION => ADDSUB)
    port map(result => e0a,
             dataa  => e0,
             datab  => shift0);

  process(clk)
  begin
    if (clk'event and clk='1') then
      s1  <= src(<$w1-1>);
      e1  <= e0a;
      m1  <= m0;
      nz1 <= nz0;
    end if;
  end process;

  with src(<$w1-2> downto 0) select
    nz0 <=
    '0' when conv_std_logic_vector(0, <$w1-1>),
    '1' when others;
  
  with nz1 select
    dst <=
    s1 & e1 & m1 when '1',
    conv_std_logic_vector(0, <$w3>) when others;

end rtl;
