--
-- template: pg_sqrt_log_log
--
-- <DELAY=2>
--
-- calculate square root of
-- <$w1>-bit logarithmic. input should be positive.
--
-- src, dst
-- log:
-- 1     <$e1>        <$m1>
-- sign  exponent     mantissa
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity <$mname> is
  port (src : in  std_logic_vector(<$w1-1> downto 0);
        dst : out std_logic_vector(<$w2-1> downto 0);
        clk : in  std_logic
  );
end <$mname>;

architecture rtl of <$mname> is

  signal sign0, sign1 : std_logic;
  signal nz1, nz2     : std_logic;
  signal exp0, exp1   : std_logic_vector(<$e1-1> downto 0);
  signal man0, man1   : std_logic_vector(<$m1-1> downto 0);
  signal dst1, dst2   : std_logic_vector(<$w2-1> downto 0);

begin

  sign0 <= src(<$w1-1>);
  exp0  <= src(<$w1-2> downto <$m1>);
  man0  <= src(<$m1-1> downto 0);  

  -- sign
  process(clk) begin
    if (clk'event and clk='1') then
      sign1 <= sign0;
    end if;
  end process;

  -- non-zero
  process(clk)
  begin
    if (clk'event and clk='1') then
      if (src(<$w1-2> downto 0) = conv_std_logic_vector(0, <$w1-1>)) then
        nz1 <= '0';
      else
        nz1 <= '1';
      end if;
      nz2 <= nz1;
    end if;
  end process;

  -- exponent
  process(clk)
  begin
    if (clk'event and clk='1') then
      exp1 <= exp0 - ('1' & conv_std_logic_vector(0, <$e1-1>));  -- remove offset
    end if;
  end process;

  -- mantissa
  process(clk)
  begin
    if (clk'event and clk='1') then
      man1 <= man0;
    end if;
  end process;

  -- shift 1-bit to the left to obtain square root.
  dst1 <= sign1 & '0' & exp1 & man1(<$m1-1> downto 1);

  process(clk)
  begin
    if (clk'event and clk='1') then
      dst2(<$w2-1>)              <= dst1(<$w1-1>);
      dst2(<$w2-2> downto <$m2>) <= dst1(<$w1-2> downto <$m1>) +
                                   ('1' & conv_std_logic_vector(0, <$e1-1>));  -- add offset
      dst2(<$m2-1> downto 0)     <= dst1(<$m1-1> downto 0);  
    end if;
  end process;

  with nz2 select
    dst <=
      dst2 when '1',
      conv_std_logic_vector(0, <$w1>) when others;

end rtl;
