--
-- template: pg_store
--
-- <DELAY=0>
--
-- take in WIDTH-bit data from src if we='1' and id=ID.
-- clear at the rising edge of run
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity <$mname> is
  generic (WIDTH     : integer;
           DEPTH     : integer;
           STORAGEID : integer
  );
  port (src   : in  std_logic_vector(WIDTH-1 downto 0);
        dst   : out std_logic_vector(WIDTH-1 downto 0);
        we    : in  std_logic;
        id    : in  std_logic_vector(DEPTH-1 downto 0);
        run   : in  std_logic;
        clk   : in  std_logic
  );
end <$mname>;

architecture std of pg_store is

  signal run0, run1 : std_logic;

begin

    run0 <= run;

    process (clk)
    begin
        if (clk'event and clk='1') then
            run1 <= run0;
        end if;
    end process;

    process (clk)
    begin
        if (clk'event and clk='1') then
            if (run1 = '1') then
                if (we = '1' and id = conv_std_logic_vector(STORAGEID, DEPTH)) then
                    dst <= src;
                end if;
            elsif (run0 = '1') then
                dst <= (others => '0');
            end if;
        end if;
    end process;
end std;
