#ifndef <LIBNAME>_H
#define <LIBNAME>_H
#include "pgemu.h"

#define NHIB 1

/* constant definitions */
#if !defined(__LANGUAGE_FORTRAN__) && !defined(_LANGUAGE_FORTRAN)

#if defined(__cplusplus)
extern "C"
{
#endif

    /* C interface */

    /*
     * standard functions
     * (the number of the cards is hidden to the user)
     */

    void   <prefix>_open(void);
    void   <prefix>_close(void);
<FOUND_COEFFSET>
    void   <prefix>_set_coeff(<COEFFARGS>);
</FOUND_COEFFSET>
<FOUND_JPSET>
    void   <prefix>_set_jp(int adr, int nj, <JPARGS>);
</FOUND_JPSET>
<FOUND_IPSET>
    void   <prefix>_set_ip(int ni, <IPARGS>);
</FOUND_IPSET>
    void   <prefix>_run(void);
    void   <prefix>_set_n(int nj);
<FOUND_FOSET>
    void   <prefix>_get_fout(int ni, <FOARGS>);
</FOUND_FOSET>
    int    <prefix>_get_number_of_pipelines(void);
    int    <prefix>_get_jmemsize(void);

    /*
     * primitive functions to control multiple cards individually.
     * the user needs to specify card's device id explicitly.
     */
    void   <prefix>_openMC(int devid);
    void   <prefix>_closeMC(int devid);
<FOUND_COEFFSET>
    void   <prefix>_set_coeffMC(int devid, <COEFFARGS>);
</FOUND_COEFFSET>
<FOUND_JPSET>
    void   <prefix>_set_jpMC(int devid, int adr, int nj, <JPARGS>);
</FOUND_JPSET>
<FOUND_IPSET>
    void   <prefix>_set_ipMC(int devid, int ni, <IPARGS>);
</FOUND_IPSET>
    void   <prefix>_runMC(int devid);
    void   <prefix>_set_nMC(int devid, int n);
<FOUND_FOSET>
    void   <prefix>_get_foutMC(int devid, int ni, <FOARGS>);
</FOUND_FOSET>
    int    <prefix>_get_number_of_pipelinesMC(int devid);
    int    <prefix>_get_jmemsizeMC(int devid);

<OLD_API_PROTOTYPE>

    /*
     * scaling functions
     */
<COEFFRANGE_PROTOTYPE>
<JPRANGE_PROTOTYPE>
<IPRANGE_PROTOTYPE>
<FORANGE_PROTOTYPE>

#if defined(__cplusplus)
}
#endif

#endif /* LANGUAGE_FORTRAN */

#endif /* <LIBNAME>_H */
