CC = gcc

CFLAGS = -g -O0 -o $@ <HEADERPATH>
LDFLAGS = <LIBPATH>
LIBOBJ = <libname>.o
TARGET = lib<prefix>emu.a <prefix>pipe

all:		$(TARGET)

lib<prefix>emu.a:	$(LIBOBJ) <prefix>util.h $(PGPG2PATH)/lib/libpgemu.a
		cp $(PGPG2PATH)/lib/libpgemu.a lib<prefix>emu.a
		ar ruv lib<prefix>emu.a $(LIBOBJ)
		ranlib lib<prefix>emu.a

<prefix>pipe:	$(LIBOBJ) <prefix>util.h $(PGPG2PATH)/lib/libpgemu.a
		$(CC) $(LDFLAGS) $(FLAGS) $(CFLAGS) -DMAINFUNC <libname>.c -l<prefix>emu -lm

<libname>.o:	<libname>.c <prefix>util.h
		$(CC) $(FLAGS) $(CFLAGS) -c <libname>.c

clean:
	-rm *.o *~ core $(TARGET)
	cd config && make clean;

bak:
	-tar cvfz <libname>.tar.gz ./*.[hc] ./*.pl ./*.csh ./*.awk ./Makefile
